/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.parsers;

import com.ibm.team.enterprise.automation.parsers.Messages;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.tools.ant.BuildException;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ContainerMappingDocument {
    public static String copyright = "(c) Copyright IBM Corp 2011.";
    public static String TAGNAME_MAPS = "maps";
    public static String TAGNAME_MAP = "map";
    public static String TAGNAME_SOURCECONTAINER = "sourcecontainer";
    public static String TAGNAME_TARGETCONTAINER = "targetcontainer";
    public static String ATTRIBUTE_MAP_TYPE = "type";
    public static String ATTRIBUTE_CONTAINER_NAME = "name";
    public static String MAP_TYPE_VALUE_PDS = "library";
    public static String MAP_TYPE_VALUE_IBMLIBRARY = "ibmilibrary";
    public static String MAP_TYPE_VALUE_DIRECTORY = "directory";
    private Document doc;
    Properties containerMappingProperties = new Properties();
    private ArrayList<ContainerMap> containerMaps = new ArrayList();

    public void parse(InputStream input) {
        if (this.doc == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                Schema schema = schemaFactory.newSchema(this.getSchemaURL());
                docFactory.setSchema(schema);
                docFactory.setNamespaceAware(true);
                DocumentBuilder parser = docFactory.newDocumentBuilder();
                if (input != null) {
                    this.doc = parser.parse(input);
                }
            }
            catch (Exception ex) {
                this.doc = null;
                if (input != null) {
                    throw new BuildException(NLS.bind((String)Messages.ContainerMappingDocument_EXCEPTION_PARSING_CONTAINER_MAPPING_ERROR_MSG, (Object)ex));
                }
                return;
            }
            this.doc.normalize();
        }
        if (this.doc != null && this.containerMaps.isEmpty()) {
            Element maps = this.doc.getDocumentElement();
            NodeList list = maps.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Element elem;
                if (list.item(i) instanceof Element && (elem = (Element)list.item(i)).getNodeName().equalsIgnoreCase(TAGNAME_MAP)) {
                    ContainerMap map = new ContainerMap();
                    map.setType(elem.getAttribute(ATTRIBUTE_MAP_TYPE));
                    NodeList containers = elem.getChildNodes();
                    int j = 0;
                    while (j < containers.getLength()) {
                        if (containers.item(j) instanceof Element) {
                            Element container = (Element)containers.item(j);
                            if (container.getNodeName().equalsIgnoreCase(TAGNAME_SOURCECONTAINER)) {
                                map.setSource(container.getAttribute(ATTRIBUTE_CONTAINER_NAME));
                            }
                            if (container.getNodeName().equalsIgnoreCase(TAGNAME_TARGETCONTAINER)) {
                                map.setTarget(container.getAttribute(ATTRIBUTE_CONTAINER_NAME));
                            }
                        }
                        ++j;
                    }
                    this.containerMaps.add(map);
                    if (map.getSource() != null && !map.getSource().equals("") && map.getTarget() != null && !map.getTarget().equals("")) {
                        String lib = map.getSource();
                        if (!lib.startsWith("\"")) {
                            lib = lib.toUpperCase();
                        }
                        this.containerMappingProperties.put(lib, map.getTarget());
                    }
                }
                ++i;
            }
        }
    }

    public void validate(InputStream input) throws Exception {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(this.getSchemaURL());
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(input);
        validator.validate(source);
    }

    public URL getSchemaURL() {
        return this.getClass().getResource("containerMapper.xsd");
    }

    public Properties getContainerMappingProperties() {
        return this.containerMappingProperties;
    }

    public ArrayList<ContainerMap> getContainerMaps() {
        return this.containerMaps;
    }

    public class ContainerMap {
        String type;
        String source;
        String target;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }
}

