/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.ant;

import com.ibm.team.build.ant.task.AbstractTeamBuildTask;
import com.ibm.team.enterprise.automation.internal.AutomationPasswordHelper;
import com.ibm.team.enterprise.build.ant.internal.utils.AuthenticationUtilities;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class RepositoryTask
extends Task {
    private String repositoryAddress;
    private String userId;
    private String passwordFile;
    private ITeamRepository repository = null;
    private File certificateFile = null;
    private File repositoryFile = null;
    private boolean smartCard = false;
    private boolean kerberos = false;
    private AbstractTeamBuildTask.AuthenticationPolicy authenticationPolicy = null;

    public void execute() throws BuildException {
        super.execute();
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException, FileNotFoundException, IOException {
        if (this.authenticationPolicy == null) {
            this.authenticationPolicy = AbstractTeamBuildTask.AuthenticationPolicy.USERNAME_PASSWORD_POLICY;
        }
        if (this.repository == null) {
            this.repository = AuthenticationUtilities.getLoggedInTeamRepository((Project)this.getProject(), (AbstractTeamBuildTask.AuthenticationPolicy)this.authenticationPolicy, (String)this.repositoryAddress, (String)this.userId, (File)new File(this.passwordFile), (File)this.certificateFile, (File)this.repositoryFile, (boolean)this.smartCard, (boolean)this.kerberos);
        }
        return this.repository;
    }

    protected String getPassword() throws TeamRepositoryException {
        if (this.passwordFile != null) {
            try {
                return this.decryptPassword(new File(this.passwordFile));
            }
            catch (Exception exception) {
                throw new TeamRepositoryException((Throwable)exception);
            }
        }
        return null;
    }

    protected String decryptPassword(File passwordFile) throws Exception {
        return AutomationPasswordHelper.getPassword((File)passwordFile);
    }

    public void setRepositoryAddress(String repositoryAddress) {
        this.repositoryAddress = repositoryAddress;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public void setCertificateFile(File certificateFile) {
        this.certificateFile = certificateFile;
    }

    public void setRepositoryFile(File repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public void setSmartCard(boolean smartCard) {
        this.smartCard = smartCard;
    }

    public void setAuthenticationPolicy(AbstractTeamBuildTask.AuthenticationPolicy policy) {
        this.authenticationPolicy = policy;
    }

    public void setKervberos(boolean kerberos) {
        this.kerberos = kerberos;
    }
}

