/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.manifest;

import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Manifest;
import com.ibm.team.enterprise.automation.manifest.Resource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CumulativeManifestWriter {
    private static CumulativeManifestWriter instance;

    private CumulativeManifestWriter() {
    }

    public static final CumulativeManifestWriter getInstance() {
        if (instance == null) {
            instance = new CumulativeManifestWriter();
        }
        return instance;
    }

    public void write(File file, Manifest deltaManifest, Manifest cumulativeMmanifest, boolean isRollback) throws Exception {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(file);
        this.write(stream, deltaManifest, cumulativeMmanifest, isRollback);
        stream.close();
    }

    public void write(OutputStream stream, Manifest deltaManifest, Manifest currentCumulativeMmanifest, boolean isRollback) throws Exception {
        Manifest cumulativeManifest = isRollback ? this.mergerRollbackWithCumulativeManifest(deltaManifest, currentCumulativeMmanifest) : this.mergerDeltaDeployWithCumulativeManifest(deltaManifest, currentCumulativeMmanifest);
        StreamResult streamResult = new StreamResult(stream);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("indent", "yes");
        try {
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serializer.setOutputProperty("encoding", "UTF-8");
        hd.setResult(streamResult);
        hd.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.clear();
        atts.addAttribute("", "", "type", "CDATA", cumulativeManifest.getType());
        hd.startElement("", "", "manifest", atts);
        Iterator<Container> containerIterator = cumulativeManifest.getCreatedContainersIterator();
        if (containerIterator.hasNext()) {
            atts.clear();
            hd.startElement("", "", "created", atts);
            this.writeContainers(hd, containerIterator);
            hd.endElement("", "", "created");
        }
        if ((containerIterator = cumulativeManifest.getUpdatedContainersIterator()).hasNext()) {
            atts.clear();
            hd.startElement("", "", "updated", atts);
            this.writeContainers(hd, containerIterator);
            hd.endElement("", "", "updated");
        }
        hd.endElement("", "", "manifest");
        hd.endDocument();
    }

    private void writeContainers(TransformerHandler hd, Iterator<Container> containerIterator) throws SAXException {
        while (containerIterator.hasNext()) {
            AttributesImpl atts = new AttributesImpl();
            Container container = containerIterator.next();
            atts.addAttribute("", "", "name", "CDATA", container.getName());
            atts.addAttribute("", "", "type", "CDATA", container.getType());
            String changeType = container.getChangeType();
            if (changeType != null) {
                atts.addAttribute("", "", "changeType", "CDATA", container.getChangeType());
            }
            hd.startElement("", "", "container", atts);
            Iterator<Resource> resourcesIterator = container.getResourcesIterator();
            while (resourcesIterator.hasNext()) {
                String ibmiAttr;
                String ibmiType;
                String lastModifiedTimestamp;
                String creationTimestamp;
                atts.clear();
                Resource resource = resourcesIterator.next();
                atts.addAttribute("", "", "name", "CDATA", resource.getName());
                atts.addAttribute("", "", "type", "CDATA", resource.getType());
                String size = resource.getSize();
                if (size != null) {
                    atts.addAttribute("", "", "size", "CDATA", size);
                }
                if ((creationTimestamp = resource.getCreationTimestamp()) != null) {
                    atts.addAttribute("", "", "creationTimestamp", "CDATA", creationTimestamp);
                }
                if ((lastModifiedTimestamp = resource.getLastModifiedTimestamp()) != null) {
                    atts.addAttribute("", "", "lastModifiedTimestamp", "CDATA", lastModifiedTimestamp);
                }
                if ((ibmiType = resource.getIbmiType()) != null) {
                    atts.addAttribute("", "", "IBMiType", "CDATA", ibmiType);
                }
                if ((ibmiAttr = resource.getIbmiType()) != null) {
                    atts.addAttribute("", "", "IBMiAttribute", "CDATA", ibmiAttr);
                }
                hd.startElement("", "", "resource", atts);
                hd.endElement("", "", "resource");
            }
            hd.endElement("", "", "container");
        }
    }

    private Manifest mergerRollbackWithCumulativeManifest(Manifest rollbackManifest, Manifest currentCumulativemanifest) {
        Container container;
        if (rollbackManifest == null) {
            return currentCumulativemanifest;
        }
        Iterator<Container> rollbackUpdatedContainerItr = rollbackManifest.getUpdatedContainersIterator();
        Iterator<Container> rollbackDeletedContainerItr = rollbackManifest.getDeletedContainersIterator();
        if (!rollbackUpdatedContainerItr.hasNext() && !rollbackDeletedContainerItr.hasNext()) {
            return currentCumulativemanifest;
        }
        Manifest cumulativeManifest = new Manifest();
        cumulativeManifest.setType("MANIFEST_REPORT");
        HashMap<String, Container> rollbackUpdatedContainerHashMap = new HashMap<String, Container>();
        while (rollbackUpdatedContainerItr.hasNext()) {
            container = rollbackUpdatedContainerItr.next();
            rollbackUpdatedContainerHashMap.put(container.getName(), container);
        }
        HashMap<String, Container> rollbackDeletedContainerHashMap = new HashMap<String, Container>();
        while (rollbackDeletedContainerItr.hasNext()) {
            container = rollbackDeletedContainerItr.next();
            rollbackDeletedContainerHashMap.put(container.getName(), container);
        }
        cumulativeManifest.setCreatedContainers(this.rollbackCreatedContainers(currentCumulativemanifest.getCreatedContainersIterator(), rollbackUpdatedContainerHashMap, rollbackDeletedContainerHashMap));
        cumulativeManifest.setUpdatedContainers(this.rollbackUpdatedContainers(currentCumulativemanifest.getUpdatedContainersIterator(), rollbackUpdatedContainerHashMap));
        return cumulativeManifest;
    }

    private Manifest mergerDeltaDeployWithCumulativeManifest(Manifest deltaDeployManifest, Manifest currentCumulativemanifest) {
        if (currentCumulativemanifest == null) {
            return deltaDeployManifest;
        }
        Iterator<Container> currentCumUpdatedContainerItr = currentCumulativemanifest.getUpdatedContainersIterator();
        Iterator<Container> currentCumCreatedContainerItr = currentCumulativemanifest.getCreatedContainersIterator();
        if (!currentCumUpdatedContainerItr.hasNext() && !currentCumCreatedContainerItr.hasNext()) {
            return deltaDeployManifest;
        }
        Manifest cumulativeManifest = new Manifest();
        cumulativeManifest.setType("MANIFEST_REPORT");
        Iterator<Container> deltaUpdatedContainerItr = deltaDeployManifest.getUpdatedContainersIterator();
        Iterator<Container> deltaCreatedContainerItr = deltaDeployManifest.getCreatedContainersIterator();
        HashMap<String, Container> deltaUpdatedContainerHashMap = new HashMap<String, Container>();
        while (deltaUpdatedContainerItr.hasNext()) {
            Container container = deltaUpdatedContainerItr.next();
            deltaUpdatedContainerHashMap.put(container.getName(), container);
        }
        cumulativeManifest.setCreatedContainers(this.mergeCreatedContainers(currentCumCreatedContainerItr, deltaCreatedContainerItr, deltaUpdatedContainerHashMap));
        cumulativeManifest.setUpdatedContainers(this.mergeUpdatedContainers(currentCumUpdatedContainerItr, deltaUpdatedContainerHashMap));
        return cumulativeManifest;
    }

    private List<Container> rollbackUpdatedContainers(Iterator<Container> currentCumContainerItr, HashMap<String, Container> rollbackUpdatedContainerHashMap) {
        ArrayList<Container> newContainers = new ArrayList<Container>();
        while (currentCumContainerItr.hasNext()) {
            Container currentContainer = currentCumContainerItr.next();
            Container rollbackContainer = rollbackUpdatedContainerHashMap.get(currentContainer.getName());
            if (rollbackContainer != null) {
                Resource rollabckResource;
                Iterator<Resource> currentResourceItr = currentContainer.getResourcesIterator();
                HashMap<String, Resource> rollbackResourceHashMap = new HashMap<String, Resource>();
                Iterator<Resource> rollbackUpdatedResourceItr = rollbackContainer.getResourcesIterator();
                while (rollbackUpdatedResourceItr.hasNext()) {
                    rollabckResource = rollbackUpdatedResourceItr.next();
                    rollbackResourceHashMap.put(this.getHashMapNameFromResource(rollabckResource), rollabckResource);
                }
                while (currentResourceItr.hasNext()) {
                    Resource currentResource = currentResourceItr.next();
                    rollabckResource = (Resource)rollbackResourceHashMap.get(this.getHashMapNameFromResource(currentResource));
                    if (rollabckResource == null) continue;
                    rollbackResourceHashMap.remove(this.getHashMapNameFromResource(rollabckResource));
                    currentResource.setLastModifiedTimestamp(rollabckResource.getLastModifiedTimestamp());
                    currentResource.setSize(rollabckResource.getSize());
                }
            }
            newContainers.add(currentContainer);
        }
        return newContainers;
    }

    private List<Container> rollbackCreatedContainers(Iterator<Container> currentCreatedContainerItr, HashMap<String, Container> rollbackUpdatedContainerHashMap, HashMap<String, Container> rollbackDeletedContainerHashMap) {
        ArrayList<Container> newContainers = new ArrayList<Container>();
        List<Container> currentCumContainerList = this.rollbackUpdatedContainers(currentCreatedContainerItr, rollbackUpdatedContainerHashMap);
        for (Container currentContainer : currentCumContainerList) {
            Container rollbackContainer = rollbackDeletedContainerHashMap.get(currentContainer.getName());
            if (rollbackContainer != null) {
                Resource rollbackResource;
                Iterator<Resource> currentResourceItr = currentContainer.getResourcesIterator();
                HashMap<String, Resource> rollbackResourceHashMap = new HashMap<String, Resource>();
                Iterator<Resource> rollbackDeletedResourceItr = rollbackContainer.getResourcesIterator();
                while (rollbackDeletedResourceItr.hasNext()) {
                    rollbackResource = rollbackDeletedResourceItr.next();
                    rollbackResourceHashMap.put(this.getHashMapNameFromResource(rollbackResource), rollbackResource);
                }
                ArrayList<Resource> removeCurrentResources = new ArrayList<Resource>();
                while (currentResourceItr.hasNext()) {
                    Resource currentResource = currentResourceItr.next();
                    rollbackResource = (Resource)rollbackResourceHashMap.get(this.getHashMapNameFromResource(currentResource));
                    if (rollbackResource == null) continue;
                    removeCurrentResources.add(currentResource);
                }
                for (Resource r : removeCurrentResources) {
                    currentContainer.removeResource(r);
                }
            }
            if (!currentContainer.getResourcesIterator().hasNext()) continue;
            newContainers.add(currentContainer);
        }
        return newContainers;
    }

    private List<Container> mergeUpdatedContainers(Iterator<Container> currentCumContainerItr, HashMap<String, Container> deltaContainerHashMap) {
        ArrayList<Container> newContainers = new ArrayList<Container>();
        while (currentCumContainerItr.hasNext()) {
            Container currentContainer = currentCumContainerItr.next();
            Container deltaContainer = deltaContainerHashMap.get(currentContainer.getName());
            if (deltaContainer != null) {
                Resource deltaResource;
                deltaContainerHashMap.remove(deltaContainer.getName());
                Iterator<Resource> currentResourceItr = currentContainer.getResourcesIterator();
                HashMap<String, Resource> deltaResourceHashMap = new HashMap<String, Resource>();
                Iterator<Resource> deltaUpdatedResourceItr = deltaContainer.getResourcesIterator();
                while (deltaUpdatedResourceItr.hasNext()) {
                    deltaResource = deltaUpdatedResourceItr.next();
                    deltaResourceHashMap.put(this.getHashMapNameFromResource(deltaResource), deltaResource);
                }
                ArrayList<Resource> addCurrentResources = new ArrayList<Resource>();
                ArrayList<Resource> removeCurrentResources = new ArrayList<Resource>();
                while (currentResourceItr.hasNext()) {
                    Resource currentResource = currentResourceItr.next();
                    deltaResource = (Resource)deltaResourceHashMap.get(this.getHashMapNameFromResource(currentResource));
                    if (deltaResource == null) continue;
                    deltaResourceHashMap.remove(this.getHashMapNameFromResource(deltaResource));
                    removeCurrentResources.add(currentResource);
                    addCurrentResources.add(deltaResource);
                }
                for (Resource r : removeCurrentResources) {
                    currentContainer.removeResource(r);
                }
                for (Resource r : addCurrentResources) {
                    currentContainer.addResource(r);
                }
                Collection newDeltaResourceCollection = deltaResourceHashMap.values();
                for (Resource newResource : newDeltaResourceCollection) {
                    currentContainer.addResource(newResource);
                }
            }
            newContainers.add(currentContainer);
        }
        Collection<Container> newDeltaContainerCollection = deltaContainerHashMap.values();
        for (Container newContainer : newDeltaContainerCollection) {
            newContainers.add(newContainer);
        }
        return newContainers;
    }

    private List<Container> mergeCreatedContainers(Iterator<Container> currentCreatedContainerItr, Iterator<Container> deltaCreatedContainerItr, HashMap<String, Container> deltaUpdatedContainerHashMap) {
        ArrayList<Container> newContainers = new ArrayList<Container>();
        while (deltaCreatedContainerItr.hasNext()) {
            newContainers.add(deltaCreatedContainerItr.next());
        }
        while (currentCreatedContainerItr.hasNext()) {
            Container currentContainer = currentCreatedContainerItr.next();
            Container deltaContainer = deltaUpdatedContainerHashMap.get(currentContainer.getName());
            ArrayList<Resource> addCurrentResources = new ArrayList<Resource>();
            ArrayList<Resource> removeCurrentResources = new ArrayList<Resource>();
            ArrayList<Resource> removeDeltaResources = new ArrayList<Resource>();
            if (deltaContainer != null) {
                Resource deltaResource;
                Iterator<Resource> currentResourceItr = currentContainer.getResourcesIterator();
                HashMap<String, Resource> deltaResourceHashMap = new HashMap<String, Resource>();
                Iterator<Resource> deltaUpdatedResourceItr = deltaContainer.getResourcesIterator();
                while (deltaUpdatedResourceItr.hasNext()) {
                    deltaResource = deltaUpdatedResourceItr.next();
                    deltaResourceHashMap.put(this.getHashMapNameFromResource(deltaResource), deltaResource);
                }
                while (currentResourceItr.hasNext()) {
                    Resource currentResource = currentResourceItr.next();
                    deltaResource = (Resource)deltaResourceHashMap.get(this.getHashMapNameFromResource(currentResource));
                    if (deltaResource == null) continue;
                    removeDeltaResources.add(deltaResource);
                    removeCurrentResources.add(currentResource);
                    addCurrentResources.add(deltaResource);
                }
                for (Resource r : removeDeltaResources) {
                    deltaContainer.removeResource(r);
                }
                for (Resource r : removeCurrentResources) {
                    currentContainer.removeResource(r);
                }
                for (Resource r : addCurrentResources) {
                    currentContainer.addResource(r);
                }
                if (!deltaContainer.getResourcesIterator().hasNext()) {
                    deltaUpdatedContainerHashMap.remove(deltaContainer.getName());
                }
            }
            newContainers.add(currentContainer);
        }
        return newContainers;
    }

    protected String getHashMapNameFromResource(Resource resource) {
        String name = resource.getName();
        String type = resource.getIbmiType();
        if (type != null && !type.equals("")) {
            name = String.valueOf(name) + " " + type;
        }
        return name;
    }
}

