/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.common.util;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PropertyParser {
    private static String tokenSeparator = ";";

    public static IVersionableHandle[] toVerionableHandles(String propertyValue) {
        String[] UUIDValues;
        if (propertyValue == null) {
            return new IVersionableHandle[0];
        }
        ArrayList<IVersionableHandle> handles = new ArrayList<IVersionableHandle>();
        String[] stringArray = UUIDValues = propertyValue.split(tokenSeparator);
        int n = UUIDValues.length;
        int n2 = 0;
        while (n2 < n) {
            String UUIDValue = stringArray[n2];
            UUID uuid = PropertyParser.getUUID(UUIDValue);
            if (uuid != null) {
                handles.add((IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(uuid, null));
            }
            ++n2;
        }
        return handles.toArray(new IVersionableHandle[handles.size()]);
    }

    public static String toString(IItemHandle[] handles) {
        StringBuffer aString = new StringBuffer();
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle handle = iItemHandleArray[n2];
            if (aString.length() > 0) {
                aString.append(tokenSeparator);
            }
            aString.append(handle.getItemId().getUuidValue());
            ++n2;
        }
        return aString.toString();
    }

    public static IWorkItemHandle[] toWorkItemHandles(String propertyValue) {
        String[] UUIDValues;
        if (propertyValue == null) {
            return new IWorkItemHandle[0];
        }
        ArrayList<IWorkItemHandle> handles = new ArrayList<IWorkItemHandle>();
        String[] stringArray = UUIDValues = propertyValue.split(tokenSeparator);
        int n = UUIDValues.length;
        int n2 = 0;
        while (n2 < n) {
            String UUIDValue = stringArray[n2];
            UUID uuid = PropertyParser.getUUID(UUIDValue);
            if (uuid != null) {
                handles.add((IWorkItemHandle)IWorkItem.ITEM_TYPE.createItemHandle(uuid, null));
            }
            ++n2;
        }
        return handles.toArray(new IWorkItemHandle[handles.size()]);
    }

    public static Set<String> toWorkItemUUIDs(String propertyValue) {
        String[] UUIDValues;
        if (propertyValue == null) {
            return new HashSet<String>();
        }
        HashSet<String> uuids = new HashSet<String>();
        String[] stringArray = UUIDValues = propertyValue.split(tokenSeparator);
        int n = UUIDValues.length;
        int n2 = 0;
        while (n2 < n) {
            String UUIDValue = stringArray[n2];
            uuids.add(UUIDValue);
            ++n2;
        }
        return uuids;
    }

    private static UUID getUUID(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        try {
            return UUID.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static List<Integer> toWorkItemNumbers(String propertyValue) {
        String[] wiNumbers;
        if (propertyValue == null) {
            return null;
        }
        ArrayList<Integer> workItemList = new ArrayList<Integer>();
        String[] stringArray = wiNumbers = propertyValue.split(tokenSeparator);
        int n = wiNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String wiNumber = stringArray[n2];
            workItemList.add(Integer.parseInt(wiNumber));
            ++n2;
        }
        return workItemList;
    }

    public static String intsToString(List<Integer> workItemNumbers) {
        StringBuffer aString = new StringBuffer();
        for (Integer workItemNumber : workItemNumbers) {
            if (aString.length() > 0) {
                aString.append(tokenSeparator);
            }
            aString.append(workItemNumber);
        }
        return aString.toString();
    }

    public static boolean isValidIntList(String propertyValue) {
        String[] wiNumbers;
        if (propertyValue == null) {
            return false;
        }
        String[] stringArray = wiNumbers = propertyValue.split(tokenSeparator);
        int n = wiNumbers.length;
        int n2 = 0;
        while (n2 < n) {
            String wiNumber = stringArray[n2];
            if (wiNumber.isEmpty()) {
                return false;
            }
            try {
                Integer wi = Integer.parseInt(wiNumber);
                if (wi == 0) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

