/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.common.jfs;

import com.ibm.team.enterprise.automation.common.jfs.IJFSParser;
import com.ibm.team.enterprise.automation.common.jfs.IJFSResource;
import com.ibm.team.enterprise.automation.common.jfs.JFSConstants;
import com.ibm.team.enterprise.automation.manifest.Container;
import com.ibm.team.enterprise.automation.manifest.Resource;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractJFSParser
implements IJFSParser,
JFSConstants {
    @Override
    public IJFSResource toJFSResource(InputStream inputStream) throws TeamRepositoryException {
        StringBuffer buffer = new StringBuffer();
        try {
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            byte[] bytes = new byte[1024];
            int count = 0;
            while ((count = bis.read(bytes)) > 0) {
                buffer.append(new String(bytes, 0, count));
            }
        }
        catch (IOException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.toJFSResource(buffer.toString());
    }

    protected static String getElementValue(Element parent, String name) {
        NodeList list = parent.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return "";
        }
        Element element = (Element)list.item(0);
        return element.getTextContent();
    }

    protected static Element createPropertyNode(Document doc, Element parent, String name, String value) {
        Element propertyElement = doc.createElement(name);
        parent.appendChild(propertyElement);
        if (value != null) {
            propertyElement.setTextContent(value);
        }
        return propertyElement;
    }

    protected static Element createXMLLiteralElement(Document doc, Element parent, String name) {
        Element literalElement = doc.createElement(name);
        parent.appendChild(literalElement);
        literalElement.setAttribute("rdf:parseType", "Literal");
        return literalElement;
    }

    protected static Element createRDFResourceElement(Document doc, Element parent, String name) {
        Element resourceElement = doc.createElement(name);
        parent.appendChild(resourceElement);
        resourceElement.setAttribute("rdf:parseType", "Resource");
        return resourceElement;
    }

    protected static void createContainerElements(Document doc, List<Container> containers, Element manifestElement) {
        for (Container container : containers) {
            Element containerElement = doc.createElement("manifest:container");
            manifestElement.appendChild(containerElement);
            containerElement.setAttribute("name", container.getName());
            containerElement.setAttribute("type", container.getType());
            String value = container.getChangeType();
            if (value != null && !value.equals("")) {
                containerElement.setAttribute("changeType", value);
            }
            AbstractJFSParser.createResourceElements(doc, containerElement, container);
        }
    }

    protected static void createResourceElements(Document doc, Element containerElement, Container container) {
        Iterator<Resource> iterator = container.getResourcesIterator();
        while (iterator.hasNext()) {
            Resource resource = iterator.next();
            Element resourceElement = doc.createElement("manifest:resource");
            containerElement.appendChild(resourceElement);
            resourceElement.setAttribute("name", resource.getName());
            resourceElement.setAttribute("type", resource.getType());
            String value = resource.getIbmiType();
            if (value != null && !value.equals("")) {
                resourceElement.setAttribute("subType", value);
            }
            if ((value = resource.getIbmiAttrribute()) != null && !value.equals("")) {
                resourceElement.setAttribute("attribute", value);
            }
            if ((value = resource.getWorkItemId()) != null && !value.equals("") && !value.equals("0")) {
                resourceElement.setAttribute("workItemId", value);
                resourceElement.setAttribute("workItemUUID", resource.getWorkitemUUID());
            }
            if ((value = resource.getLastModifiedTimestamp()) == null || value.equals("")) continue;
            resourceElement.setAttribute("lastModifiedTimestamp", value);
        }
    }

    protected static Document newDocument() throws ParserConfigurationException, IOException, SAXException {
        return AbstractJFSParser.newDocument(null);
    }

    protected static Document newDocument(InputStream xmlContent) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = xmlContent == null ? documentBuilderFactory.newDocumentBuilder().newDocument() : documentBuilderFactory.newDocumentBuilder().parse(xmlContent);
        return document;
    }

    protected static String transform(Document doc) throws TeamRepositoryException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
            StreamResult result = new StreamResult(outputStream);
            DOMSource source = new DOMSource(doc);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
            transformer.transform(source, result);
            return outputStream.toString("UTF-8");
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected Container parseContainer(Element containerElement) {
        Container container = new Container();
        container.setName(containerElement.getAttribute("name"));
        container.setType(containerElement.getAttribute("type"));
        String value = containerElement.getAttribute("changeType");
        if (!value.equals("")) {
            container.setChangeType(value);
        }
        NodeList resourceNodes = containerElement.getElementsByTagName("manifest:resource");
        int i = 0;
        while (i < resourceNodes.getLength()) {
            Element resourceElement = (Element)resourceNodes.item(i);
            container.addResource(this.parseResource(resourceElement));
            ++i;
        }
        return container;
    }

    protected Resource parseResource(Element resourceElement) {
        Resource resource = new Resource();
        resource.setName(resourceElement.getAttribute("name"));
        resource.setType(resourceElement.getAttribute("type"));
        String value = resourceElement.getAttribute("subType");
        if (!value.equals("")) {
            resource.setIbmiType(value);
        }
        if (!(value = resourceElement.getAttribute("attribute")).equals("")) {
            resource.setIbmiAttrribute(value);
        }
        if (!(value = resourceElement.getAttribute("workItemId")).equals("")) {
            resource.setWorkItemId(value);
        }
        if (!(value = resourceElement.getAttribute("workItemUUID")).equals("")) {
            resource.setWorkitemUUID(value);
        }
        if (!(value = resourceElement.getAttribute("lastModifiedTimestamp")).equals("")) {
            resource.setLastModifiedTimestamp(value);
        }
        return resource;
    }
}

