/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.common.internal.summary;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.enterprise.automation.common.internal.summary.AdditionalOutputsNode;
import com.ibm.team.enterprise.automation.common.internal.summary.ChangeSetNode;
import com.ibm.team.enterprise.automation.common.internal.summary.LinkedBuildableFileNode;
import com.ibm.team.enterprise.automation.common.internal.summary.OutputNode;
import com.ibm.team.enterprise.automation.common.internal.summary.SummaryNode;
import com.ibm.team.enterprise.automation.common.internal.summary.WorkItemNode;
import com.ibm.team.enterprise.automation.common.summary.IAdditionalOutputsNode;
import com.ibm.team.enterprise.automation.common.summary.IChangeSetNode;
import com.ibm.team.enterprise.automation.common.summary.ILinkedBuildableFileNode;
import com.ibm.team.enterprise.automation.common.summary.INode;
import com.ibm.team.enterprise.automation.common.summary.IOutputNode;
import com.ibm.team.enterprise.automation.common.summary.ISummaryNode;
import com.ibm.team.enterprise.automation.common.summary.IWorkItemNode;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.XMLUtil;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeFactory {
    private static NodeFactory instance;

    public static NodeFactory getInstance() {
        if (instance == null) {
            instance = new NodeFactory();
        }
        return instance;
    }

    public IWorkItemNode createWorkItemNode(INode parentNode, IWorkItem workItem) {
        WorkItemNode workItemNode = new WorkItemNode(parentNode, workItem.getItemId(), String.valueOf(workItem.getId()) + ":" + workItem.getHTMLSummary().getPlainText());
        parentNode.addChild(workItemNode);
        return workItemNode;
    }

    public IWorkItemNode createWorkItemNode(INode parentNode, String label) {
        WorkItemNode workItemNode = new WorkItemNode(parentNode, null, label);
        parentNode.addChild(workItemNode);
        return workItemNode;
    }

    public IAdditionalOutputsNode createAdditionalOutputsNode(INode parentNode) {
        AdditionalOutputsNode additionalOutputsNode = new AdditionalOutputsNode(parentNode, null);
        parentNode.addChild(additionalOutputsNode);
        return additionalOutputsNode;
    }

    public IChangeSetNode createChangeSetNode(INode parentNode, IChangeSet changeSet) {
        ChangeSetNode changeSetNode = new ChangeSetNode(parentNode, changeSet.getItemId(), this.getChangeSetDetail(changeSet), changeSet.getLastChangeDate());
        parentNode.addChild(changeSetNode);
        return changeSetNode;
    }

    public IChangeSetNode createChangeSetNode(IWorkItemNode parentNode, String uuid, String label) {
        ChangeSetNode changeSetNode = new ChangeSetNode(parentNode, UUID.valueOf((String)uuid), label);
        parentNode.addChild(changeSetNode);
        return changeSetNode;
    }

    public IOutputNode createOutputNode(INode parentNode, String label) {
        return this.createOutputNode(parentNode, label, false, "", true);
    }

    public IOutputNode createOutputNode(INode parentNode, String label, boolean isDeletion, String deployType, boolean isExactMatch) {
        OutputNode outputNode = new OutputNode(parentNode, label, isDeletion, deployType, isExactMatch);
        parentNode.addChild(outputNode);
        return outputNode;
    }

    public ISummaryNode createSummaryNode() {
        return new SummaryNode("");
    }

    public ILinkedBuildableFileNode createLinkedBuildableFileNode(INode parentNode, IVersionable versionable) {
        return this.createLinkedBuildableFileNode(parentNode, versionable.getName());
    }

    public ILinkedBuildableFileNode createLinkedBuildableFileNode(INode parentNode, String versionableName) {
        LinkedBuildableFileNode linkedBuildableFileNode = new LinkedBuildableFileNode(parentNode, versionableName);
        parentNode.addChild(linkedBuildableFileNode);
        return linkedBuildableFileNode;
    }

    private String getChangeSetDetail(IChangeSet changeSet) {
        String comment = changeSet.getComment();
        if (comment == null || comment.length() == 0) {
            comment = "<no comment>";
        }
        return String.valueOf(comment) + '-' + DateFormat.getDateTimeInstance().format(changeSet.getLastChangeDate());
    }

    private Element createElement(INode node, Document doc) {
        Element element;
        if (node.getType() == INode.Type.SUMMARY) {
            element = doc.createElement("summary");
        } else if (node.getType() == INode.Type.WORKITEM) {
            element = doc.createElement("workitem");
            element.setAttribute("label", node.getLabel());
        } else if (node.getType() == INode.Type.CHANGESET) {
            element = doc.createElement("changeset");
            element.setAttribute("label", node.getLabel());
            element.setAttribute("uuid", node.getNodeId().getUuidValue());
        } else if (node.getType() == INode.Type.OUTPUT) {
            element = doc.createElement("output");
            element.setAttribute("label", node.getLabel());
            element.setAttribute("isDeletion", Boolean.toString(((IOutputNode)node).isDeletion()));
            element.setAttribute("isExactMatch", Boolean.toString(((IOutputNode)node).isExactMatch()));
            element.setAttribute("deployType", ((IOutputNode)node).deployType());
        } else if (node.getType() == INode.Type.LINKED_ARTIFACT) {
            element = doc.createElement("linkedArtifact");
            element.setAttribute("label", node.getLabel());
        } else {
            element = node.getType() == INode.Type.ADDITIONAL_OUTPUTS ? doc.createElement("additionalOutputs") : null;
        }
        return element;
    }

    private INode createNode(Element element, INode parentNode) {
        INode node = element.getNodeName().equals("summary") ? this.createSummaryNode() : (element.getNodeName().equals("workitem") ? this.createWorkItemNode(parentNode, element.getAttribute("label")) : (element.getNodeName().equals("changeset") ? this.createChangeSetNode((IWorkItemNode)parentNode, element.getAttribute("uuid"), element.getAttribute("label")) : (element.getNodeName().equals("output") ? this.createOutputNode(parentNode, element.getAttribute("label"), Boolean.parseBoolean(element.getAttribute("isDeletion")), element.getAttribute("deployType"), Boolean.parseBoolean(element.getAttribute("isExactMatch"))) : (element.getNodeName().equals("linkedArtifact") ? this.createLinkedBuildableFileNode(parentNode, element.getAttribute("label")) : (element.getNodeName().equals("additionalOutputs") ? this.createAdditionalOutputsNode(parentNode) : null)))));
        return node;
    }

    public String toXML(ISummaryNode summaryNode) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element summaryElement = this.createElement(summaryNode, doc);
        doc.appendChild(summaryElement);
        this.recursivelyCreateElements(summaryNode.getChildren(), summaryElement, doc);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        StreamResult result = new StreamResult(outputStream);
        DOMSource source = new DOMSource(doc);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        transformer.transform(source, result);
        return outputStream.toString("UTF-8");
    }

    private void recursivelyCreateElements(List<INode> nodes, Element parentElement, Document doc) {
        for (INode node : nodes) {
            Element element = this.createElement(node, doc);
            parentElement.appendChild(element);
            List<INode> childrenNode = node.getChildren();
            if (childrenNode.size() <= 0) continue;
            this.recursivelyCreateElements(childrenNode, element, doc);
        }
    }

    public boolean hasOutputs(String xmlContent) throws Exception {
        Document doc = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(xmlContent.getBytes("UTF-8")));
        NodeList nodeList = doc.getElementsByTagName("output");
        return nodeList.getLength() != 0;
    }

    public ISummaryNode toSummary(String xmlContent) throws Exception {
        Document doc = XMLUtil.getSecureDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(xmlContent.getBytes("UTF-8")));
        Element summaryElement = (Element)doc.getElementsByTagName("summary").item(0);
        ValidationHelper.validateNotNull((String)"summary", (Object)summaryElement);
        ISummaryNode summaryNode = this.createSummaryNode();
        IAdditionalOutputsNode additionalOutputsNode = this.createAdditionalOutputsNode(summaryNode);
        NodeList nodeList = summaryElement.getChildNodes();
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getNodeName().equals("workitem")) {
                elements.add((Element)nodeList.item(i));
            } else if (nodeList.item(i).getNodeName().equals("additionalOutputs")) {
                this.addElementsToAdditionalOutputsNode(((Element)nodeList.item(i)).getChildNodes(), additionalOutputsNode);
            }
            ++i;
        }
        this.recursivelyCreateNodes(elements, summaryNode, additionalOutputsNode);
        if (!additionalOutputsNode.hasChildren()) {
            List<INode> nodes = summaryNode.getChildren();
            nodes.remove(additionalOutputsNode);
        }
        return summaryNode;
    }

    private void recursivelyCreateNodes(List<Element> elements, INode parentNode, INode additionalOutputsNode) {
        for (Element element : elements) {
            INode node = this.createNode(element, parentNode);
            ArrayList<Element> wiElements = new ArrayList<Element>();
            NodeList nodeList = element.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node childNode = nodeList.item(i);
                if (childNode.getNodeName().equals("changeset") || childNode.getNodeName().equals("output")) {
                    this.createNode((Element)childNode, node);
                } else if (childNode.getNodeName().equals("workitem")) {
                    wiElements.add((Element)childNode);
                } else if (childNode.getNodeName().equals("additionalOutputs")) {
                    this.addElementsToAdditionalOutputsNode(((Element)childNode).getChildNodes(), additionalOutputsNode);
                } else if (childNode.getNodeName().equals("linkedArtifact")) {
                    this.createNode((Element)childNode, node);
                }
                ++i;
            }
            this.recursivelyCreateNodes(wiElements, node, additionalOutputsNode);
        }
    }

    private void addElementsToAdditionalOutputsNode(NodeList nodeList, INode additionalOutputsNode) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeName().equals("output")) {
                this.createNode((Element)childNode, additionalOutputsNode);
            }
            ++i;
        }
    }
}

