/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.common.helper;

import java.io.File;

public class ShipListFileNameHelper {
    public static final String DOT_XML = ".xml";
    public static final String UNDERSCORE = "_";
    public static final String FILE_SEPARATOR_ZOS = "/";

    public static String constructShiplistName(Type shipListType, Phase phase, boolean isConcurrentSafe, String rootPath, String packageDefUUID, String packageLabel) {
        String returnedPath = rootPath;
        switch (phase) {
            case SERVER: {
                if (!rootPath.endsWith(FILE_SEPARATOR_ZOS) && !rootPath.endsWith("\\")) {
                    returnedPath = String.valueOf(rootPath) + File.separator;
                }
                returnedPath = isConcurrentSafe ? String.valueOf(returnedPath) + shipListType.prefix1() + packageDefUUID + UNDERSCORE + packageLabel + DOT_XML : String.valueOf(returnedPath) + shipListType.prefix1() + packageDefUUID + DOT_XML;
                return returnedPath;
            }
            case AGENT_INIT: {
                if (!rootPath.endsWith(FILE_SEPARATOR_ZOS) && !rootPath.endsWith("\\")) {
                    returnedPath = String.valueOf(rootPath) + FILE_SEPARATOR_ZOS;
                }
                returnedPath = isConcurrentSafe ? String.valueOf(returnedPath) + shipListType.prefix1() + packageDefUUID + UNDERSCORE + packageLabel + DOT_XML : (shipListType == Type.WORKITEM ? String.valueOf(returnedPath) + shipListType.prefix1() + packageDefUUID + DOT_XML : String.valueOf(returnedPath) + packageDefUUID + FILE_SEPARATOR_ZOS + shipListType.prefix1() + packageDefUUID + DOT_XML);
                return returnedPath;
            }
            case AGENT_CONVERT: {
                if (!rootPath.endsWith(FILE_SEPARATOR_ZOS) && !rootPath.endsWith("\\")) {
                    returnedPath = String.valueOf(rootPath) + File.separator;
                }
                if (isConcurrentSafe) {
                    returnedPath = String.valueOf(returnedPath) + packageDefUUID + File.separator + packageLabel + File.separator + shipListType.prefix2() + DOT_XML;
                } else {
                    returnedPath = shipListType == Type.WORKITEM ? String.valueOf(returnedPath) + packageDefUUID + File.separator + shipListType.prefix2() + DOT_XML : String.valueOf(returnedPath) + packageDefUUID + File.separator + shipListType.prefix2() + DOT_XML;
                    returnedPath = String.valueOf(returnedPath) + shipListType.prefix2() + packageDefUUID + DOT_XML;
                }
                return returnedPath;
            }
        }
        return null;
    }

    public static String constructRexxParmFileName(Phase phase, String rootPath, String packageDefUUID, boolean isDeployment) {
        String returnedPath = rootPath;
        switch (phase) {
            case SERVER: {
                if (!rootPath.endsWith(FILE_SEPARATOR_ZOS) && !rootPath.endsWith("\\")) {
                    returnedPath = String.valueOf(rootPath) + File.separator;
                }
                returnedPath = String.valueOf(returnedPath) + Type.REXX_PARM.prefix1();
                break;
            }
            case AGENT_INIT: {
                if (!rootPath.endsWith(FILE_SEPARATOR_ZOS) && !rootPath.endsWith("\\")) {
                    returnedPath = String.valueOf(rootPath) + FILE_SEPARATOR_ZOS;
                }
                if (isDeployment) {
                    returnedPath = String.valueOf(returnedPath) + Type.REXX_PARM.prefix1();
                    break;
                }
                returnedPath = String.valueOf(returnedPath) + packageDefUUID + FILE_SEPARATOR_ZOS + Type.REXX_PARM.prefix1();
                break;
            }
        }
        return returnedPath;
    }

    public static enum Phase {
        SERVER,
        AGENT_INIT,
        AGENT_CONVERT;

    }

    public static enum Type {
        WORKITEM("wiShiplist-", "shiplist"),
        INCLUDE("incl-shiplist-", "include-shiplist"),
        EXCLUDE("excl-shiplist-", "exclude-shiplist"),
        RESTORE_MAPPING("restore-mapping-", "restore-mapping-"),
        REXX_PARM("build.properties", "build.properties");

        private final String prefix1;
        private final String prefix2;

        private Type(String prefix1, String prefix2) {
            this.prefix1 = prefix1;
            this.prefix2 = prefix2;
        }

        public String prefix1() {
            return this.prefix1;
        }

        public String prefix2() {
            return this.prefix2;
        }
    }
}

