/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.common.helper;

import com.ibm.team.enterprise.automation.common.helper.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RestoreMappingParser {
    private List<Mapping> mappings;
    private MapType type;
    private String fEncoding;

    public RestoreMappingParser(String property, MapType type) throws Exception {
        this.fEncoding = type == MapType.PDS ? "IBM-1047" : "UTF-8";
        StringTokenizer st = new StringTokenizer(property, RestoreMappingParser.getMappingSeparator(type));
        if (st.countTokens() % 2 > 0) {
            throw new Exception(Messages.getCommonString("RestoreMappingParser.MISSING_TO_CONTAINER"));
        }
        this.type = type;
        this.mappings = new ArrayList<Mapping>();
        while (st.hasMoreTokens()) {
            String fromContainer = st.nextToken();
            String toContainer = st.nextToken();
            if (type == MapType.PDS) {
                this.mappings.add(new Mapping(fromContainer.toUpperCase(), toContainer.toUpperCase()));
                continue;
            }
            this.mappings.add(new Mapping(fromContainer, toContainer));
        }
    }

    public static String getMappingSeparator(MapType type) {
        if (type == MapType.PDS) {
            return ";";
        }
        if (type == MapType.IBMiLibrary) {
            return ";;";
        }
        return "|";
    }

    private String getEncoding() {
        return this.fEncoding;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public Document getAsDocument() throws ParserConfigurationException, IOException, SAXException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element mapsElement = doc.createElement("maps");
        doc.appendChild(mapsElement);
        for (Mapping mapping : this.mappings) {
            Element mapElement = doc.createElement("map");
            mapElement.setAttribute("type", this.type.name());
            mapsElement.appendChild(mapElement);
            Element sourceContainerElement = doc.createElement("sourceContainer");
            sourceContainerElement.setAttribute("name", mapping.fromContainer);
            mapElement.appendChild(sourceContainerElement);
            Element targetContainerElement = doc.createElement("targetContainer");
            targetContainerElement.setAttribute("name", mapping.toContainer);
            mapElement.appendChild(targetContainerElement);
        }
        return doc;
    }

    public void save(File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        StreamResult result = new StreamResult(fos);
        DOMSource source = new DOMSource(this.getAsDocument());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
        transformer.setOutputProperty("encoding", this.getEncoding());
        transformer.transform(source, result);
        fos.close();
    }

    public static enum MapType {
        PDS,
        IBMiLibrary,
        directory;

    }

    class Mapping {
        public String fromContainer;
        public String toContainer;

        public Mapping(String fromContainer, String toContainer) {
            this.fromContainer = fromContainer;
            this.toContainer = toContainer;
        }
    }
}

