/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.common.helper;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssNlsHelper {
    private static final String UTF_8 = "UTF-8";
    private static final String MSG_PATTERN_STRING = "(.*)(\\$\\{[0-9a-zA-Z_]*})(.*)";
    private static final Pattern MSG_PATTERN = Pattern.compile("(.*)(\\$\\{[0-9a-zA-Z_]*})(.*)");
    private final ResourceBundle resourceBundle;

    public CssNlsHelper(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public InputStream getTranslatedContent(InputStream is) throws UnsupportedEncodingException, IOException {
        StringBuffer sb = null;
        if (is != null) {
            sb = new StringBuffer();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(is, UTF_8));
                while ((line = reader.readLine()) != null) {
                    sb.append(this.resourceBundle != null ? this.translate(line) : line);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
                is.close();
            }
        }
        return sb == null ? is : new ByteArrayInputStream(sb.toString().getBytes(UTF_8));
    }

    private String translate(String line) {
        Matcher matcher;
        String s = line;
        while ((matcher = MSG_PATTERN.matcher(s)).find()) {
            String key = matcher.group(2);
            key = key.substring(2, key.length() - 1);
            try {
                key = this.resourceBundle.getString(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            s = String.valueOf(matcher.group(1)) + key + matcher.group(3);
        }
        return s;
    }
}

