/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2014. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.jdojox.util.TreeMap");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("dojo.string");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var string= dojo.string;

/**
 * A tree which contains a map to all entries in the tree
 * 
 * @param <T>
 *            The data value to store in the tree
 */
var TreeMap= dojo.declare("com.ibm.jdojox.util.TreeMap", null, {
	"-chains-": { constructor: "manual" },

	/**
	 * A pointer to the root element of the map
	 */
	//root: null,

	/**
	 * A map to all elements in the table
	 */
	//elements: null,

	/**
	 * Creates a new tree map
	 */
	constructor: function() {
		this.elements= {};
	},

	/**
	 * Clear the tree and set a new root element
	 * 
	 * @param identifier
	 *            The identifier of the root
	 * @param data
	 *            The data to set on the root
	 * @return The newly created root element
	 */
	setRoot: function(identifier, data) {
		this.clear();
		this.root= new TreeMapElement(identifier, data, this, null);
		this.elements[identifier]= this.root;
		return this.root;
	},

	/**
	 * Clears the tree
	 */
	clear: function() {
		if (this.root != null) {
			this.root.removeRecursively();
			this.root.fTreeMap= null;
		}
		this.elements= {};
		this.root= null;
	},

	/**
	 * Gets the size of the tree
	 * 
	 * @return
	 */
	getSize: function() {
		return jdojo.getValues(this.elements).length;
	},

	/**
	 * Gets the root element of the tree
	 * 
	 * @return The root element of the tree
	 */
	getRoot: function() {
		return this.root;
	},

	/**
	 * Finds an element on the tree by its identifier
	 * 
	 * @param identifier
	 *            The identifier to look for
	 * @return The element on the tree
	 */
	getElementByIdentifier: function(identifier) {
		return this.elements[identifier];
	},

	/**
	 * Gets a map of all the elements in the tree
	 */
	getElements: function() {
		return this.elements;
	}
});
/**
 * An individual element on the tree
 * 
 * @param <T>
 *            The data value to store in the tree
 */
var TreeMapElement= dojo.declare("com.ibm.jdojox.util.TreeMap.TreeMapElement", null, {
	"-chains-": { constructor: "manual" },

	/**
	 * The identifier of the element
	 */
	//fIdentifier: null,

	/**
	 * A pointer to the tree map, if null it means the element has no linked
	 * map
	 */
	//fTreeMap: null,

	/**
	 * A pointer to the element's parent, if null it means the element has
	 * no parent
	 */
	//fParent: null,

	/**
	 * A list of the element's children
	 */
	//fChildren: null,

	/**
	 * The data to store in the element
	 */
	//fData: null,

	/**
	 * A basic constructor
	 * 
	 * @param identifier
	 *            The identifier of the element
	 * @param data
	 *            The data to store in the element
	 * @param treeMap
	 *            A pointer to the tree map
	 * @param parent
	 *            A pointer to the element's parent, null mean root element
	 */
	constructor: function(identifier, data, treeMap, parent) {
		this.fIdentifier= identifier;
		this.fData= data;
		this.fTreeMap= treeMap;
		this.fParent= parent;
		this.fChildren= [];
	},

	/**
	 * Adds a child at a specific index
	 * 
	 * @param identifier
	 *            The identifier of the element
	 * @param data
	 *            The data to store in the element
	 * @param index
	 *            The index to place the element
	 * @return The newly created element
	 */
	addChildAtIndex: function(identifier, data, index) {
		if (this.fTreeMap != null && this.fTreeMap.elements[identifier] != null) {
			console.error(string.substitute(TreeMap.TreeMap_ERROR_IDENTIFIER_CONFLICT, [identifier ]));
		} else if (index > this.fChildren.length) {
			console.error(string.substitute(TreeMap.TreeMap_ERROR_INDEX_OUT_OF_RANGE, [index , this.fChildren.length]));
		} else if (index === this.fChildren.length) {
			return this.addChildAtEnd(identifier, data);
		} else {
			var element= new TreeMapElement(identifier, data, this.fTreeMap, this);
			this.fChildren.splice(index, 0, element);
			if (this.fTreeMap != null) {
				this.fTreeMap.elements[identifier]= element;
			}
			return element;
		}
		return null;
	},

	/**
	 * Adds a child at the end
	 * 
	 * @param identifier
	 *            The identifier of the element
	 * @param data
	 *            The data to store in the element
	 * @return The newly created element
	 */
	addChildAtEnd: function(identifier, data) {
		if (this.fTreeMap != null && this.fTreeMap.elements[identifier] != null) {
			console.error(string.substitute(TreeMap.TreeMap_ERROR_IDENTIFIER_CONFLICT, [identifier ]));
		} else {
			var element= new TreeMapElement(identifier, data, this.fTreeMap, this);
			this.fChildren.push(element);
			if (this.fTreeMap != null) {
				this.fTreeMap.elements[identifier]= element;
			}
			return element;
		}
		return null;
	},

	/**
	 * Gets a child at a specific index
	 * 
	 * @param index
	 *            The index to retrieve from
	 * @return The child at that index
	 */
	getChildByIndex: function(index) {
		if (this.fChildren.length <= index) {
			console.error(string.substitute(TreeMap.TreeMap_ERROR_INDEX_OUT_OF_RANGE, [index , this.fChildren.length]));
		} else {
			return this.fChildren[index];
		}
		return null;
	},

	/**
	 * Gets the index of this element in its parent
	 * 
	 * @return The index in its parent, null if the element has no parent
	 */
	getIndexInParent: function() {
		if (this.fParent != null) {
			var i= 0;
			var $subject= this.fParent.fChildren;
			var $length= $subject.length;
			for (var $count= 0; $count < $length; $count++){
				var sibling= $subject[$count];
				if (sibling === this) {
					return i;
				}
				i++;
			}
		}
		return null;
	},

	/**
	 * Recursively removes all children from the tree
	 */
	removeRecursively: function() {
		if (this.fTreeMap != null) {
			var $subject2= this.fChildren;
			var $length2= $subject2.length;
			for (var $count2= 0; $count2 < $length2; $count2++){
				var child= $subject2[$count2];
				child.removeRecursively();
			}
			delete this.fTreeMap.elements[this.fIdentifier];
			this.fTreeMap= null;
		}
	},

	/**
	 * Removes the current element from the tree
	 */
	remove: function() {
		if (this.fTreeMap != null && this.fTreeMap.getRoot() === this) {
			this.fTreeMap.clear();
		} else {
			this.removeRecursively();
			if (this.fParent != null) {
				this.fParent.fChildren.splice(this.getIndexInParent(), 1);
				this.fParent= null;
			}
		}
	},

	getIdentifier: function() {
		return this.fIdentifier;
	},

	/**
	 * Gets the current tree
	 * 
	 * @return The current tree, or null if the element belongs to no tree
	 *         (occurs after removing the element or its parent)
	 */
	getTree: function() {
		return this.fTreeMap;
	},

	/**
	 * Gets the current parent
	 * 
	 * @return The current parent, or null if the element has no parent
	 *         (occurs if the element is root or after removing the element)
	 */
	getParent: function() {
		return this.fParent;
	},

	/**
	 * Gets a list of all the element's children
	 * 
	 * @return A list of all the element's children
	 */
	getChildren: function() {
		return this.fChildren;
	},

	/**
	 * Sets the data on the element
	 * 
	 * @param data
	 *            The data to set
	 */
	setData: function(data) {
		this.fData= data;
	},

	/**
	 * Gets the data from an element
	 * 
	 * @return The data on the element
	 */
	getData: function() {
		return this.fData;
	},

	$interfaces: {
		'com.ibm.jdojo.util.IMappable': true
	}
});

TreeMap.TreeMap_ERROR_INDEX_OUT_OF_RANGE= "Index <${0}> is out of range <${1}>.";
TreeMap.TreeMap_ERROR_IDENTIFIER_CONFLICT= "Identifier <${0}> conflicts with existing element.";

})();
