/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2015. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.jdojox.util.SortedMap");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.jdojox.util.OrderedMap");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var OrderedMap= com.ibm.jdojox.util.OrderedMap;

/**
 * A map which keeps its elements in a sorted order
 * 
 * @param <T>
 *            The type of element being stored
 */
dojo.declare("com.ibm.jdojox.util.SortedMap", null, {
	"-chains-": { constructor: "manual" },

	/**
	 * All elements are stored in an ordered map
	 */
	//fMap: null,

	/**
	 * The compariator used for sorting the elements
	 */
	//fCompare: null,

	/**
	 * A basic constructor
	 * 
	 * @param map
	 *            The intial map to load into the map
	 * @param compare
	 *            The compariator used for sorting the map
	 */
	constructor: function(map, compare) {
		this.fMap= new OrderedMap();
		this.fCompare= compare;
		if (map != null) {
			var $subject= jdojo.getProperties(map);
			var $length= $subject.length;
			for (var $count= 0; $count < $length; $count++){
				var s= $subject[$count];
				this.addElement(s, map[s]);
			}
		}
	},

	/**
	 * Adds an element to the array. O(log(n) + 2)
	 * 
	 * @param element
	 *            The element to add to the array
	 * @param sortable
	 *            The sortable value which determines the element's position
	 */
	addElement: function(identifier, element) {
		var arraySize= this.fMap.getSize();
		if (arraySize === 0) {
			this.fMap.addElementAtEnd(identifier, element);
		} else if (arraySize === 1) {
			if (this.fCompare(this.fMap.getElementByIndex(0), element) <= 0) {
				this.fMap.addElementAtEnd(identifier, element);
			} else {
				this.fMap.addElementAtIndex(identifier, element, 0);
			}
		} else {
			var bottomPosition= 0;
			var topPosition= arraySize - 1;
			var currentElement= this.fMap.getElementByIndex(bottomPosition);
			if (this.fCompare(currentElement, element) >= 0) {
				this.fMap.addElementAtIndex(identifier, element, 0);
			} else {
				currentElement= this.fMap.getElementByIndex(topPosition);
				if (this.fCompare(currentElement, element) <= 0) {
					this.fMap.addElementAtEnd(identifier, element);
				} else {
					while(true){
						var currentPosition= (((Math.floor((((topPosition - bottomPosition) / 2)|0)) + bottomPosition))|0);
						if (currentPosition === bottomPosition) {
							this.fMap.addElementAtIndex(identifier, element, bottomPosition + 1);
							break;
						} else {
							currentElement= this.fMap.getElementByIndex(currentPosition);
							var compare= this.fCompare(currentElement, element);
							if (compare === 0) {
								this.fMap.addElementAtIndex(identifier, element, currentPosition + 1);
								break;
							} else if (compare < 0) {
								bottomPosition= currentPosition;
							} else {
								topPosition= currentPosition;
							}
						}
					}
				}
			}
		}
	},

	/**
	 * Gets an element by an identifier.
	 * 
	 * @param identifier
	 *            The identifier to look up the element by
	 * @return The element which the id is located at, Undefined.VALUE() if no
	 *         such element is found
	 */
	getElementByIdentifier: function(identifier) {
		return this.fMap.getElementByIdentifier(identifier);
	},

	/**
	 * Gets an element by an index
	 * 
	 * @param index
	 *            The index to look up the element by
	 * @return The element which the index is located at, Undefined.VALUE() if
	 *         no such element is found
	 */
	getElementByIndex: function(index) {
		return this.fMap.getElementByIndex(index);
	},

	/**
	 * Gets an identifier by an index
	 * 
	 * @param index
	 *            The index to look up the id by
	 * @return The identifier which the index is located at, Undefined.VALUE()
	 *         if no such element is found
	 */
	getIdentifierByIndex: function(index) {
		return this.fMap.getIdentifierByIndex(index);
	},

	/**
	 * Gets an index by an identifier.
	 * 
	 * <b>Note:</b> Could be slow, it may require reindexing.
	 * 
	 * @param identifier
	 *            The identifier to look up the index by
	 * @return The index which the id is located at, -1 if no such element is
	 *         found
	 */
	getIndexByIdentifier: function(identifier) {
		return this.fMap.getIndexByIdentifier(identifier);
	},

	iterator: function() {
		return this.fMap.iterator();
	},

	/**
	 * Gets the size of the array
	 */
	getSize: function() {
		return this.fMap.getSize();
	},

	/**
	 * Removes all elements in the array
	 */
	clear: function() {
		this.fMap.clear();
	},

	/**
	 * Determines if the element with the specific identifier exists
	 * 
	 * @param identifier
	 *            The identifier to look up the element by
	 * @return True if the element exists, false otherwise
	 */
	hasElementWithIdentifier: function(identifier) {
		return this.fMap.hasElementWithIdentifier(identifier);
	},

	/**
	 * Removes an element by its index.
	 * 
	 * <b>Note:</b> Unless last element is removed, will require reindexing to
	 * correct getIndexByIdentifier(...).
	 * 
	 * @param index
	 *            The index which to remove an element by
	 * @return The removed element, Undefined.VALUE() if element does not exist
	 */
	removeElementByIndex: function(index) {
		return this.fMap.removeElementByIndex(index);
	},

	/**
	 * Removes an element by its identifier.
	 * 
	 * <b>Note:</b> Could be slow, it may require reindexing. <b>Note:</b>
	 * Unless last element is removed, will require reindexing to correct
	 * getIndexByIdentifier(...).
	 * 
	 * @param identifier
	 *            The identifier which to remove an element by
	 * @return The removed element, Undefined.VALUE() if element does not exist
	 */
	removeElementByIdentifier: function(identifier) {
		return this.fMap.removeElementByIdentifier(identifier);
	},

	$interfaces: {
		'com.ibm.jdojox.util.IIterable': true
	}
});

})();
