/*******************************************************************************
 * Licensed Materials - Property of IBM
 * © Copyright IBM Corporation 2015. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp. 
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.jdojox.util.OrderedMappedGraph");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.jdojox.util.OrderedMap");
dojo.require("dojo.string");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var OrderedMap= com.ibm.jdojox.util.OrderedMap;
var string= dojo.string;

/**
 * A graph with the following properties: <br/>
 * <br/>
 * 1) An array that gives an order through all its elements <br/>
 * 2) A map that maps all of its elements <br/>
 * 3) A bidirectional (Parent -> Child) graph for all nodes <br/>
 * <br/>
 * <b>Note:</b> The order uses the whole tree and does not have to start at a
 * root node
 * 
 * @param <T>
 *            The data value to store in the graph
 */
var OrderedMappedGraph= dojo.declare("com.ibm.jdojox.util.OrderedMappedGraph", null, {
	"-chains-": { constructor: "manual" },

	/**
	 * Contains a list of all elements in the graph
	 */
	//fMap: null,

	/**
	 * Contains a list of all root nodes who are in a loop
	 */
	//fLoopRoots: null,

	/**
	 * Contains a list of all root nodes who are not in a loop
	 */
	//fRoots: null,

	/**
	 * A basic constructor
	 */
	constructor: function() {
		this.fMap= new OrderedMap();
		this.fRoots= {};
		this.fLoopRoots= {};
	},

	/**
	 * Gets an node by its identifier
	 * 
	 * @param identifier
	 *            The identifier to look up
	 * @return The node which matches the identifier
	 */
	getNodeByIdentifier: function(identifier) {
		return this.fMap.getElementByIdentifier(identifier);
	},

	/**
	 * Gets an node by its index
	 * 
	 * @param index
	 *            The index to look up
	 * @return The node which matches the index
	 */
	getNodeByIndex: function(index) {
		return this.fMap.getElementByIndex(index);
	},

	/**
	 * Determines if the identifier exists in the graph
	 * 
	 * @param identifier
	 *            The identifier to look up
	 * @return True if the node exists, false otherwise
	 */
	hasNodeWithIdentifier: function(identifier) {
		return this.fMap.hasElementWithIdentifier(identifier);
	},

	/**
	 * Gets the number of nodes in the graph
	 */
	getSize: function() {
		return this.fMap.getSize();
	},

	/**
	 * Gets a list of all the nodes in the graph in order
	 */
	getArray: function() {
		return this.fMap.getValueArray();
	},

	/**
	 * Creates a graph node
	 * 
	 * @param identifier
	 *            The identifier for the graph node
	 * @param element
	 *            The value to store in the node
	 * @return The newly created node
	 */
	_createGraphNode: function(identifier, element) {
		return new OrderedMappedGraphNode(this, identifier, element);
	},

	/**
	 * Adds a new node at a specific index
	 * 
	 * @param parentNode
	 *            The parent to place the node under
	 * @param newNode
	 *            The node which was created
	 * @param index
	 *            The index to place the node at
	 * @return The newly created node, null if the node already exists
	 */
	_addNodeAtIndex: function(parentNode, newNode, index) {
		if (this.fMap.addElementAtIndex(newNode.getIdentifier(), newNode, index)) {
			if (!this.addRelationship(parentNode, newNode) && this.fRoots != null) {
				this.fRoots[newNode.getIdentifier()]= newNode;
			}
			return newNode;
		}
		return null;
	},

	/**
	 * Adds an node at the end index
	 * 
	 * @param identifier
	 *            The identifier for the graph node
	 * @param element
	 *            The value to store in the node
	 * @return The newly created node
	 */
	addNodeAtEnd: function(identifier, element) {
		return this._addNodeAtIndex(null, this._createGraphNode(identifier, element), this.getSize());
	},

	/**
	 * Adds an node at the end index
	 * 
	 * @param parentNode
	 *            The parent to place the node under
	 * @param identifier
	 *            The identifier for the graph node
	 * @param element
	 *            The value to store in the node
	 * @return The newly created node
	 */
	addNodeAtEndUnderParent: function(parentNode, identifier, element) {
		return this._addNodeAtIndex(parentNode, this._createGraphNode(identifier, element), this.getSize());
	},

	/**
	 * Adds an node at a specific index
	 * 
	 * @param identifier
	 *            The identifier for the graph node
	 * @param index
	 *            The index to place the node at
	 * @param element
	 *            The value to store in the node
	 * @return The newly created node
	 */
	addNodeAtIndex: function(identifier, index, element) {
		return this._addNodeAtIndex(null, this._createGraphNode(identifier, element), index);
	},

	/**
	 * Adds an node at a specific index
	 * 
	 * @param parentNode
	 *            The parent to place the node under
	 * @param identifier
	 *            The identifier for the graph node
	 * @param index
	 *            The index to place the node at
	 * @param element
	 *            The value to store in the node
	 * @return The newly created node
	 */
	addNodeAtIndexUnderParent: function(parentNode, identifier, index, element) {
		return this._addNodeAtIndex(parentNode, this._createGraphNode(identifier, element), index);
	},

	/**
	 * Moves a node in the graph to a new position
	 * 
	 * @param node
	 *            The node to reposition
	 * @param newPosition
	 *            The new index to place the node at
	 */
	reorderNode: function(node, newPosition) {
		if (newPosition != null && (newPosition < 0 || newPosition > (this.fMap.getSize() - 1))) {
			console.error(string.substitute(OrderedMappedGraph.OrderedMappedGraph_ERROR_INDEX_OUT_OF_RANGE, [newPosition , this.getSize()]));
		} else {
			var currentIndex= node.getIndex();
			if (newPosition == null) {
				if (currentIndex !== this.fMap.getSize() - 1) {
					this.fMap.removeElementByIndex(currentIndex);
					this.fMap.addElementAtEnd(node.getIdentifier(), node);
				}
			} else {
				if (currentIndex !== newPosition) {
					this.fMap.removeElementByIndex(currentIndex);
					this.fMap.addElementAtIndex(node.getIdentifier(), node, newPosition);
				}
			}
		}
	},

	/**
	 * Adds a relationship between two nodes
	 * 
	 * @param parent
	 *            The parent in the relationship
	 * @param child
	 *            The child in the relationship
	 * @return True if a new relationship was created, false otherwise
	 */
	addRelationship: function(parent, child) {
		if (parent != null && child != null) {
			return child.addParent(parent);
		}
		return false;
	},

	/**
	 * Determines if a relationship exists between two nodes
	 * 
	 * @param parent
	 *            The parent in the relationship
	 * @param child
	 *            The child in the relationship
	 * @return True if the relationship exists, false otherwise
	 */
	hasRelationship: function(parent, child) {
		if (parent != null && child != null) {
			return child.hasParent(parent);
		}
		return false;
	},

	/**
	 * Removes a relationship between two nodes
	 * 
	 * @param parent
	 *            The parent in the relationship
	 * @param child
	 *            The child in the relationship
	 * @return True if a relationship was removed, false otherwise
	 */
	removeRelationship: function(parent, child) {
		if (parent != null && child != null) {
			return child.removeParent(parent);
		}
		return false;
	},

	/**
	 * Removes all relationships from a node
	 * 
	 * @param graphNode
	 *            The node to remove all relationships from
	 * @return The value being stored at the node
	 */
	_removeAllRelationships: function(graphNode) {
		if (graphNode == null) {
			return undefined;
		}
		var $subject= jdojo.getValues(graphNode.getParents());
		var $length= $subject.length;
		for (var $count= 0; $count < $length; $count++){
			var parent= $subject[$count];
			this.removeRelationship(parent, graphNode);
		}
		var $subject2= jdojo.getValues(graphNode.getChildren());
		var $length2= $subject2.length;
		for (var $count2= 0; $count2 < $length2; $count2++){
			var child= $subject2[$count2];
			this.removeRelationship(graphNode, child);
		}
		if (this.fRoots != null) {
			delete this.fRoots[graphNode.getIdentifier()];
		}
		return graphNode.getElement();
	},

	/**
	 * Removes a node from the graph
	 * 
	 * @param identifier
	 *            The identifier of the node
	 * @return The value being stored at the node
	 */
	removeNodeByIdentifier: function(identifier) {
		return this._removeAllRelationships(this.fMap.removeElementByIdentifier(identifier));
	},

	/**
	 * Removes a node from the graph
	 * 
	 * @param index
	 *            The index of the node
	 * @return The value being stored at the node
	 */
	removeNodeByIndex: function(index) {
		return this._removeAllRelationships(this.fMap.removeElementByIndex(index));
	},

	/**
	 * Removes all nodes from the graph
	 */
	clear: function() {
		this.fMap.clear();
		this.fRoots= {};
		this.fLoopRoots= {};
	},

	/**
	 * A complex function which loops through all nodes and determines their
	 * root node (if in a loop with no exit, will be the lowest value node in
	 * loop)
	 * 
	 * @param currentElement
	 *            The current Element the check for root nodes
	 * @param lowestElement
	 *            The lowest value element found on the current path
	 * @param elementsVisited
	 *            A map which maps the identifier of a visited element with the
	 *            node of its root element
	 * @return The root element found on the current path
	 */
	_getRootElementWhenBranchIsLoop: function(currentElement, lowestElement, elementsVisited) {
		if (currentElement.getParentCount() === 0) {
			return currentElement;
		} else if ((currentElement.getIdentifier() in elementsVisited)) {
			var graphNode= elementsVisited[currentElement.getIdentifier()];
			if ((typeof (graphNode) !== 'undefined')) {
				return graphNode;
			}
			return lowestElement;
		}
		elementsVisited[currentElement.getIdentifier()]= undefined;
		if (currentElement.getIndex() < lowestElement.getIndex()) {
			lowestElement= currentElement;
		}
		var $subject3= jdojo.getValues(currentElement.getParents());
		var $length3= $subject3.length;
		for (var $count3= 0; $count3 < $length3; $count3++){
			var parent= $subject3[$count3];
			var lowest= this._getRootElementWhenBranchIsLoop(parent, lowestElement, elementsVisited);
			if (lowest.getParentCount() === 0) {
				lowestElement= lowest;
				break;
			} else if (lowest.getIndex() < lowestElement.getIndex()) {
				lowestElement= lowest;
			}
		}
		elementsVisited[currentElement.getIdentifier()]= lowestElement;
		return lowestElement;
	},

	/**
	 * Sets the roots and the loop root nodes for every node in the graph. O(n)
	 */
	_setRootNodesAndLowestLoopNodes: function() {
		if (this.fLoopRoots == null) {
			this.fRoots= {};
			this.fLoopRoots= {};
			var elementsVisited= {};
			var $subject4= this.fMap.getValueArray();
			var $length4= $subject4.length;
			for (var $count4= 0; $count4 < $length4; $count4++){
				var values= $subject4[$count4];
				var graphNode= this._getRootElementWhenBranchIsLoop(values, values, elementsVisited);
				if (graphNode.getParentCount() === 0) {
					this.fRoots[graphNode.getIdentifier()]= graphNode;
				} else {
					this.fLoopRoots[graphNode.getIdentifier()]= graphNode;
				}
			}
		}
	},

	/**
	 * Gets all the root nodes in the graph, in no specific order. <br />
	 * <br />
	 * <b>Note:</b> Place into SortedArray constructor to get items in order.
	 */
	getRootNodes: function() {
		this._setRootNodesAndLowestLoopNodes();
		return this.fRoots;
	},

	/**
	 * Gets the head of a loop node (a node which is the lowest value in a loop
	 * with no exits), in no specific order. <br />
	 * <br />
	 * <b>Note:</b> Place into SortedArray constructor to get items in order.
	 */
	getLoopHeadNodes: function() {
		this._setRootNodesAndLowestLoopNodes();
		return this.fLoopRoots;
	}
});
/**
 * An individual node on the graph
 * 
 * @param <T>
 *            The data value to store in the graph
 */
var OrderedMappedGraphNode= dojo.declare("com.ibm.jdojox.util.OrderedMappedGraph.OrderedMappedGraphNode", null, {
	"-chains-": { constructor: "manual" },

	/**
	 * The graph which the node belongs
	 */
	//fGraph: null,

	/**
	 * The identifier of the current node
	 */
	//fIdentifier: null,

	/**
	 * The element of the current node
	 */
	//fElement: null,

	/**
	 * The parents of the current node
	 */
	//fParents: null,

	/**
	 * The children of the current node
	 */
	//fChildren: null,

	/**
	 * Creates a node in the graph
	 * 
	 * @param graph
	 *            The graph the node belongs to
	 * @param identifier
	 *            The identifier of the node
	 * @param element
	 *            The value to store in the node
	 */
	constructor: function(graph, identifier, element) {
		this.fGraph= graph;
		this.fIdentifier= identifier;
		this.fElement= element;
		this.fParents= {};
		this.fChildren= {};
	},

	/**
	 * Gets the graph the node belongs to
	 */
	getGraph: function() {
		if (this.fGraph == null || !this.fGraph.hasNodeWithIdentifier(this.getIdentifier())) {
			this.fGraph= undefined;
		}
		return this.fGraph;
	},

	getIdentifier: function() {
		return this.fIdentifier;
	},

	/**
	 * Gets the index of the element in the graph
	 */
	getIndex: function() {
		var graph= this.getGraph();
		if (graph == null) {
			return -1;
		}
		return graph.fMap.getIndexByIdentifier(this.getIdentifier());
	},

	/**
	 * Gets the value stored in the current node
	 */
	getElement: function() {
		return this.fElement;
	},

	/**
	 * Sets the value stored in the current node
	 * 
	 * @param element
	 *            The new value of the element in the current node
	 */
	setElement: function(element) {
		this.fElement= element;
	},

	/**
	 * Gets all the parent relationships to the node, in no specific order. <br />
	 * <br />
	 * <b>Note:</b> Place into SortedArray constructor to get items in
	 * order.
	 */
	getParents: function() {
		return this.fParents;
	},

	/**
	 * Gets all the children relationships to the node, in no specific
	 * order. <br />
	 * <br />
	 * <b>Note:</b> Place into SortedArray constructor to get items in
	 * order.
	 */
	getChildren: function() {
		return this.fChildren;
	},

	/**
	 * Gets a count of all the parent relationships
	 */
	getParentCount: function() {
		return jdojo.getProperties(this.fParents).length;
	},

	/**
	 * Gets a count of all the child relationships
	 */
	getChildCount: function() {
		return jdojo.getProperties(this.fChildren).length;
	},

	/**
	 * Adds a parent to the current node
	 * 
	 * @param parent
	 *            The parent to add
	 * @return True if a new relationship was add, false otherwise
	 */
	addParent: function(parent) {
		if (parent != null && !this.hasParent(parent)) {
			var graph= this.getGraph();
			if (graph === parent.getGraph()) {
				if (graph != null) {
					graph.fLoopRoots= null;
					graph.fRoots= null;
				}
				parent.fChildren[this.getIdentifier()]= this;
				this.fParents[parent.getIdentifier()]= parent;
				return true;
			}
		}
		return false;
	},

	/**
	 * Determines if the current node has a specific parent
	 * 
	 * @param parent
	 *            The parent to look for
	 * @return True if the parent -> child relationship exists, false
	 *         otherwise
	 */
	hasParent: function(parent) {
		return parent.fChildren[this.getIdentifier()] === this;
	},

	/**
	 * Removes a parent from the current node
	 * 
	 * @param parent
	 *            The parent to remove
	 * @return True if a relationship was deleted, false otherwise
	 */
	removeParent: function(parent) {
		if (parent != null && this.hasParent(parent)) {
			var graph= this.getGraph();
			if (graph != null) {
				graph.fLoopRoots= null;
				graph.fRoots= null;
			}
			delete parent.fChildren[this.getIdentifier()];
			delete this.fParents[parent.getIdentifier()];
			return true;
		}
		return false;
	},

	$interfaces: {
		'com.ibm.jdojo.util.IMappable': true
	}
});

OrderedMappedGraph.OrderedMappedGraph_ERROR_INDEX_OUT_OF_RANGE= "Index <${0}> is out of range <${1}>.";

})();
