/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.jdojox.util.JDojoX");

dojo.require("com.ibm.jdojo.lang.Runtime");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;

var JDojoX= dojo.declare("com.ibm.jdojox.util.JDojoX", null, {
	"-chains-": { constructor: "manual" }
});

JDojoX.isEqual= function(o1, o2) {
	if (jdojo.implementsInterface(o1, "com.ibm.jdojox.util.IEqualable")) {
		return o1.equals(o2);
	} else if (dojo.isArray(o1)) {
		return JDojoX._equalArrays(o1, o2);
	} else if (o1 instanceof Date) {
		return JDojoX._equalDates(o1, o2);
	} else if (JDojoX._isPlainObject(o1)) {
		return JDojoX._equalPlainObjects(o1, o2);
	}
	return o1 === o2;
};
JDojoX._equalArrays= function(arg1, arg2) {
	if (!dojo.isArray(arg1) || !dojo.isArray(arg2)) {
		return false;
	}
	var a1= arg1;
	var a2= arg2;
	if (a1.length !== a2.length) {
		return false;
	}
	var result= true;
	for (var i= 0; i < a1.length; i++){
		result= result && JDojoX.isEqual(a1[i], a2[i]);
		if (!result) {
			break;
		}
	}
	return result;
};
JDojoX._equalDates= function(arg1, arg2) {
	if (!(arg1 instanceof Date)) {
		return false;
	}
	if (!(arg2 instanceof Date)) {
		return false;
	}
	var d1= arg1;
	var d2= arg2;
	return d1.getTime() === d2.getTime();
};
JDojoX._equalPlainObjects= function(arg1, arg2) {
	if (!JDojoX._isPlainObject(arg1) || !JDojoX._isPlainObject(arg2)) {
		return false;
	}
	var props1= jdojo.getProperties(arg1);
	var props2= jdojo.getProperties(arg2);
	props1.sort();
	props2.sort();
	if (!JDojoX.isEqual(props1, props2)) {
		return false;
	}
	var result= true;
	var $subject= props1;
	var $length= $subject.length;
	for (var $count= 0; $count < $length; $count++){
		var property= $subject[$count];
		result= result && JDojoX.isEqual(arg1[property], arg2[property]);
		if (!result) {
			break;
		}
	}
	return result;
};
JDojoX._isPlainObject= function(arg1) {
	return dojo.indexOf(jdojo.getProperties(arg1), "declaredClass") < 0 && dojo.isObject(arg1) && !dojo.isFunction(arg1);
};

})();
