/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2013. All Rights Reserved. 
 * 
 * Note to U.S. Government Users Restricted Rights:  Use, 
 * duplication or disclosure restricted by GSA ADP Schedule 
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.jdojox.util.Collections");

dojo.require("com.ibm.jdojo.lang.JavaScriptException");
dojo.require("com.ibm.jdojox.util.ArrayList");
dojo.require("com.ibm.jdojox.util.JDojoX");

(function() {
var JavaScriptException= com.ibm.jdojo.lang.JavaScriptException;
var util= com.ibm.jdojox.util;
var ArrayList= util.ArrayList;
var JDojoX= util.JDojoX;

var Collections= dojo.declare("com.ibm.jdojox.util.Collections", null, {
	"-chains-": { constructor: "manual" }
});
var UnmodifiableIterator= dojo.declare("com.ibm.jdojox.util.Collections.UnmodifiableIterator", null, {
	"-chains-": { constructor: "manual" },

	//_iterator: null,

	constructor: function(iterator) {
		this._iterator= iterator;
	},

	hasNext: function() {
		return this._iterator.hasNext();
	},

	next: function() {
		return this._iterator.next();
	},

	remove: function() {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	$interfaces: {
		'com.ibm.jdojox.util.IIterator': true
	}
});
var UnmodifiableList= dojo.declare("com.ibm.jdojox.util.Collections.UnmodifiableList", null, {
	"-chains-": { constructor: "manual" },

	//_list: null,

	constructor: function(list) {
		this._list= list;
	},

	contains: function(object) {
		return this._list.contains(object);
	},

	containsAll: function(other) {
		return this._list.containsAll(other);
	},

	isEmpty: function() {
		return this._list.isEmpty();
	},

	size: function() {
		return this._list.size();
	},

	toArray: function() {
		return this._list.toArray();
	},

	iterator: function() {
		return new UnmodifiableIterator(this._list.iterator());
	},

	at: function(index) {
		return this._list.at(index);
	},

	addAt: function(index, object) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	addAllAt: function(index, other) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	removeAt: function(index) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	indexOf: function(object) {
		return this._list.indexOf(object);
	},

	add: function(object) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	addAll: function(other) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	clear: function() {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	remove: function(object) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	removeAll: function(other) {
		throw new JavaScriptException("Unsupported operation iterator.remove()");
	},

	equals: function(o) {
		return JDojoX.isEqual(this._list, o);
	},

	$interfaces: {
		'com.ibm.jdojox.util.ICollection': true,
		'com.ibm.jdojox.util.IEqualable': true,
		'com.ibm.jdojox.util.IIterable': true,
		'com.ibm.jdojox.util.IList': true
	}
});

Collections.emptyList= function() {
	return Collections.unmodifiableList(new ArrayList());
};
Collections.unmodifiableList= function(list) {
	return new UnmodifiableList(list);
};
Collections.unmodifiableIterator= function(iterator) {
	return new UnmodifiableIterator(iterator);
};

})();
