/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2013. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:  Use,
 * duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
// NOTE: THIS IS A GENERATED FILE. DO NOT EDIT DIRECTLY!
dojo.provide("com.ibm.jdojox.util.ArrayList");

dojo.require("com.ibm.jdojo.lang.Runtime");
dojo.require("com.ibm.jdojox.util.IllegalStateException");
dojo.require("com.ibm.jdojox.util.JDojoX");

(function() {
var jdojo= com.ibm.jdojo.lang.Runtime;
var util= com.ibm.jdojox.util;
var IllegalStateException= util.IllegalStateException;
var JDojoX= util.JDojoX;

dojo.declare("com.ibm.jdojox.util.ArrayList", null, {
	"-chains-": { constructor: "manual" },

	//_contents: null,

	constructor: function(other) {
		this._contents= [];
		if (other != null) {
			var $subject= other;
			var $length= $subject.length;
			for (var $count= 0; $count < $length; $count++){
				var e= $subject[$count];
				this.add(e);
			}
		}
	},

	add: function(object) {
		this._contents.push(object);
		return this;
	},

	contains: function(object) {
		return this.indexOf(object) > -1;
	},

	containsAll: function(other) {
		var result= true;
		for (var $it= other.iterator(); $it.hasNext();) {
			var object= $it.next();
			result= result && this.contains(object);
		}
		return result;
	},

	isEmpty: function() {
		return this.size() === 0;
	},

	size: function() {
		return this._contents.length;
	},

	toArray: function() {
		return this._contents.slice(0);
	},

	iterator: function() {
		return new Iterator(this);
	},

	at: function(index) {
		this._rangeCheck(index, false);
		return this._contents[index];
	},

	addAt: function(index, object) {
		this._rangeCheck(index, true);
		this._contents.splice(index, 0, object);
		return this;
	},

	addAllAt: function(index, other) {
		this._rangeCheck(index, true);
		var it= other.iterator();
		var i= index;
		while(it.hasNext()){
			this.addAt(i++, it.next());
		}
		return this;
	},

	removeAt: function(index) {
		this._rangeCheck(index, false);
		var removed= this._contents.splice(index, 1);
		return removed[0];
	},

	indexOf: function(object) {
		var index= 0;
		var $subject2= this._contents;
		var $length2= $subject2.length;
		for (var $count2= 0; $count2 < $length2; $count2++){
			var e= $subject2[$count2];
			if (JDojoX.isEqual(e, object)) {
				return index;
			}
			index++;
		}
		return -1;
	},

	addAll: function(other) {
		var it= other.iterator();
		while(it.hasNext()){
			this.add(it.next());
		}
		return this;
	},

	clear: function() {
		this._contents= [];
		return this;
	},

	remove: function(object) {
		var index= this.indexOf(object);
		if (index > -1) {
			this.removeAt(index);
		}
		return this;
	},

	removeAll: function(other) {
		var it= other.iterator();
		while(it.hasNext()){
			var index= this.indexOf(it.next());
			if (index > -1) {
				this.removeAt(index);
			}
		}
		return this;
	},

	_rangeCheck: function(index, inclusiveEnd) {
		if (index < 0) {
			throw new IllegalStateException("Index cannot be smaller than 0");
		}
		if (inclusiveEnd && index > this.size()) {
			throw new IllegalStateException("Index cannot be bigger than the size of the collection");
		}
		if (!inclusiveEnd && index > this.size() - 1) {
			throw new IllegalStateException("Index cannot be bigger than the index of the last element (size - 1)");
		}
	},

	equals: function(object) {
		if (this === object) {
			return true;
		}
		if (jdojo.implementsInterface(object, "com.ibm.jdojox.util.IList")) {
			var list= object;
			if (list.size() !== this.size()) {
				return false;
			}
			var it1= this.iterator(), it2= list.iterator();
			while(it1.hasNext()){
				var e1= it1.next(), e2= it2.next();
				if (!(e1 == null ? e2 == null : JDojoX.isEqual(e1, e2))) {
					return false;
				}
			}
			return true;
		}
		return false;
	},

	$interfaces: {
		'com.ibm.jdojox.util.ICollection': true,
		'com.ibm.jdojox.util.IEqualable': true,
		'com.ibm.jdojox.util.IIterable': true,
		'com.ibm.jdojox.util.IList': true
	}
});
var Iterator= dojo.declare("com.ibm.jdojox.util.ArrayList.Iterator", null, {
	"-chains-": { constructor: "manual" },

	//_curIndex: null,

	//_removable: null,

	//_list: null,

	constructor: function(_list) {
		this._curIndex= -1;
		this._list= _list;
	},

	hasNext: function() {
		return this._curIndex < this._list.size() - 1;
	},

	next: function() {
		if (!this.hasNext()) {
			throw new IllegalStateException("There are no next element in the list");
		}
		this._curIndex++;
		this._removable= true;
		return this._list.at(this._curIndex);
	},

	remove: function() {
		if (!this._removable) {
			throw new IllegalStateException("next() was not called before remove()");
		}
		this._list.removeAt(this._curIndex);
		this._removable= false;
		this._curIndex--;
	},

	$interfaces: {
		'com.ibm.jdojox.util.IIterator': true
	}
});

})();
