/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.lang.Console;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.IMappable;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.NLS;

public class TreeMap<T>
extends DojoObject {
    private TreeMapElement<T> root;
    private final JSMap<TreeMapElement<T>> elements = new JSMap();
    private static final String TreeMap_ERROR_INDEX_OUT_OF_RANGE = "Index <${0}> is out of range <${1}>.";
    private static final String TreeMap_ERROR_IDENTIFIER_CONFLICT = "Identifier <${0}> conflicts with existing element.";

    public TreeMapElement<T> setRoot(String identifier, T data) {
        this.clear();
        this.root = new TreeMapElement<T>(identifier, data, this, null);
        this.elements.put(identifier, this.root);
        return this.root;
    }

    public void clear() {
        if (this.root != null) {
            this.root.removeRecursively();
            ((TreeMapElement)this.root).fTreeMap = null;
        }
        this.elements.clear();
        this.root = null;
    }

    public int getSize() {
        return ((TreeMapElement[])this.elements.values()).length;
    }

    public TreeMapElement<T> getRoot() {
        return this.root;
    }

    public TreeMapElement<T> getElementByIdentifier(String identifier) {
        return (TreeMapElement)((Object)this.elements.get(identifier));
    }

    public JSMap<TreeMapElement<T>> getElements() {
        return this.elements;
    }

    public static class TreeMapElement<T>
    extends DojoObject
    implements IMappable {
        private final String fIdentifier;
        private TreeMap<T> fTreeMap;
        private TreeMapElement<T> fParent;
        private final JSArray<TreeMapElement<T>> fChildren;
        private T fData;

        protected TreeMapElement(String identifier, T data, TreeMap<T> treeMap, TreeMapElement<T> parent) {
            this.fIdentifier = identifier;
            this.fData = data;
            this.fTreeMap = treeMap;
            this.fParent = parent;
            this.fChildren = new JSArray();
        }

        public TreeMapElement<T> addChildAtIndex(String identifier, T data, int index) {
            if (this.fTreeMap != null && ((TreeMap)this.fTreeMap).elements.get(identifier) != null) {
                Console.error((Object)NLS.bind((String)TreeMap.TreeMap_ERROR_IDENTIFIER_CONFLICT, (Object)identifier, (Object[])new Object[0]));
            } else if (index > this.fChildren.length) {
                Console.error((Object)NLS.bind((String)TreeMap.TreeMap_ERROR_INDEX_OUT_OF_RANGE, (Object)index, (Object[])new Object[]{this.fChildren.length}));
            } else {
                if (index == this.fChildren.length) {
                    return this.addChildAtEnd(identifier, data);
                }
                TreeMapElement<T> element = new TreeMapElement<T>(identifier, data, this.fTreeMap, this);
                this.fChildren.splice(index, 0, (Object[])new TreeMapElement[]{element});
                if (this.fTreeMap != null) {
                    ((TreeMap)this.fTreeMap).elements.put(identifier, element);
                }
                return element;
            }
            return null;
        }

        public TreeMapElement<T> addChildAtEnd(String identifier, T data) {
            if (this.fTreeMap == null || ((TreeMap)this.fTreeMap).elements.get(identifier) == null) {
                TreeMapElement<T> element = new TreeMapElement<T>(identifier, data, this.fTreeMap, this);
                this.fChildren.push(element);
                if (this.fTreeMap != null) {
                    ((TreeMap)this.fTreeMap).elements.put(identifier, element);
                }
                return element;
            }
            Console.error((Object)NLS.bind((String)TreeMap.TreeMap_ERROR_IDENTIFIER_CONFLICT, (Object)identifier, (Object[])new Object[0]));
            return null;
        }

        public TreeMapElement<T> getChildByIndex(int index) {
            if (this.fChildren.length > index) {
                return (TreeMapElement)((Object)this.fChildren.get(index));
            }
            Console.error((Object)NLS.bind((String)TreeMap.TreeMap_ERROR_INDEX_OUT_OF_RANGE, (Object)index, (Object[])new Object[]{this.fChildren.length}));
            return null;
        }

        public Integer getIndexInParent() {
            if (this.fParent != null) {
                int i = 0;
                TreeMapElement[] treeMapElementArray = (TreeMapElement[])this.fParent.fChildren.toArray();
                int n = treeMapElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeMapElement sibling = treeMapElementArray[n2];
                    if (sibling == this) {
                        return i;
                    }
                    ++i;
                    ++n2;
                }
            }
            return null;
        }

        protected void removeRecursively() {
            if (this.fTreeMap != null) {
                TreeMapElement[] treeMapElementArray = (TreeMapElement[])this.fChildren.toArray();
                int n = treeMapElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeMapElement child = treeMapElementArray[n2];
                    child.removeRecursively();
                    ++n2;
                }
                ((TreeMap)this.fTreeMap).elements.remove(this.fIdentifier);
                this.fTreeMap = null;
            }
        }

        public void remove() {
            if (this.fTreeMap != null && this.fTreeMap.getRoot() == this) {
                this.fTreeMap.clear();
            } else {
                this.removeRecursively();
                if (this.fParent != null) {
                    this.fParent.fChildren.splice(this.getIndexInParent().intValue(), 1);
                    this.fParent = null;
                }
            }
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public TreeMap<T> getTree() {
            return this.fTreeMap;
        }

        public TreeMapElement<T> getParent() {
            return this.fParent;
        }

        public TreeMapElement<T>[] getChildren() {
            return (TreeMapElement[])this.fChildren.toArray();
        }

        public void setData(T data) {
            this.fData = data;
        }

        public T getData() {
            return this.fData;
        }
    }
}

