/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.JSMath;
import com.ibm.jdojox.util.IIterable;
import com.ibm.jdojox.util.IIterator;
import com.ibm.jdojox.util.KeyValuePair;
import com.ibm.jdojox.util.OrderedMap;

public class SortedMap<T>
extends DojoObject
implements IIterable<KeyValuePair<String, T>> {
    private OrderedMap<T> fMap = new OrderedMap();
    private JSArray.IComparator<T> fCompare;

    public SortedMap(JSMap<T> map, JSArray.IComparator<T> compare) {
        this.fCompare = compare;
        if (map != null) {
            String[] stringArray = map.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.addElement(s, map.get(s));
                ++n2;
            }
        }
    }

    public void addElement(String identifier, T element) {
        int arraySize = this.fMap.getSize();
        if (arraySize == 0) {
            this.fMap.addElementAtEnd(identifier, element);
        } else if (arraySize == 1) {
            if (this.fCompare.compare(this.fMap.getElementByIndex(0), element) <= 0) {
                this.fMap.addElementAtEnd(identifier, element);
            } else {
                this.fMap.addElementAtIndex(identifier, element, 0);
            }
        } else {
            int bottomPosition = 0;
            int topPosition = arraySize - 1;
            T currentElement = this.fMap.getElementByIndex(bottomPosition);
            if (this.fCompare.compare(currentElement, element) >= 0) {
                this.fMap.addElementAtIndex(identifier, element, 0);
            } else {
                currentElement = this.fMap.getElementByIndex(topPosition);
                if (this.fCompare.compare(currentElement, element) <= 0) {
                    this.fMap.addElementAtEnd(identifier, element);
                } else {
                    while (true) {
                        int currentPosition;
                        if ((currentPosition = (int)(JSMath.floor((double)((topPosition - bottomPosition) / 2)) + (double)bottomPosition)) == bottomPosition) {
                            this.fMap.addElementAtIndex(identifier, element, bottomPosition + 1);
                            break;
                        }
                        currentElement = this.fMap.getElementByIndex(currentPosition);
                        int compare = this.fCompare.compare(currentElement, element);
                        if (compare == 0) {
                            this.fMap.addElementAtIndex(identifier, element, currentPosition + 1);
                            break;
                        }
                        if (compare < 0) {
                            bottomPosition = currentPosition;
                            continue;
                        }
                        topPosition = currentPosition;
                    }
                }
            }
        }
    }

    public T getElementByIdentifier(String identifier) {
        return this.fMap.getElementByIdentifier(identifier);
    }

    public T getElementByIndex(int index) {
        return this.fMap.getElementByIndex(index);
    }

    public String getIdentifierByIndex(int index) {
        return this.fMap.getIdentifierByIndex(index);
    }

    public int getIndexByIdentifier(String identifier) {
        return this.fMap.getIndexByIdentifier(identifier);
    }

    @Override
    public IIterator<KeyValuePair<String, T>> iterator() {
        return this.fMap.iterator();
    }

    public int getSize() {
        return this.fMap.getSize();
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean hasElementWithIdentifier(String identifier) {
        return this.fMap.hasElementWithIdentifier(identifier);
    }

    public T removeElementByIndex(int index) {
        return this.fMap.removeElementByIndex(index);
    }

    public T removeElementByIdentifier(String identifier) {
        return this.fMap.removeElementByIdentifier(identifier);
    }
}

