/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.lang.Console;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.reflection.Undefined;
import com.ibm.jdojo.util.IMappable;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.NLS;
import com.ibm.jdojox.util.OrderedMap;

public class OrderedMappedGraph<T>
extends DojoObject {
    private static final String OrderedMappedGraph_ERROR_INDEX_OUT_OF_RANGE = "Index <${0}> is out of range <${1}>.";
    private OrderedMap<OrderedMappedGraphNode<T>> fMap = new OrderedMap();
    private JSMap<OrderedMappedGraphNode<T>> fLoopRoots;
    private JSMap<OrderedMappedGraphNode<T>> fRoots = new JSMap();

    public OrderedMappedGraph() {
        this.fLoopRoots = new JSMap();
    }

    public OrderedMappedGraphNode<T> getNodeByIdentifier(String identifier) {
        return this.fMap.getElementByIdentifier(identifier);
    }

    public OrderedMappedGraphNode<T> getNodeByIndex(int index) {
        return this.fMap.getElementByIndex(index);
    }

    public boolean hasNodeWithIdentifier(String identifier) {
        return this.fMap.hasElementWithIdentifier(identifier);
    }

    public int getSize() {
        return this.fMap.getSize();
    }

    public JSArray<OrderedMappedGraphNode<T>> getArray() {
        return new JSArray(this.fMap.getValueArray());
    }

    private OrderedMappedGraphNode<T> _createGraphNode(String identifier, T element) {
        return new OrderedMappedGraphNode(this, identifier, element);
    }

    private OrderedMappedGraphNode<T> _addNodeAtIndex(OrderedMappedGraphNode<T> parentNode, OrderedMappedGraphNode<T> newNode, int index) {
        if (this.fMap.addElementAtIndex(newNode.getIdentifier(), newNode, index)) {
            if (!this.addRelationship(parentNode, newNode) && this.fRoots != null) {
                this.fRoots.put(newNode.getIdentifier(), newNode);
            }
            return newNode;
        }
        return null;
    }

    public OrderedMappedGraphNode<T> addNodeAtEnd(String identifier, T element) {
        return this._addNodeAtIndex(null, this._createGraphNode(identifier, element), this.getSize());
    }

    public OrderedMappedGraphNode<T> addNodeAtEndUnderParent(OrderedMappedGraphNode<T> parentNode, String identifier, T element) {
        return this._addNodeAtIndex(parentNode, this._createGraphNode(identifier, element), this.getSize());
    }

    public OrderedMappedGraphNode<T> addNodeAtIndex(String identifier, int index, T element) {
        return this._addNodeAtIndex(null, this._createGraphNode(identifier, element), index);
    }

    public OrderedMappedGraphNode<T> addNodeAtIndexUnderParent(OrderedMappedGraphNode<T> parentNode, String identifier, int index, T element) {
        return this._addNodeAtIndex(parentNode, this._createGraphNode(identifier, element), index);
    }

    public void reorderNode(OrderedMappedGraphNode<T> node, Integer newPosition) {
        if (newPosition != null && (newPosition < 0 || newPosition > this.fMap.getSize() - 1)) {
            Console.error((Object)NLS.bind((String)OrderedMappedGraph_ERROR_INDEX_OUT_OF_RANGE, (Object)newPosition, (Object[])new Object[]{this.getSize()}));
        } else {
            int currentIndex = node.getIndex();
            if (newPosition == null) {
                if (currentIndex != this.fMap.getSize() - 1) {
                    this.fMap.removeElementByIndex(currentIndex);
                    this.fMap.addElementAtEnd(node.getIdentifier(), node);
                }
            } else if (currentIndex != newPosition) {
                this.fMap.removeElementByIndex(currentIndex);
                this.fMap.addElementAtIndex(node.getIdentifier(), node, newPosition);
            }
        }
    }

    public boolean addRelationship(OrderedMappedGraphNode<T> parent, OrderedMappedGraphNode<T> child) {
        if (parent != null && child != null) {
            return child.addParent(parent);
        }
        return false;
    }

    public boolean hasRelationship(OrderedMappedGraphNode<T> parent, OrderedMappedGraphNode<T> child) {
        if (parent != null && child != null) {
            return child.hasParent(parent);
        }
        return false;
    }

    public boolean removeRelationship(OrderedMappedGraphNode<T> parent, OrderedMappedGraphNode<T> child) {
        if (parent != null && child != null) {
            return child.removeParent(parent);
        }
        return false;
    }

    private T _removeAllRelationships(OrderedMappedGraphNode<T> graphNode) {
        if (graphNode == null) {
            return (T)Undefined.VALUE();
        }
        OrderedMappedGraphNode[] orderedMappedGraphNodeArray = (OrderedMappedGraphNode[])graphNode.getParents().values();
        int n = orderedMappedGraphNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OrderedMappedGraphNode parent = orderedMappedGraphNodeArray[n2];
            this.removeRelationship(parent, graphNode);
            ++n2;
        }
        orderedMappedGraphNodeArray = (OrderedMappedGraphNode[])graphNode.getChildren().values();
        n = orderedMappedGraphNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            OrderedMappedGraphNode child = orderedMappedGraphNodeArray[n2];
            this.removeRelationship(graphNode, child);
            ++n2;
        }
        if (this.fRoots != null) {
            this.fRoots.remove(graphNode.getIdentifier());
        }
        return graphNode.getElement();
    }

    public T removeNodeByIdentifier(String identifier) {
        return this._removeAllRelationships(this.fMap.removeElementByIdentifier(identifier));
    }

    public T removeNodeByIndex(int index) {
        return this._removeAllRelationships(this.fMap.removeElementByIndex(index));
    }

    public void clear() {
        this.fMap.clear();
        this.fRoots = new JSMap();
        this.fLoopRoots = new JSMap();
    }

    private OrderedMappedGraphNode<T> _getRootElementWhenBranchIsLoop(OrderedMappedGraphNode<T> currentElement, OrderedMappedGraphNode<T> lowestElement, JSMap<OrderedMappedGraphNode<T>> elementsVisited) {
        if (currentElement.getParentCount() == 0) {
            return currentElement;
        }
        if (elementsVisited.contains(currentElement.getIdentifier())) {
            OrderedMappedGraphNode graphNode = (OrderedMappedGraphNode)((Object)elementsVisited.get(currentElement.getIdentifier()));
            if (Undefined.isDefined((Object)((Object)graphNode))) {
                return graphNode;
            }
            return lowestElement;
        }
        elementsVisited.put(currentElement.getIdentifier(), (Object)((OrderedMappedGraphNode)((Object)Undefined.VALUE())));
        if (currentElement.getIndex() < lowestElement.getIndex()) {
            lowestElement = currentElement;
        }
        OrderedMappedGraphNode[] orderedMappedGraphNodeArray = (OrderedMappedGraphNode[])currentElement.getParents().values();
        int n = orderedMappedGraphNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            OrderedMappedGraphNode parent = orderedMappedGraphNodeArray[n2];
            OrderedMappedGraphNode<T> lowest = this._getRootElementWhenBranchIsLoop(parent, lowestElement, elementsVisited);
            if (lowest.getParentCount() == 0) {
                lowestElement = lowest;
                break;
            }
            if (lowest.getIndex() < lowestElement.getIndex()) {
                lowestElement = lowest;
            }
            ++n2;
        }
        elementsVisited.put(currentElement.getIdentifier(), lowestElement);
        return lowestElement;
    }

    private void _setRootNodesAndLowestLoopNodes() {
        if (this.fLoopRoots == null) {
            this.fRoots = new JSMap();
            this.fLoopRoots = new JSMap();
            JSMap elementsVisited = new JSMap();
            OrderedMappedGraphNode<T>[] orderedMappedGraphNodeArray = this.fMap.getValueArray();
            int n = orderedMappedGraphNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                OrderedMappedGraphNode<T> values = orderedMappedGraphNodeArray[n2];
                OrderedMappedGraphNode<T> graphNode = this._getRootElementWhenBranchIsLoop(values, values, elementsVisited);
                if (graphNode.getParentCount() == 0) {
                    this.fRoots.put(graphNode.getIdentifier(), graphNode);
                } else {
                    this.fLoopRoots.put(graphNode.getIdentifier(), graphNode);
                }
                ++n2;
            }
        }
    }

    public JSMap<OrderedMappedGraphNode<T>> getRootNodes() {
        this._setRootNodesAndLowestLoopNodes();
        return this.fRoots;
    }

    public JSMap<OrderedMappedGraphNode<T>> getLoopHeadNodes() {
        this._setRootNodesAndLowestLoopNodes();
        return this.fLoopRoots;
    }

    public static class OrderedMappedGraphNode<T>
    extends DojoObject
    implements IMappable {
        private OrderedMappedGraph<T> fGraph;
        private String fIdentifier;
        private T fElement;
        private JSMap<OrderedMappedGraphNode<T>> fParents;
        private JSMap<OrderedMappedGraphNode<T>> fChildren;

        private OrderedMappedGraphNode(OrderedMappedGraph<T> graph, String identifier, T element) {
            this.fGraph = graph;
            this.fIdentifier = identifier;
            this.fElement = element;
            this.fParents = new JSMap();
            this.fChildren = new JSMap();
        }

        public OrderedMappedGraph<T> getGraph() {
            if (this.fGraph == null || !this.fGraph.hasNodeWithIdentifier(this.getIdentifier())) {
                this.fGraph = (OrderedMappedGraph)((Object)Undefined.VALUE());
            }
            return this.fGraph;
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public int getIndex() {
            OrderedMappedGraph<T> graph = this.getGraph();
            if (graph == null) {
                return -1;
            }
            return ((OrderedMappedGraph)graph).fMap.getIndexByIdentifier(this.getIdentifier());
        }

        public T getElement() {
            return this.fElement;
        }

        public void setElement(T element) {
            this.fElement = element;
        }

        public JSMap<OrderedMappedGraphNode<T>> getParents() {
            return this.fParents;
        }

        public JSMap<OrderedMappedGraphNode<T>> getChildren() {
            return this.fChildren;
        }

        public int getParentCount() {
            return this.fParents.keys().length;
        }

        public int getChildCount() {
            return this.fChildren.keys().length;
        }

        protected boolean addParent(OrderedMappedGraphNode<T> parent) {
            OrderedMappedGraph<T> graph;
            if (parent != null && !this.hasParent(parent) && (graph = this.getGraph()) == parent.getGraph()) {
                if (graph != null) {
                    ((OrderedMappedGraph)graph).fLoopRoots = null;
                    ((OrderedMappedGraph)graph).fRoots = null;
                }
                parent.fChildren.put(this.getIdentifier(), (Object)this);
                this.fParents.put(parent.getIdentifier(), parent);
                return true;
            }
            return false;
        }

        protected boolean hasParent(OrderedMappedGraphNode<T> parent) {
            return parent.fChildren.get(this.getIdentifier()) == this;
        }

        protected boolean removeParent(OrderedMappedGraphNode<T> parent) {
            if (parent != null && this.hasParent(parent)) {
                OrderedMappedGraph<T> graph = this.getGraph();
                if (graph != null) {
                    ((OrderedMappedGraph)graph).fLoopRoots = null;
                    ((OrderedMappedGraph)graph).fRoots = null;
                }
                parent.fChildren.remove(this.getIdentifier());
                this.fParents.remove(parent.getIdentifier());
                return true;
            }
            return false;
        }
    }
}

