/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.lang.Console;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.reflection.Undefined;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSMap;
import com.ibm.jdojo.util.NLS;
import com.ibm.jdojox.util.IIterable;
import com.ibm.jdojox.util.IIterator;
import com.ibm.jdojox.util.KeyValuePair;

public class OrderedMap<T>
extends DojoObject
implements IIterable<KeyValuePair<String, T>> {
    private JSArray<T> elementByIndex = new JSArray();
    private JSArray<String> identifierByIndex = new JSArray();
    private JSMap<T> elementByIdentifier = new JSMap();
    private JSMap<Integer> indexByIdentifier = new JSMap();
    private int reindex = -1;
    private static final String OrderedMap_ERROR_IDENTIFIER_CONFLICT = "Identifier <${0}> conflicts with existing element.";
    private static final String OrderedMap_ERROR_INDEX_OUT_OF_RANGE = "Index <${0}> is out of range <${1}>.";

    public T getElementByIdentifier(String identifier) {
        return (T)this.elementByIdentifier.get(identifier);
    }

    public T getElementByIndex(int index) {
        if (index < this.identifierByIndex.length) {
            return (T)this.elementByIndex.get(index);
        }
        return (T)Undefined.VALUE();
    }

    public String getIdentifierByIndex(int index) {
        if (index < this.identifierByIndex.length) {
            return (String)this.identifierByIndex.get(index);
        }
        return (String)Undefined.VALUE();
    }

    public int getIndexByIdentifier(String identifier) {
        Integer index = (Integer)this.indexByIdentifier.get(identifier);
        if (index == null) {
            return -1;
        }
        if (this.reindex == -1 || index < this.reindex) {
            return index;
        }
        this._reindexIndexByIdentifier(this.reindex);
        return (Integer)this.indexByIdentifier.get(identifier);
    }

    private void _reindexIndexByIdentifier(int start) {
        int i = start;
        while (i < this.getSize()) {
            this.indexByIdentifier.put((String)this.identifierByIndex.get(i), (Object)i);
            ++i;
        }
    }

    public void clear() {
        this.elementByIndex = new JSArray();
        this.identifierByIndex = new JSArray();
        this.elementByIdentifier = new JSMap();
        this.indexByIdentifier = new JSMap();
        this.reindex = -1;
    }

    public String[] getKeyArray() {
        return (String[])this.identifierByIndex.toArray();
    }

    public T[] getValueArray() {
        return this.elementByIndex.toArray();
    }

    @Override
    public IIterator<KeyValuePair<String, T>> iterator() {
        return new OrderedMapIterator(this);
    }

    public int getSize() {
        return this.elementByIndex.length;
    }

    public boolean hasElementWithIdentifier(String identifier) {
        return Undefined.isDefined((Object)this.indexByIdentifier.get(identifier));
    }

    public boolean addElementAtIndex(String identifier, T element, int index) {
        if (this.getElementByIdentifier(identifier) != null) {
            Console.error((Object)NLS.bind((String)OrderedMap_ERROR_IDENTIFIER_CONFLICT, (Object)identifier, (Object[])new Object[0]));
        } else if (index < 0 || this.getSize() < index) {
            Console.error((Object)NLS.bind((String)OrderedMap_ERROR_INDEX_OUT_OF_RANGE, (Object)index, (Object[])new Object[]{this.getSize()}));
        } else {
            if (this.getSize() == index) {
                return this.addElementAtEnd(identifier, element);
            }
            if (this.reindex == -1 || index < this.reindex) {
                this.reindex = index;
            }
            this.elementByIdentifier.put(identifier, element);
            this.indexByIdentifier.put(identifier, (Object)index);
            this.elementByIndex.splice(index, 0, new Object[]{element});
            this.identifierByIndex.splice(index, 0, (Object[])new String[]{identifier});
            return true;
        }
        return false;
    }

    public boolean addElementAtEnd(String identifier, T element) {
        if (this.getElementByIdentifier(identifier) == null) {
            this.elementByIdentifier.put(identifier, element);
            this.indexByIdentifier.put(identifier, (Object)this.elementByIndex.length);
            this.elementByIndex.push(element);
            this.identifierByIndex.push((Object)identifier);
            return true;
        }
        Console.error((Object)NLS.bind((String)OrderedMap_ERROR_IDENTIFIER_CONFLICT, (Object)(identifier != null ? identifier : "null"), (Object[])new Object[0]));
        return false;
    }

    private T _remove(String identifier, int index) {
        if (this.getSize() <= index || index < 0) {
            Console.error((Object)NLS.bind((String)OrderedMap_ERROR_INDEX_OUT_OF_RANGE, (Object)index, (Object[])new Object[]{this.getSize()}));
        } else if (this.getElementByIdentifier(identifier) == null) {
            Console.error((Object)NLS.bind((String)OrderedMap_ERROR_IDENTIFIER_CONFLICT, (Object)identifier, (Object[])new Object[0]));
        } else {
            if (this.reindex == -1 || index < this.reindex) {
                this.reindex = index;
            }
            this.elementByIdentifier.remove(identifier);
            this.indexByIdentifier.remove(identifier);
            this.identifierByIndex.splice(index, 1);
            Object removedElement = this.elementByIndex.splice(index, 1).get(0);
            if (this.getSize() <= this.reindex) {
                this.reindex = -1;
            }
            return (T)removedElement;
        }
        return (T)Undefined.VALUE();
    }

    public T removeElementByIndex(int index) {
        String id = this.getIdentifierByIndex(index);
        return this._remove(id, index);
    }

    public T removeElementByIdentifier(String identifier) {
        int index = this.getIndexByIdentifier(identifier);
        if (index < 0) {
            return (T)Undefined.VALUE();
        }
        return this._remove(identifier, index);
    }

    private static class OrderedMapIterator<T>
    extends DojoObject
    implements IIterator<KeyValuePair<String, T>> {
        private OrderedMap<T> map;
        private int position;

        private OrderedMapIterator(OrderedMap<T> map) {
            this.map = map;
            this.position = -1;
        }

        @Override
        public boolean hasNext() {
            return this.position + 1 < ((OrderedMap)this.map).elementByIndex.length;
        }

        @Override
        public KeyValuePair<String, T> next() {
            ++this.position;
            if (this.position < ((OrderedMap)this.map).elementByIndex.length) {
                return new KeyValuePair().key((String)((OrderedMap)this.map).identifierByIndex.get(this.position)).value(((OrderedMap)this.map).elementByIndex.get(this.position));
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.position > 0 && this.position < ((OrderedMap)this.map).elementByIndex.length) {
                this.map.removeElementByIndex(this.position--);
            }
        }
    }
}

