/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.base.dojo;
import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.reflection.Properties;
import com.ibm.jdojo.util.JSArray;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojo.util.JSDate;
import com.ibm.jdojox.util.IEqualable;

public class JDojoX
extends DojoObject {
    public static boolean isEqual(Object o1, Object o2) {
        if (o1 instanceof IEqualable) {
            return ((IEqualable)o1).equals(o2);
        }
        if (dojo.isArray((Object)o1)) {
            return JDojoX._equalArrays(o1, o2);
        }
        if (o1 instanceof JSDate) {
            return JDojoX._equalDates(o1, o2);
        }
        if (JDojoX._isPlainObject(o1)) {
            return JDojoX._equalPlainObjects(o1, o2);
        }
        return o1 == o2;
    }

    private static boolean _equalArrays(Object arg1, Object arg2) {
        if (!dojo.isArray((Object)arg1) || !dojo.isArray((Object)arg2)) {
            return false;
        }
        JSArray a1 = (JSArray)arg1;
        JSArray a2 = (JSArray)arg2;
        if (a1.length != a2.length) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < a1.length) {
            boolean bl = result = result && JDojoX.isEqual(a1.get(i), a2.get(i));
            if (!result) break;
            ++i;
        }
        return result;
    }

    private static boolean _equalDates(Object arg1, Object arg2) {
        if (!(arg1 instanceof JSDate)) {
            return false;
        }
        if (!(arg2 instanceof JSDate)) {
            return false;
        }
        JSDate d1 = (JSDate)arg1;
        JSDate d2 = (JSDate)arg2;
        return d1.getTime() == d2.getTime();
    }

    private static boolean _equalPlainObjects(Object arg1, Object arg2) {
        if (!JDojoX._isPlainObject(arg1) || !JDojoX._isPlainObject(arg2)) {
            return false;
        }
        Object[] props1 = Properties.getPropertyNames((Object)arg1);
        Object[] props2 = Properties.getPropertyNames((Object)arg2);
        JSArrays.sort((Object[])props1);
        JSArrays.sort((Object[])props2);
        if (!JDojoX.isEqual(props1, props2)) {
            return false;
        }
        boolean result = true;
        Object[] objectArray = props1;
        int n = props1.length;
        int n2 = 0;
        while (n2 < n) {
            Object property = objectArray[n2];
            boolean bl = result = result && JDojoX.isEqual(Properties.getProperty((Object)arg1, (String)property), Properties.getProperty((Object)arg2, (String)property));
            if (!result) break;
            ++n2;
        }
        return result;
    }

    private static boolean _isPlainObject(Object arg1) {
        return JSArrays.indexOf((Object[])Properties.getPropertyNames((Object)arg1), (Object)"declaredClass") < 0 && dojo.isObject((Object)arg1) && !dojo.isFunction((Object)arg1);
    }
}

