/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.JavaScriptException;
import com.ibm.jdojox.util.ArrayList;
import com.ibm.jdojox.util.ICollection;
import com.ibm.jdojox.util.IIterator;
import com.ibm.jdojox.util.IList;
import com.ibm.jdojox.util.JDojoX;

public class Collections
extends DojoObject {
    public static <E> IList<E> emptyList() {
        return Collections.unmodifiableList(new ArrayList());
    }

    public static <E> IList<E> unmodifiableList(IList<E> list) {
        return new UnmodifiableList<E>(list);
    }

    public static <E> IIterator<E> unmodifiableIterator(IIterator<E> iterator) {
        return new UnmodifiableIterator(iterator);
    }

    private static class UnmodifiableIterator<E>
    extends DojoObject
    implements IIterator<E> {
        private final IIterator<E> _iterator;

        private UnmodifiableIterator(IIterator<E> iterator) {
            this._iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public E next() {
            return this._iterator.next();
        }

        @Override
        public void remove() {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }
    }

    private static class UnmodifiableList<E>
    extends DojoObject
    implements IList<E> {
        private final IList<E> _list;

        public UnmodifiableList(IList<E> list) {
            this._list = list;
        }

        @Override
        public boolean contains(Object object) {
            return this._list.contains(object);
        }

        @Override
        public boolean containsAll(ICollection<?> other) {
            return this._list.containsAll(other);
        }

        @Override
        public boolean isEmpty() {
            return this._list.isEmpty();
        }

        @Override
        public int size() {
            return this._list.size();
        }

        @Override
        public E[] toArray() {
            return this._list.toArray();
        }

        @Override
        public IIterator<E> iterator() {
            return new UnmodifiableIterator((IIterator)this._list.iterator());
        }

        @Override
        public E at(int index) {
            return this._list.at(index);
        }

        @Override
        public IList<E> addAt(int index, E object) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public IList<E> addAllAt(int index, ICollection<E> other) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public E removeAt(int index) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public int indexOf(Object object) {
            return this._list.indexOf(object);
        }

        @Override
        public IList<E> add(E object) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public IList<E> addAll(ICollection<E> other) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public IList<E> clear() {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public IList<E> remove(E object) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public IList<E> removeAll(ICollection<?> other) {
            throw new JavaScriptException((Object)"Unsupported operation iterator.remove()");
        }

        @Override
        public boolean equals(Object o) {
            return JDojoX.isEqual(this._list, o);
        }
    }
}

