/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jdojox.util;

import com.ibm.jdojo.lang.DojoObject;
import com.ibm.jdojo.lang.JSConstants;
import com.ibm.jdojo.lang.annotations.Overload;
import com.ibm.jdojo.util.JSArrays;
import com.ibm.jdojox.util.ICollection;
import com.ibm.jdojox.util.IIterator;
import com.ibm.jdojox.util.IList;
import com.ibm.jdojox.util.IllegalStateException;
import com.ibm.jdojox.util.JDojoX;

public class ArrayList<E>
extends DojoObject
implements IList<E> {
    private E[] _contents = JSArrays.create();

    @Overload
    public ArrayList() {
        this((Object[])JSConstants.VOID);
    }

    public ArrayList(E[] other) {
        if (other != null) {
            E[] EArray = other;
            int n = other.length;
            int n2 = 0;
            while (n2 < n) {
                E e = EArray[n2];
                this.add((Object)e);
                ++n2;
            }
        }
    }

    @Override
    public IList<E> add(E object) {
        JSArrays.push((Object[])this._contents, object);
        return this;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) > -1;
    }

    @Override
    public boolean containsAll(ICollection<?> other) {
        boolean result = true;
        for (Object object : other) {
            boolean bl = result = result && this.contains(object);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this._contents.length;
    }

    @Override
    public E[] toArray() {
        return JSArrays.slice((Object[])this._contents, (int)0);
    }

    @Override
    public IIterator<E> iterator() {
        return new Iterator(this);
    }

    @Override
    public E at(int index) {
        this._rangeCheck(index, false);
        return this._contents[index];
    }

    @Override
    public IList<E> addAt(int index, E object) {
        this._rangeCheck(index, true);
        JSArrays.splice((Object[])this._contents, (int)index, (int)0, (Object[])new Object[]{object});
        return this;
    }

    @Override
    public IList<E> addAllAt(int index, ICollection<E> other) {
        this._rangeCheck(index, true);
        java.util.Iterator it = other.iterator();
        int i = index;
        while (it.hasNext()) {
            this.addAt(i++, it.next());
        }
        return this;
    }

    @Override
    public E removeAt(int index) {
        this._rangeCheck(index, false);
        Object[] removed = JSArrays.splice((Object[])this._contents, (int)index, (int)1);
        return (E)removed[0];
    }

    @Override
    public int indexOf(Object object) {
        int index = 0;
        E[] EArray = this._contents;
        int n = this._contents.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (JDojoX.isEqual(e, object)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return -1;
    }

    @Override
    public IList<E> addAll(ICollection<E> other) {
        java.util.Iterator it = other.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return this;
    }

    @Override
    public IList<E> clear() {
        this._contents = JSArrays.create();
        return this;
    }

    @Override
    public IList<E> remove(E object) {
        int index = this.indexOf(object);
        if (index > -1) {
            this.removeAt(index);
        }
        return this;
    }

    @Override
    public IList<E> removeAll(ICollection<?> other) {
        java.util.Iterator it = other.iterator();
        while (it.hasNext()) {
            int index = this.indexOf(it.next());
            if (index <= -1) continue;
            this.removeAt(index);
        }
        return this;
    }

    private void _rangeCheck(int index, boolean inclusiveEnd) {
        if (index < 0) {
            throw new IllegalStateException("Index cannot be smaller than 0");
        }
        if (inclusiveEnd && index > this.size()) {
            throw new IllegalStateException("Index cannot be bigger than the size of the collection");
        }
        if (!inclusiveEnd && index > this.size() - 1) {
            throw new IllegalStateException("Index cannot be bigger than the index of the last element (size - 1)");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IList) {
            IList list = (IList)object;
            if (list.size() != this.size()) {
                return false;
            }
            java.util.Iterator it1 = this.iterator();
            java.util.Iterator it2 = list.iterator();
            while (it1.hasNext()) {
                Object e1 = it1.next();
                Object e2 = it2.next();
                if (!(e1 == null ? e2 != null : !JDojoX.isEqual(e1, e2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static class Iterator<E>
    extends DojoObject
    implements IIterator<E> {
        private int _curIndex = -1;
        private boolean _removable;
        private ArrayList<E> _list;

        private Iterator(ArrayList<E> _list) {
            this._list = _list;
        }

        @Override
        public boolean hasNext() {
            return this._curIndex < this._list.size() - 1;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("There are no next element in the list");
            }
            ++this._curIndex;
            this._removable = true;
            return this._list.at(this._curIndex);
        }

        @Override
        public void remove() {
            if (!this._removable) {
                throw new IllegalStateException("next() was not called before remove()");
            }
            this._list.removeAt(this._curIndex);
            this._removable = false;
            --this._curIndex;
        }
    }
}

