/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2010. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.jdojo.util.Assert"); //$NON-NLS-1$

(function() {

function isLegal(expression, message, location) {
	if (!expression)
		_throwException("Illegal Argument", message, location); //$NON-NLS-1$
};
	
function isNotNull(expression, message, location) {
	if (expression == null)
		_throwException("Assertion Failed (null element)", message, location); //$NON-NLS-1$
};
	
function isTrue(expression, message, location) {
	if (!expression)
		_throwException("Assertion Failed", message, location); //$NON-NLS-1$
};

function isInstanceOf(object, type){
//	isLegal(object instanceof type, "Expecting '" + type +"' but got '" + object + "'"); //$NON-NLS-1$
}

function isArray(object) {
	isLegal(dojo.isArray(object), "Expecting '[]' but got '" + object + "'"); //$NON-NLS-1$
}

function fail(message, location) {
	_throwException("Assertion Failed", message, location); //$NON-NLS-1$
}

// ---- implementation -------------------------------------------------------------------------------------------------

function _throwException(exceptionKind, message, location) {
	var errorText= exceptionKind;
	if (dojo.isString(message)) {
		errorText+= ": '" + message + "'"; //$NON-NLS-1$
	}

	if (dojo.isString(location)) {
		errorText+= " (@" + location + ")"; //$NON-NLS-1$
	}
	
	console.error(errorText);
	if (this.djConfig && this.djConfig.isDebug)
		throw new Error(errorText);
};

// publish methods
dojo.mixin(com.ibm.jdojo.util.Assert,  {
	isLegal: isLegal,
	isNotNull: isNotNull,
	isTrue: isTrue,
	isArray: isArray,
	isInstanceOf: isInstanceOf,
	fail: fail
});

})();
