/******************************************************************************* 
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2005, 2014. All Rights Reserved.
 * 
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
dojo.provide("com.ibm.jdojo.lang.Runtime");

dojo.require("jazz.core.loader");

(function() {

var loader= jazz.core.loader;

dojo.mixin(com.ibm.jdojo.lang.Runtime, {

	newInstance : function(type) {		
		// arguments to pass to the ctor: the arguments passed to newInstance, except for the first argument
		var ctorArgs= dojo.filter(arguments, function(val, idx) { return idx > 0; });
		return this.newInstanceWithArrayArgs(type, ctorArgs);
	},

	/*
	 * Previous implementation of this method supported dynamic loading of modules that were not pre-loaded.
	 * Use newInstanceByName(..) for cases where dynamic loading might be required. 
	 */
	newInstanceWithArrayArgs : function(type, ctorArgs) {
		var ctor= null;
		if (dojo.isString(type)) {
			ctor= dojo.getObject(type);
		} else if (dojo.isFunction(type)) {
			ctor= type;
		} else {
			throw new Error("type argument is expected to be a type name or constructor");
		}

		if (ctor == null) {
			throw new Error("Unknown type " + type);
		}
		
		// create an indirection using a synthetic ctor:
		// this allows calling the original ctor using variable arguments...
		function varArgCtor(args) {
			ctor.apply(this, args);
		}
		// ... while making use of the new constructor to set the correct prototype
		varArgCtor.prototype= ctor.prototype;
		return new varArgCtor(ctorArgs);
	},

	newInstanceByName: function(typeName, onLoad) {
		if(!dojo.isString(typeName)){
			throw new Error("type argument is expected to be a type name");
		}
		
		var $this= this;
		var $onLoad= onLoad;
		var $arguments= dojo.filter(arguments, function(val, idx) { return idx != 1; });
		
		loader.load_async(typeName, function(result){
			var obj= $this.newInstance.apply($this, $arguments);
			$onLoad(obj);
		});
	},
	
	implementsInterface : function(subject, interfaceName) {
		if (!subject)
			return false;

		var typeDef= subject.constructor.prototype;
		while (typeDef) {
			if (typeDef.$interfaces !== undefined && typeDef.$interfaces[interfaceName] === true)
				return true;

			typeDef= typeDef.constructor.superclass;
		}
		return false;
	},

	declareInterface : function(interfaceName, properties) {
		var interfaceInstance= dojo.declare(interfaceName, null, {
			constructor : function() {
				throw new Error("Can't instantiate interface type");
			},
			$isInterface : true
		});

		if (properties != null) {
			dojo.mixin(interfaceInstance, properties);
		}
		return interfaceInstance;
	},

	isInstance : function(subject, type) {
		if (type.prototype.$isInterface) {
			return this.implementsInterface(subject, type.prototype.declaredClass);
		} else {
			return subject instanceof type;
		}
	},
	
	getProperties : function(subject) {
		var result= []; 
		for (var name in subject)
			result.push(name); 
		return result;
	},
	
	getValues: function(subject) {
		var result= []; 
		for (var name in subject)
			result.push(subject[name]); 
		return result;
	}

});

})();