/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.dashboard.internal.rcp.ui.editor;

import com.ibm.team.dashboard.common.internal.dto.ConfigurationElement;
import com.ibm.team.dashboard.internal.rcp.ui.editor.AbstractDashboardAspectEditor;
import com.ibm.team.dashboard.internal.rcp.ui.editor.DashboardImages;
import com.ibm.team.dashboard.internal.rcp.ui.editor.Messages;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class DashboardEntriesAspectEditor
extends AbstractDashboardAspectEditor {
    private int newCategoryCount = 0;
    private TreeViewer viewer;
    private Action ACTION_ADD_SUB_CATEGORY = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardElement parent = DashboardEntriesAspectEditor.this.getCurrentElement();
            if (parent != null && parent instanceof CategoryElement) {
                AbstractDashboardAspectEditor.DashboardModel dashboardModel = DashboardEntriesAspectEditor.this.model;
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.DashboardEntriesAspectEditor_defaultCategoryName));
                DashboardEntriesAspectEditor dashboardEntriesAspectEditor = DashboardEntriesAspectEditor.this;
                int n = dashboardEntriesAspectEditor.newCategoryCount + 1;
                dashboardEntriesAspectEditor.newCategoryCount = n;
                CategoryElement element = new CategoryElement(dashboardModel, parent, stringBuilder.append(n).toString(), String.valueOf(Messages.defaultCategoryName) + DashboardEntriesAspectEditor.this.newCategoryCount, true);
                parent.addChild(element);
                DashboardEntriesAspectEditor.this.viewer.refresh((Object)parent);
                DashboardEntriesAspectEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
                DashboardEntriesAspectEditor.this.setDirty();
            }
        }

        public String getText() {
            return Messages.actionAddSubCategory;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_CATEGORY_OBJ;
        }
    };
    private Action ACTION_ADD_CATEGORY = new Action(){

        public void run() {
            AbstractDashboardAspectEditor.DashboardModel dashboardModel = DashboardEntriesAspectEditor.this.model;
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.DashboardEntriesAspectEditor_defaultCategoryName));
            DashboardEntriesAspectEditor dashboardEntriesAspectEditor = DashboardEntriesAspectEditor.this;
            int n = dashboardEntriesAspectEditor.newCategoryCount + 1;
            dashboardEntriesAspectEditor.newCategoryCount = n;
            CategoryElement element = new CategoryElement(dashboardModel, null, stringBuilder.append(n).toString(), String.valueOf(Messages.defaultCategoryName) + DashboardEntriesAspectEditor.this.newCategoryCount, true);
            ((EntriesModel)DashboardEntriesAspectEditor.this.model).rootCategories.add(element);
            DashboardEntriesAspectEditor.this.viewer.refresh();
            DashboardEntriesAspectEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
            DashboardEntriesAspectEditor.this.setDirty();
        }

        public String getText() {
            return Messages.actionAddCategory;
        }

        public ImageDescriptor getImageDescriptor() {
            return DashboardImages.DESC_CATEGORY_OBJ;
        }
    };
    private Section section;

    @Override
    protected int getDescriptionHeight() {
        return this.section.getDescriptionControl().getBounds().height;
    }

    @Override
    protected void createMasterSection(final IManagedForm mform, Composite parent) {
        FormToolkit toolkit = mform.getToolkit();
        this.section = toolkit.createSection(parent, 4224);
        this.section.setDescription(Messages.entriesMasterSectionDescription);
        Composite client = toolkit.createComposite((Composite)this.section);
        client.setLayout((Layout)new GridLayout());
        Tree tree = toolkit.createTree(client, 0);
        GridData treeData = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)treeData);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new AbstractDashboardAspectEditor.DashboardContentProvider());
        EntriesLabelProvider labelProvider = new EntriesLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        toolkit.paintBordersFor(client);
        MenuManager popupMenuManager = new MenuManager();
        popupMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                DashboardEntriesAspectEditor.this.fillContextMenu(mng);
            }
        });
        popupMenuManager.setRemoveAllWhenShown(true);
        tree.setMenu(popupMenuManager.createContextMenu((Control)tree));
        this.section.setClient((Control)client);
        final SectionPart spart = new SectionPart(this.section){

            public void refresh() {
                DashboardEntriesAspectEditor.this.viewer.refresh();
                super.refresh();
            }
        };
        mform.addPart((IFormPart)spart);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                mform.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        Hyperlink addCat = toolkit.createHyperlink(client, Messages.masterSectionAddCategoryLink, 0);
        addCat.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DashboardEntriesAspectEditor.this.ACTION_ADD_CATEGORY.run();
            }
        });
        this.setupSorting(labelProvider);
        this.viewer.setInput((Object)this.model);
    }

    private void setupSorting(final LabelProvider labelProvider) {
        this.viewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (!e1.getClass().isInstance(e2)) {
                    return e1 instanceof CategoryElement ? -1 : 1;
                }
                return labelProvider.getText(e1).toLowerCase().compareTo(labelProvider.getText(e2).toLowerCase());
            }
        });
    }

    private void fillContextMenu(IMenuManager mng) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        AbstractDashboardAspectEditor.DashboardElement element = (AbstractDashboardAspectEditor.DashboardElement)selection.getFirstElement();
        mng.add((IAction)this.ACTION_ADD_CATEGORY);
        if (element instanceof CategoryElement) {
            mng.add((IContributionItem)new Separator());
            mng.add((IAction)this.ACTION_ADD_VIEWLET);
            mng.add((IAction)this.ACTION_ADD_SUB_CATEGORY);
        }
        if (element.editable) {
            mng.add((IContributionItem)new Separator());
            if (element instanceof CategoryElement) {
                this.ACTION_REMOVE.setRoot(((EntriesModel)this.model).rootCategories);
            }
            this.ACTION_REMOVE.setExpectedClass(element.getClass());
            mng.add((IAction)this.ACTION_REMOVE);
        }
    }

    @Override
    protected AbstractDashboardAspectEditor.DashboardModel createModel() {
        return new EntriesModel();
    }

    @Override
    protected void addViewletDetailsFields(AbstractDashboardAspectEditor.ViewletDetailsPart detailsPart, FormToolkit toolkit, Composite parent, int span) {
        detailsPart.createElementEntry(toolkit, parent, AbstractDashboardAspectEditor.ViewletElementDef.ATT_DESC, span);
    }

    @Override
    protected void addViewletDetailsLinks(AbstractDashboardAspectEditor.ViewletDetailsPart detailsPart, FormToolkit toolkit, Composite parent, int span) {
    }

    @Override
    protected void extensionDataLoaded() {
        ((EntriesModel)this.model).loadPredefinedCategories();
        super.extensionDataLoaded();
    }

    @Override
    protected void registerPages(DetailsPart part) {
        part.setPageProvider((IDetailsPageProvider)new EntriesPageProvider());
    }

    @Override
    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    class CategoryDetailsPart
    extends AbstractDashboardAspectEditor.DashboardDetailsPart {
        CategoryDetailsPart() {
        }

        public void createContents(Composite parent) {
            FormToolkit toolkit = this.getManagedForm().getToolkit();
            GridLayout layout = new GridLayout();
            layout.marginTop = DashboardEntriesAspectEditor.this.getDescriptionHeight();
            parent.setLayout((Layout)layout);
            int span = 1;
            layout.numColumns = span + 1;
            this.createElementEntry(toolkit, parent, CategoryElementDef.ATT_ID, span, true, false, true);
            this.createElementEntry(toolkit, parent, CategoryElementDef.ATT_NAME, span, true, false, true);
            Hyperlink addSubCat = toolkit.createHyperlink(parent, Messages.categoryDetailsAddSubCategoryLink, 0);
            GridData gd = new GridData();
            gd.horizontalSpan = span + 1;
            addSubCat.setLayoutData((Object)gd);
            addSubCat.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    DashboardEntriesAspectEditor.this.ACTION_ADD_SUB_CATEGORY.run();
                }
            });
            Hyperlink addEntry = toolkit.createHyperlink(parent, Messages.categoryDetailsAddViewletEntryLink, 0);
            gd = new GridData();
            gd.horizontalSpan = span + 1;
            addEntry.setLayoutData((Object)gd);
            addEntry.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ((CategoryDetailsPart)CategoryDetailsPart.this).DashboardEntriesAspectEditor.this.ACTION_ADD_VIEWLET.run();
                }
            });
            toolkit.paintBordersFor(parent);
        }
    }

    class CategoryElement
    extends AbstractDashboardAspectEditor.DashboardElement {
        public static final String KEY = "category";
        public static final String KEY_PRE = "category-pre";

        public CategoryElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, ModelElement me) {
            super(model, parent, me);
            this.reserveAttribute(CategoryElementDef.ATT_ID);
            this.reserveAttribute(CategoryElementDef.ATT_NAME);
            if (me != null) {
                this.putAttribute("id", me.getAttribute("id"));
                this.putAttribute("name", me.getAttribute("name"));
            }
        }

        public CategoryElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, String id, String name) {
            this(model, parent, id, name, false);
        }

        public CategoryElement(AbstractDashboardAspectEditor.DashboardModel model, AbstractDashboardAspectEditor.DashboardElement parent, String id, String name, boolean editable) {
            this(model, parent, null);
            this.putAttribute("id", id);
            this.putAttribute("name", name);
            this.editable = editable;
        }

        @Override
        public String getKey() {
            return this.editable ? KEY : KEY_PRE;
        }

        CategoryElement findCategory(String id) {
            AbstractDashboardAspectEditor.DashboardElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof CategoryElement && ((CategoryElement)children[i]).getAttribute("id").equals(id)) {
                    return (CategoryElement)children[i];
                }
                ++i;
            }
            return null;
        }

        @Override
        public void save(IMemento memento) {
            if (this.editable) {
                IMemento childMemento = memento.createChild(this.getKey());
                this.saveSelf(childMemento);
            }
            this.saveChildren(memento);
        }

        @Override
        protected void saveSelf(IMemento memento) {
            super.saveSelf(memento);
            if (this.getParent() != null && this.getParent() instanceof CategoryElement) {
                memento.putString("parentCategory", (String)this.getParent().getAttribute((String)"id").value);
            }
        }

        public void preLoadSave(IMemento memento, String parentId) {
            if (this.editable) {
                IMemento childMemento = memento.createChild(this.getKey());
                this.saveSelf(childMemento);
                childMemento.putString("parentCategory", parentId);
            }
            this.saveChildren(memento);
        }
    }

    static class CategoryElementDef {
        static final String ID = "id";
        static final String NAME = "name";
        static final AbstractDashboardAspectEditor.DashboardAttributeDef ATT_ID = new AbstractDashboardAspectEditor.DashboardAttributeDef(0, "id", Messages.categoryIdentifierLabel, Messages.categoryIdTooltip);
        static final AbstractDashboardAspectEditor.DashboardAttributeDef ATT_NAME = new AbstractDashboardAspectEditor.DashboardAttributeDef(0, "name", Messages.categoryNameLabel, Messages.categoryNameTooltip);

        CategoryElementDef() {
        }
    }

    class EntriesLabelProvider
    extends AbstractDashboardAspectEditor.DashboardLabelProvider {
        EntriesLabelProvider() {
        }

        @Override
        public String getText(Object obj) {
            if (obj instanceof CategoryElement) {
                CategoryElement ce = (CategoryElement)obj;
                AbstractDashboardAspectEditor.DashboardAttribute da = ce.getAttribute("name");
                if (da != null && da.value != null) {
                    return da.value.toString();
                }
                da = ce.getAttribute("id");
                if (da != null && da.value != null) {
                    return da.value.toString();
                }
                return "(" + Messages.labelCategory + ")";
            }
            return super.getText(obj);
        }

        @Override
        public Image getImage(Object obj) {
            if (obj instanceof CategoryElement) {
                if (((CategoryElement)obj).editable) {
                    return DashboardImages.getImage(DashboardImages.DESC_CATEGORY_OBJ);
                }
                return DashboardImages.getImage(DashboardImages.DESC_COLUMN_OBJ_DIS);
            }
            return super.getImage(obj);
        }
    }

    class EntriesModel
    extends AbstractDashboardAspectEditor.DashboardModel {
        ArrayList rootCategories;
        Hashtable categories;
        private Hashtable needParents;

        @Override
        AbstractDashboardAspectEditor.DashboardElement[] getElements() {
            return this.rootCategories.toArray(new AbstractDashboardAspectEditor.DashboardElement[this.rootCategories.size()]);
        }

        @Override
        protected void init(ModelElement root) {
            this.rootCategories = new ArrayList();
            this.categories = new Hashtable();
            this.needParents = new Hashtable();
            List cme = root == null ? null : root.getChildElements();
            CategoryElement other = new CategoryElement(this, null, "__OTHER__", Messages.otherCategoryName);
            this.rootCategories.add(other);
            this.categories.put("__OTHER__", other);
            if (cme != null) {
                int i = 0;
                while (i < cme.size()) {
                    ModelElement me = (ModelElement)cme.get(i);
                    if (me.getName().equals("category")) {
                        CategoryElement cat = new CategoryElement(DashboardEntriesAspectEditor.this.model, null, me);
                        String parentCat = me.getAttribute("parentCategory");
                        if (parentCat != null && parentCat.length() > 0) {
                            this.needParents.put(cat, parentCat);
                        } else {
                            this.rootCategories.add(this.rootCategories.size() - 1, cat);
                        }
                        this.categories.put(cat.getAttribute((String)"id").value, cat);
                    } else if (me.getName().equals("viewlet-entry")) {
                        String id = me.getAttribute("category");
                        CategoryElement category = this.findCategory(id);
                        AbstractDashboardAspectEditor.ViewletElement ve = (AbstractDashboardAspectEditor)DashboardEntriesAspectEditor.this.new AbstractDashboardAspectEditor.ViewletElement((AbstractDashboardAspectEditor.DashboardModel)this, (AbstractDashboardAspectEditor.DashboardElement)category, me, true);
                        if (category == null) {
                            this.needParents.put(ve, id);
                        } else {
                            category.addChild(ve);
                        }
                    }
                    ++i;
                }
            }
            this.assignParents(false);
        }

        private CategoryElement findCategory(String id) {
            if (id == null) {
                return null;
            }
            return (CategoryElement)this.categories.get(id);
        }

        private void loadPredefinedCategories() {
            if (DashboardEntriesAspectEditor.this.extensionData == null) {
                return;
            }
            List elements = DashboardEntriesAspectEditor.this.extensionData.getConfigurationElements("com.ibm.team.dashboard.common.viewlets");
            for (ConfigurationElement element : elements) {
                if (!element.getName().equals("category")) continue;
                String id = (String)element.getAttributes().get("id");
                String name = (String)element.getAttributes().get("name");
                CategoryElement ele = new CategoryElement(this, null, id, name);
                String parent = (String)element.getAttributes().get("parentCategory");
                if (parent != null && parent.length() > 0) {
                    this.needParents.put(ele, parent);
                } else {
                    this.rootCategories.add(this.rootCategories.size() - 1, ele);
                }
                this.categories.put(id, ele);
            }
            this.assignParents(true);
        }

        private void assignParents(boolean addToDefault) {
            Hashtable<AbstractDashboardAspectEditor.DashboardElement, String> stillNeedParents = addToDefault ? null : new Hashtable<AbstractDashboardAspectEditor.DashboardElement, String>();
            for (AbstractDashboardAspectEditor.DashboardElement current : this.needParents.keySet()) {
                String parentId = (String)this.needParents.get(current);
                CategoryElement parentElement = (CategoryElement)this.categories.get(parentId);
                if (parentElement != null) {
                    current.parent = parentElement;
                    parentElement.addChild(current);
                    continue;
                }
                if (addToDefault) {
                    if (current instanceof CategoryElement) {
                        this.rootCategories.add(current);
                        continue;
                    }
                    if (!(current instanceof AbstractDashboardAspectEditor.ViewletElement)) continue;
                    CategoryElement other = (CategoryElement)this.categories.get("__OTHER__");
                    current.parent = other;
                    other.addChild(current);
                    continue;
                }
                stillNeedParents.put(current, parentId);
            }
            this.needParents = stillNeedParents;
        }

        @Override
        public void save(IMemento memento) {
            super.save(memento);
            int i = 0;
            while (i < this.rootCategories.size()) {
                CategoryElement element = (CategoryElement)this.rootCategories.get(i);
                element.save(memento);
                ++i;
            }
            if (this.needParents != null) {
                for (AbstractDashboardAspectEditor.DashboardElement current : this.needParents.keySet()) {
                    String parentId = (String)this.needParents.get(current);
                    if (current instanceof CategoryElement) {
                        ((CategoryElement)current).preLoadSave(memento, parentId);
                        continue;
                    }
                    if (!(current instanceof AbstractDashboardAspectEditor.ViewletElement)) continue;
                    ((AbstractDashboardAspectEditor.ViewletElement)current).preLoadSave(memento, parentId);
                }
            }
        }

        @Override
        protected String getConfigurationDataId() {
            return "com.ibm.team.dashboard.configuration.entries";
        }

        @Override
        protected String getConfigurationDataNamespace() {
            return "http://com.ibm.team.dashboard/entries";
        }
    }

    class EntriesPageProvider
    extends AbstractDashboardAspectEditor.ViewletPageProvider {
        EntriesPageProvider() {
        }

        @Override
        public IDetailsPage getPage(Object key) {
            if (key.equals("category") || key.equals("category-pre")) {
                return new CategoryDetailsPart();
            }
            return super.getPage(key);
        }

        @Override
        public Object getPageKey(Object object) {
            if (object instanceof CategoryElement) {
                return ((CategoryElement)object).getKey();
            }
            return super.getPageKey(object);
        }
    }
}

