/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.dashboard.common.internal;

import com.ibm.team.dashboard.common.IMemento;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Observable;
import java.util.Observer;

public class JSONMemento
extends Observable
implements IMemento,
Observer {
    private JSONObject jsonObj;

    public JSONMemento(String json) {
        try {
            this.jsonObj = JSONObject.parse((Reader)new StringReader(json));
        }
        catch (IOException e) {
            try {
                json = json.replace("undefined", "null");
                this.jsonObj = JSONObject.parse((Reader)new StringReader(json));
            }
            catch (IOException e2) {
                String msg = "Error parsing memento JSON - memento was \"" + json + "\"";
                throw new RuntimeException(msg, e2);
            }
        }
    }

    public JSONMemento(JSONObject jsonObj) {
        this.jsonObj = jsonObj;
    }

    @Override
    public IMemento createChild() {
        return new JSONMemento(new JSONObject());
    }

    @Override
    public Object get(String key) {
        return this.fromJSONType(this.jsonObj.get((Object)key));
    }

    public void serialize(Writer writer) {
        try {
            this.jsonObj.serialize(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(String key, Object value) {
        if (value != null) {
            this.jsonObj.put((Object)key, this.toJSONType(value));
        } else {
            this.jsonObj.remove((Object)key);
        }
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.setChanged();
        this.notifyObservers();
    }

    private Object fromJSONType(Object obj) {
        if (obj instanceof JSONObject) {
            JSONMemento memento = new JSONMemento((JSONObject)obj);
            memento.addObserver(this);
            return memento;
        }
        if (obj instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)obj;
            Object[] array = new Object[jsonArray.size()];
            int len = jsonArray.size();
            int i = 0;
            while (i < len) {
                array[i] = this.fromJSONType(jsonArray.get(i));
                ++i;
            }
            return array;
        }
        return obj;
    }

    private Object toJSONType(Object obj) {
        if (obj instanceof JSONMemento) {
            JSONMemento memento = (JSONMemento)obj;
            memento.addObserver(this);
            return memento.jsonObj;
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[])obj;
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            while (i < array.length) {
                jsonArray.add(this.toJSONType(array[i]));
                ++i;
            }
            return jsonArray;
        }
        return obj;
    }
}

