/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.preview;

import com.ibm.team.calm.foundation.client.preview.IResourceReference;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.calm.foundation.rcp.ui.internal.ImagePool;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.labelProviders.TypeLabelProvider;
import com.ibm.team.process.common.IProjectAreaHandle;
import java.net.URI;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class ResourceReferenceLabelProvider
extends TypeLabelProvider {
    private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

    public void updateLabel(ViewerLabel label, Object element) {
        if (label != null && element instanceof IResourceReference) {
            IResourceReference ref = (IResourceReference)element;
            Object resource = ref.resolve();
            if (resource != null) {
                if (resource instanceof ResourcePreview) {
                    ResourcePreview details = (ResourcePreview)resource;
                    this.updateText(label, details);
                    this.updateImage(label, details);
                } else if (!(resource instanceof IProjectAreaHandle) || ((IProjectAreaHandle)resource).getOrigin() != null) {
                    this.fStandardLabelProvider.updateLabel(label, resource);
                }
            } else {
                this.updateText(label, ref.getURI(), ref.getComment());
                this.updateImageWithDefault(label);
            }
        }
    }

    public void dispose() {
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        super.dispose();
    }

    private void updateText(ViewerLabel label, ResourcePreview resource) {
        String text;
        XMLString title = resource.getTitle();
        if (title != null && this.isValidString(text = title.getPlainText())) {
            label.setText(text);
        }
    }

    private void updateText(ViewerLabel label, URI uri, String comment) {
        String text = comment;
        if (uri != null && !this.isValidString(text)) {
            text = uri.toString();
        }
        if (this.isValidString(text)) {
            label.setText(text);
        }
    }

    private void updateImage(ViewerLabel label, ResourcePreview resource) {
        Image image = null;
        try {
            URI icon = resource.getIconURI();
            if (icon != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)icon.toURL());
                image = this.getResources().createImage(desc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image != null) {
            label.setImage(image);
        }
    }

    private void updateImageWithDefault(ViewerLabel label) {
        Image defaultImage = JazzResources.getImageWithDefault((ResourceManager)this.getResources(), (ImageDescriptor)ImagePool.RELATED_ARTIFACT_OBJ);
        label.setImage(defaultImage);
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }
}

