/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.preview;

import com.ibm.team.calm.foundation.client.preview.ResourceReferenceResolver;
import com.ibm.team.calm.foundation.common.preview.IResourceReferenceResolver;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public class ResourceReferenceContentProvider
implements IStructuredContentProvider {
    private final IResourceReferenceResolver fResolver;
    private final ITeamRepository fTeamRepository;
    private IResourceReferenceResolver.IResourceReferenceListener fResolveListener;

    public ResourceReferenceContentProvider(ITeamRepository teamRepository) throws IllegalArgumentException {
        if (teamRepository == null) {
            throw new IllegalArgumentException();
        }
        this.fTeamRepository = teamRepository;
        this.fResolver = new ResourceReferenceResolver();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Object[]) {
            return this.triggerElementResolution((Object[])inputElement);
        }
        return new Object[0];
    }

    public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof StructuredViewer) {
            this.fResolveListener = new IResourceReferenceResolver.IResourceReferenceListener(){

                public void referencesUpdated(final List<IReference> references) {
                    Control control = viewer.getControl();
                    if (control != null && !control.isDisposed() && references != null) {
                        control.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ((StructuredViewer)viewer).update(references.toArray(), null);
                            }
                        });
                    }
                }
            };
            this.fResolver.addReferencesListener(this.fResolveListener);
        } else {
            this.fResolver.removeReferencesListener(this.fResolveListener);
            this.fResolveListener = null;
        }
    }

    public void dispose() {
    }

    protected Object triggerElementResolution(Object element) {
        if (element instanceof IReference) {
            IReference resolvable = this.fResolver.makeResolvable((IReference)element, (Object)this.fTeamRepository);
            this.fResolver.resolveInBackground(Arrays.asList(resolvable));
            return resolvable;
        }
        return element;
    }

    protected Object[] triggerElementResolution(Object[] elements) {
        if (elements.length > 0 && elements[0] instanceof IReference) {
            ArrayList<IReference> resolvable = new ArrayList<IReference>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object cur = objectArray[n2];
                if (cur instanceof IReference) {
                    resolvable.add(this.fResolver.makeResolvable((IReference)cur, (Object)this.fTeamRepository));
                }
                ++n2;
            }
            this.fResolver.resolveInBackground(resolvable);
            return resolvable.toArray();
        }
        return elements;
    }
}

