/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.linking;

import com.ibm.icu.text.Collator;
import com.ibm.team.calm.foundation.client.IServiceProviderClient;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.PickerDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.CALMFoundationRCPUIPlugin;
import com.ibm.team.calm.foundation.rcp.ui.internal.HelpContextIds;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogRegistry;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.Messages;
import com.ibm.team.calm.foundation.rcp.ui.linking.CALMResourcePickerDialog;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

class ServiceProviderSelectionDialog
extends TitleAreaDialog {
    private final CALMResourcePickerDialog.ServiceProviderDescriptor fServiceProviderDesc;
    private final Collection<ServiceProvider> fServiceProviders;
    private final ITeamRepository fRepository;
    private ListViewer fProviderList;
    private Button fSelectionButton;
    private Button fCreationButton;
    private ComboViewer fSelectionCombo;
    private ComboViewer fCreationCombo;
    private ProgressMonitorPart fMonitorPart;
    private IProjectAreaHandle fLocalProject;
    private ServiceProvider fCurrentProvider;
    private ItemPickerDialogDescription fLocalCreationPicker;
    private ItemPickerDialogDescription fLocalSelectionPicker;
    private List<PickerDescription> fRemoteCreationPickers;
    private List<PickerDescription> fRemoteSelectionPickers;
    private PickerDescription fCurrentRemoteCreationPicker;
    private PickerDescription fCurrentRemoteSelectionPicker;
    private final String fGlobalConfigurationParameter;
    private OSLCResourceDescription.PickerType fPickerType;
    private static final Map<CALMResourcePickerDialog.ServiceProviderDescriptor, ServiceProvider> fgServiceProviderCache = new HashMap<CALMResourcePickerDialog.ServiceProviderDescriptor, ServiceProvider>();
    private static final Comparator<PickerDescription> fgPickerDescriptionComparator = new Comparator<PickerDescription>(){
        Collator collator = CollatorCache.getInstance();

        @Override
        public int compare(PickerDescription p1, PickerDescription p2) {
            String right;
            String left = p1 != null ? p1.getTitle() : null;
            String string = right = p2 != null ? p2.getTitle() : null;
            if (left == null && right == null) {
                return 0;
            }
            if (left == null) {
                return 1;
            }
            if (right == null) {
                return -1;
            }
            return this.collator.compare(left, right);
        }
    };
    private final CALMLinkTypeInformation fLinkType;

    public ServiceProviderSelectionDialog(CALMLinkTypeInformation linkType, Collection<ServiceProvider> serviceProviders, ITeamRepository repository, Shell parentShell, CALMResourcePickerDialog.ServiceProviderDescriptor serviceProviderDesc) {
        this(linkType, serviceProviders, repository, parentShell, serviceProviderDesc, null);
    }

    public ServiceProviderSelectionDialog(CALMLinkTypeInformation linkType, Collection<ServiceProvider> serviceProviders, ITeamRepository repository, Shell parentShell, CALMResourcePickerDialog.ServiceProviderDescriptor serviceProviderDesc, String globalConfigurationParameter) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fLinkType = linkType;
        this.fServiceProviders = serviceProviders;
        this.fRepository = repository;
        this.fServiceProviderDesc = serviceProviderDesc;
        this.setHelpAvailable(true);
        this.fGlobalConfigurationParameter = globalConfigurationParameter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ServiceProviderSelectionDialog_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.calm.foundation.rcp.ui.link_remote_clm_artifact");
        this.setTitle(NLS.bind((String)Messages.ServiceProviderSelectionDialog_DIALOG_TITLE_ACTION, (Object)this.fLinkType.getItemLinkType().getTargetEndPointDescriptor().getDisplayName(), (Object[])new Object[0]));
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        Composite projComp = new Composite(composite, 0);
        projComp.setLayout((Layout)new GridLayout(1, false));
        projComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label projectLabel = new Label(projComp, 64);
        GridData labelData = new GridData();
        labelData.widthHint = this.convertWidthInCharsToPixels(50);
        labelData.horizontalAlignment = 4;
        projectLabel.setLayoutData((Object)labelData);
        projectLabel.setText(Messages.ServiceProviderSelectionDialog_LABEL_SERVICE_PROVIDER);
        this.createServiceProviderList(projComp);
        Composite actionComp = new Composite(composite, 0);
        actionComp.setLayout((Layout)new GridLayout(2, false));
        actionComp.setLayoutData((Object)new GridData(4, 0, true, false));
        Label actionLabel = new Label(actionComp, 64);
        GridData actionData = new GridData();
        actionData.widthHint = this.convertWidthInCharsToPixels(50);
        actionData.horizontalSpan = 2;
        actionData.horizontalAlignment = 4;
        actionLabel.setLayoutData((Object)actionData);
        actionLabel.setText(Messages.ServiceProviderSelectionDialog_LABEL_LINK_ACTION);
        Composite columComp = new Composite(actionComp, 0);
        columComp.setLayout((Layout)new GridLayout(2, false));
        columComp.setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)columComp.getLayoutData()).horizontalSpan = 2;
        this.fSelectionButton = new Button(columComp, 16);
        this.fSelectionButton.setLayoutData((Object)new GridData(0x1000000));
        ((GridData)this.fSelectionButton.getLayoutData()).verticalAlignment = 0x1000000;
        this.fSelectionButton.setText(Messages.ServiceProviderSelectionDialog_LABEL_SELECTION_BUTTON);
        this.fSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServiceProviderSelectionDialog.this.fPickerType = OSLCResourceDescription.PickerType.SELECTION;
            }
        });
        this.fSelectionButton.setEnabled(false);
        this.fSelectionCombo = new ComboViewer(columComp, 8);
        this.fSelectionCombo.setContentProvider((IContentProvider)new PickerContentProvider());
        this.fSelectionCombo.setLabelProvider((IBaseLabelProvider)new PickerLabelProvider());
        this.fSelectionCombo.getCombo().setLayout((Layout)new GridLayout(1, false));
        this.fSelectionCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)this.fSelectionCombo.getCombo().getLayoutData()).verticalAlignment = 0x1000000;
        this.fSelectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)evt.getSelection();
                if (!sel.isEmpty()) {
                    ServiceProviderSelectionDialog.this.fCurrentRemoteSelectionPicker = (PickerDescription)sel.getFirstElement();
                    ServiceProviderSelectionDialog.this.fSelectionButton.setSelection(true);
                    ServiceProviderSelectionDialog.this.fCreationButton.setSelection(false);
                }
            }
        });
        this.fSelectionCombo.getCombo().setEnabled(false);
        this.fCreationButton = new Button(columComp, 16);
        this.fCreationButton.setLayoutData((Object)new GridData(0x1000000));
        ((GridData)this.fCreationButton.getLayoutData()).verticalAlignment = 0x1000000;
        this.fCreationButton.setText(Messages.ServiceProviderSelectionDialog_LABEL_CREATION_BUTTON);
        this.fCreationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ServiceProviderSelectionDialog.this.fPickerType = OSLCResourceDescription.PickerType.CREATION;
            }
        });
        this.fCreationButton.setEnabled(false);
        this.fCreationCombo = new ComboViewer(columComp, 8);
        this.fCreationCombo.setContentProvider((IContentProvider)new PickerContentProvider());
        this.fCreationCombo.setLabelProvider((IBaseLabelProvider)new PickerLabelProvider());
        this.fCreationCombo.getCombo().setLayout((Layout)new GridLayout(1, false));
        this.fCreationCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)this.fCreationCombo.getCombo().getLayoutData()).verticalAlignment = 0x1000000;
        this.fCreationCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                IStructuredSelection sel = (IStructuredSelection)evt.getSelection();
                if (!sel.isEmpty()) {
                    ServiceProviderSelectionDialog.this.fCurrentRemoteCreationPicker = (PickerDescription)sel.getFirstElement();
                    ServiceProviderSelectionDialog.this.fSelectionButton.setSelection(false);
                    ServiceProviderSelectionDialog.this.fCreationButton.setSelection(true);
                }
            }
        });
        this.fCreationCombo.getCombo().setEnabled(false);
        this.fMonitorPart = new BackgroundProgressMonitorPart(composite, (Layout)new GridLayout(1, false));
        this.fMonitorPart.setLayoutData((Object)new GridData(768));
        this.fMonitorPart.setVisible(false);
        ServiceProviderSelectionDialog.applyDialogFont((Control)composite);
        this.updateServiceProviderList();
        composite.pack();
        return composite;
    }

    public void create() {
        super.create();
        this.updateOkButton(false);
    }

    public IProjectAreaHandle getLocalProject() {
        return this.fLocalProject;
    }

    public PickerDescription getOSLCPickerDescription() {
        if (OSLCResourceDescription.PickerType.CREATION.equals((Object)this.fPickerType)) {
            return this.fCurrentRemoteCreationPicker;
        }
        return this.fCurrentRemoteSelectionPicker;
    }

    public ItemPickerDialogDescription getItemPickerDescription() {
        if (OSLCResourceDescription.PickerType.CREATION.equals((Object)this.fPickerType)) {
            return this.fLocalCreationPicker;
        }
        return this.fLocalSelectionPicker;
    }

    public ServiceProvider getCALMLink() {
        return this.fCurrentProvider;
    }

    private void createServiceProviderList(Composite parent) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, 2568);
        this.fProviderList = new ListViewer(list);
        this.fProviderList.setContentProvider((IContentProvider)new SelectionDialogContentProvider());
        this.fProviderList.setLabelProvider((IBaseLabelProvider)new ServiceProviderLabelProvider());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(Math.max(4, Math.min(this.fServiceProviders.size(), 7)));
        data.horizontalIndent = 10;
        this.fProviderList.getList().setLayoutData((Object)data);
        this.fProviderList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object selObj = ((IStructuredSelection)selection).getFirstElement();
                    if (selObj instanceof ServiceProvider) {
                        if (ServiceProviderSelectionDialog.this.fCurrentProvider == null || !selObj.equals(ServiceProviderSelectionDialog.this.fCurrentProvider)) {
                            ServiceProvider selProvider = (ServiceProvider)selObj;
                            ServiceProviderSelectionDialog.this.updateButtons(selProvider);
                        } else {
                            ServiceProviderSelectionDialog.this.updateOkButton(true);
                        }
                        if (ServiceProviderSelectionDialog.this.fServiceProviderDesc != null) {
                            fgServiceProviderCache.put(ServiceProviderSelectionDialog.this.fServiceProviderDesc, ServiceProviderSelectionDialog.this.fCurrentProvider);
                        }
                    } else {
                        ServiceProviderSelectionDialog.this.updateOkButton(false);
                    }
                }
            }
        });
    }

    private void updateButtons(ServiceProvider provider) {
        this.fCurrentProvider = provider;
        this.fSelectionButton.setEnabled(false);
        this.fCreationButton.setEnabled(false);
        this.updateStatus(Status.OK_STATUS);
        this.updateOkButton(false);
        this.showMonitor(true);
        this.fLocalProject = null;
        UIUpdaterJob updaterJob = new UIUpdaterJob(""){
            private IStatus fStatus;
            {
                this.fStatus = Status.OK_STATUS;
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    try {
                        IServiceProviderClient calmFoundationClient = (IServiceProviderClient)ServiceProviderSelectionDialog.this.fRepository.getClientLibrary(IServiceProviderClient.class);
                        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)ServiceProviderSelectionDialog.this.fMonitorPart, (String)Messages.ServiceProviderSelectionDialog_TASK_FIND_REPOSITORY_CONNECTION, (int)1);
                        ServiceProviderSelectionDialog.this.fLocalProject = calmFoundationClient.findRepositoryConnection(ServiceProviderSelectionDialog.this.fCurrentProvider, (IProgressMonitor)subMon.newChild(1));
                        if (ServiceProviderSelectionDialog.this.fLocalProject != null) {
                            String targetResourceId = ServiceProviderSelectionDialog.this.fCurrentProvider.getLinkTypeInfo().getTargetResourceId();
                            ServiceProviderSelectionDialog.this.fLocalCreationPicker = ItemPickerDialogRegistry.getItemPickerDescription(targetResourceId, OSLCResourceDescription.PickerType.CREATION);
                            ServiceProviderSelectionDialog.this.fLocalSelectionPicker = ItemPickerDialogRegistry.getItemPickerDescription(targetResourceId, OSLCResourceDescription.PickerType.SELECTION);
                        } else {
                            ServiceProviderSelectionDialog.this.fLocalCreationPicker = null;
                            ServiceProviderSelectionDialog.this.fLocalSelectionPicker = null;
                        }
                        OSLCResourceDescription.ServiceDocument serviceDocument = null;
                        if (ServiceProviderSelectionDialog.this.fLocalCreationPicker == null) {
                            subMon = SubMonitor.convert((IProgressMonitor)ServiceProviderSelectionDialog.this.fMonitorPart, (String)Messages.ServiceProviderSelectionDialog_TASK_RETRIEVE_REMOTE_DIALOG_INFO, (int)1);
                            serviceDocument = calmFoundationClient.fetchServiceDocument(ServiceProviderSelectionDialog.this.fCurrentProvider, (IProgressMonitor)subMon.newChild(1));
                            if (serviceDocument != null) {
                                ServiceProviderSelectionDialog.this.fRemoteCreationPickers = this.sortPickers(serviceDocument.getPickerDescriptions(OSLCResourceDescription.PickerType.CREATION, ServiceProviderSelectionDialog.this.fLinkType, ServiceProviderSelectionDialog.this.fGlobalConfigurationParameter));
                            }
                        }
                        if (ServiceProviderSelectionDialog.this.fLocalSelectionPicker == null) {
                            if (serviceDocument == null) {
                                subMon = SubMonitor.convert((IProgressMonitor)ServiceProviderSelectionDialog.this.fMonitorPart, (String)Messages.ServiceProviderSelectionDialog_TASK_RETRIEVE_REMOTE_DIALOG_INFO, (int)1);
                                serviceDocument = calmFoundationClient.fetchServiceDocument(ServiceProviderSelectionDialog.this.fCurrentProvider, (IProgressMonitor)subMon.newChild(1));
                            }
                            if (serviceDocument != null) {
                                ServiceProviderSelectionDialog.this.fRemoteSelectionPickers = this.sortPickers(serviceDocument.getPickerDescriptions(OSLCResourceDescription.PickerType.SELECTION, ServiceProviderSelectionDialog.this.fLinkType, ServiceProviderSelectionDialog.this.fGlobalConfigurationParameter));
                            }
                        }
                    }
                    catch (TeamRepositoryException ex) {
                        this.fStatus = ServiceProviderSelectionDialog.this.createUserLevelStatus((Exception)((Object)ex));
                        CALMFoundationRCPUIPlugin.getDefault().log(this.fStatus);
                        if (ServiceProviderSelectionDialog.this.fMonitorPart != null && !ServiceProviderSelectionDialog.this.fMonitorPart.isDisposed()) {
                            ServiceProviderSelectionDialog.this.fMonitorPart.done();
                        }
                    }
                }
                finally {
                    if (ServiceProviderSelectionDialog.this.fMonitorPart != null && !ServiceProviderSelectionDialog.this.fMonitorPart.isDisposed()) {
                        ServiceProviderSelectionDialog.this.fMonitorPart.done();
                    }
                }
                return Status.OK_STATUS;
            }

            private List<PickerDescription> sortPickers(List<PickerDescription> pickerDescriptions) {
                if (pickerDescriptions != null && pickerDescriptions.size() > 1) {
                    ArrayList<PickerDescription> sorted = new ArrayList<PickerDescription>(pickerDescriptions.size());
                    sorted.addAll(pickerDescriptions);
                    Collections.sort(sorted, fgPickerDescriptionComparator);
                    return sorted;
                }
                return pickerDescriptions;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                ServiceProviderSelectionDialog.this.showMonitor(false);
                if (!ServiceProviderSelectionDialog.this.fSelectionButton.isDisposed() && !ServiceProviderSelectionDialog.this.fCreationButton.isDisposed()) {
                    Object[] input;
                    ServiceProviderSelectionDialog.this.fSelectionButton.setEnabled(ServiceProviderSelectionDialog.this.fLocalSelectionPicker != null || ServiceProviderSelectionDialog.this.fRemoteSelectionPickers != null && !ServiceProviderSelectionDialog.this.fRemoteSelectionPickers.isEmpty());
                    ServiceProviderSelectionDialog.this.fCreationButton.setEnabled(ServiceProviderSelectionDialog.this.fLocalCreationPicker != null || ServiceProviderSelectionDialog.this.fRemoteCreationPickers != null && !ServiceProviderSelectionDialog.this.fRemoteCreationPickers.isEmpty());
                    if (this.fStatus.isOK() && !ServiceProviderSelectionDialog.this.fSelectionButton.isEnabled() && !ServiceProviderSelectionDialog.this.fCreationButton.isEnabled()) {
                        this.fStatus = new Status(1, "com.ibm.team.calm.foundation.rcp.ui", Messages.ServiceProviderSelectionDialog_INFO_UNSUPPORTED_ARTIFIACT);
                    }
                    if (ServiceProviderSelectionDialog.this.fSelectionButton.isEnabled()) {
                        ServiceProviderSelectionDialog.this.fSelectionButton.setSelection(true);
                        ServiceProviderSelectionDialog.this.fCreationButton.setSelection(false);
                        ServiceProviderSelectionDialog.this.fPickerType = OSLCResourceDescription.PickerType.SELECTION;
                    } else if (ServiceProviderSelectionDialog.this.fCreationButton.isEnabled()) {
                        ServiceProviderSelectionDialog.this.fSelectionButton.setSelection(false);
                        ServiceProviderSelectionDialog.this.fCreationButton.setSelection(true);
                        ServiceProviderSelectionDialog.this.fPickerType = OSLCResourceDescription.PickerType.CREATION;
                    }
                    if (ServiceProviderSelectionDialog.this.fLocalSelectionPicker != null) {
                        ServiceProviderSelectionDialog.this.fSelectionCombo.setInput((Object)new Object[]{ServiceProviderSelectionDialog.this.fLocalSelectionPicker});
                        ServiceProviderSelectionDialog.this.fSelectionCombo.getCombo().select(0);
                        ServiceProviderSelectionDialog.this.fSelectionCombo.getCombo().setEnabled(false);
                    } else if (ServiceProviderSelectionDialog.this.fRemoteSelectionPickers != null && !ServiceProviderSelectionDialog.this.fRemoteSelectionPickers.isEmpty()) {
                        input = ServiceProviderSelectionDialog.this.fRemoteSelectionPickers.toArray();
                        ServiceProviderSelectionDialog.this.fSelectionCombo.setInput((Object)input);
                        if (input.length > 0) {
                            ServiceProviderSelectionDialog.this.fSelectionCombo.getCombo().select(0);
                            ServiceProviderSelectionDialog.this.fCurrentRemoteSelectionPicker = (PickerDescription)ServiceProviderSelectionDialog.this.fRemoteSelectionPickers.get(0);
                        }
                        ServiceProviderSelectionDialog.this.fSelectionCombo.getCombo().setEnabled(input.length > 1);
                    }
                    if (ServiceProviderSelectionDialog.this.fLocalCreationPicker != null) {
                        ServiceProviderSelectionDialog.this.fCreationCombo.setInput((Object)new Object[]{ServiceProviderSelectionDialog.this.fLocalCreationPicker});
                        ServiceProviderSelectionDialog.this.fCreationCombo.getCombo().select(0);
                        ServiceProviderSelectionDialog.this.fCreationCombo.getCombo().setEnabled(false);
                    } else if (ServiceProviderSelectionDialog.this.fRemoteCreationPickers != null && !ServiceProviderSelectionDialog.this.fRemoteCreationPickers.isEmpty()) {
                        input = ServiceProviderSelectionDialog.this.fRemoteCreationPickers.toArray();
                        ServiceProviderSelectionDialog.this.fCreationCombo.setInput((Object)input);
                        if (input.length > 0) {
                            ServiceProviderSelectionDialog.this.fCreationCombo.getCombo().select(0);
                            ServiceProviderSelectionDialog.this.fCurrentRemoteCreationPicker = (PickerDescription)ServiceProviderSelectionDialog.this.fRemoteCreationPickers.get(0);
                        }
                        ServiceProviderSelectionDialog.this.fCreationCombo.getCombo().setEnabled(input.length > 1);
                    }
                    ServiceProviderSelectionDialog.this.updateStatus(this.fStatus);
                    ServiceProviderSelectionDialog.this.updateOkButton(this.fStatus.isOK());
                }
                return Status.OK_STATUS;
            }
        };
        if (this.fCurrentProvider != null) {
            updaterJob.schedule();
        }
    }

    private void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                this.setMessage(status.getMessage(), 1);
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 4: {
                this.setMessage(status.getMessage(), 3);
                break;
            }
            default: {
                this.setMessage(Messages.ServiceProviderSelectionDialog_DIALOG_TITLE_MESSAGE);
            }
        }
    }

    private void updateOkButton(boolean isOk) {
        Button okBtn = this.getButton(0);
        if (okBtn != null) {
            okBtn.setEnabled(isOk);
        }
    }

    private void updateServiceProviderList() {
        if (this.fServiceProviders != null && !this.fServiceProviders.isEmpty()) {
            ServiceProvider[] input = this.fServiceProviders.toArray(new ServiceProvider[this.fServiceProviders.size()]);
            ServiceProvider lastSelectedProvider = null;
            if (this.fServiceProviderDesc != null) {
                lastSelectedProvider = fgServiceProviderCache.get(this.fServiceProviderDesc);
            }
            this.fProviderList.setInput((Object)input);
            if (input.length == 1) {
                this.fProviderList.getList().select(0);
                lastSelectedProvider = input[0];
            } else if (input.length > 0 && lastSelectedProvider != null) {
                String item = ((ILabelProvider)this.fProviderList.getLabelProvider()).getText((Object)lastSelectedProvider);
                int index = this.fProviderList.getList().indexOf(item);
                this.fProviderList.getList().select(index);
            }
            this.updateButtons(lastSelectedProvider);
        }
    }

    private Status createUserLevelStatus(Exception ex) {
        Throwable target = ex.getCause() == null ? ex : ex.getCause();
        String host = URI.create(this.fCurrentProvider.getProviderServiceUrl()).getHost();
        Status status = null;
        status = target instanceof AuthenticationException ? new Status(2, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_WARNING_SERVICE_PROVIDER_ACCESS_DENIED, (Object)host, (Object[])new Object[0]), target) : (target instanceof SocketTimeoutException ? new Status(2, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_WARNING_SERVICE_PROVIDER_CONNECTION_TIMEOUT, (Object)host, (Object[])new Object[0]), target) : (target instanceof PermissionDeniedException ? new Status(4, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_ERROR_SERVICE_PROVIDER_PERMISSION_DENIED, (Object)host, (Object[])new Object[0]), target) : new Status(4, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_ERROR_ACCESSING_SERVICE_DOCUMENT, (Object)host, (Object[])new Object[0]), target)));
        return status;
    }

    private void showMonitor(boolean b) {
        if (this.fMonitorPart != null && !this.fMonitorPart.isDisposed()) {
            this.fMonitorPart.setVisible(b);
        }
    }

    private class BackgroundProgressMonitorPart
    extends ProgressMonitorPart {
        private static final String NO_NAME = "";

        public BackgroundProgressMonitorPart(Composite parent, Layout layout) {
            super(parent, layout);
        }

        public void beginTask(final String name, final int totalWork) {
            if (this.isDisposed()) {
                return;
            }
            new FoundationUIJob(NO_NAME){

                protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                    BackgroundProgressMonitorPart.super.beginTask(name, totalWork);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        public void internalWorked(final double work) {
            if (this.isDisposed()) {
                return;
            }
            new FoundationUIJob(NO_NAME){

                protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                    BackgroundProgressMonitorPart.super.internalWorked(work);
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        public void done() {
            if (this.isDisposed()) {
                return;
            }
            new FoundationUIJob(NO_NAME){

                protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                    BackgroundProgressMonitorPart.super.done();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }

        protected void updateLabel() {
            if (this.isDisposed()) {
                return;
            }
            new FoundationUIJob(NO_NAME){

                protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                    BackgroundProgressMonitorPart.super.updateLabel();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private class PickerContentProvider
    implements IStructuredContentProvider {
        private PickerContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class PickerLabelProvider
    implements ILabelProvider {
        private PickerLabelProvider() {
        }

        public String getText(Object element) {
            if (element != null) {
                if (element instanceof PickerDescription) {
                    return ((PickerDescription)element).getLabel();
                }
                if (element instanceof ItemPickerDialogDescription) {
                    return ((ItemPickerDialogDescription)element).getLabel();
                }
            }
            return element != null ? element.toString() : null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class SelectionDialogContentProvider
    implements IStructuredContentProvider {
        private SelectionDialogContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ServiceProviderLabelProvider
    implements ILabelProvider {
        private ServiceProviderLabelProvider() {
        }

        public String getText(Object element) {
            if (element != null && element instanceof ServiceProvider) {
                return ((ServiceProvider)element).getProviderName();
            }
            return element != null ? element.toString() : null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

