/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.linking;

import com.ibm.team.calm.foundation.rcp.ui.internal.linking.Messages;
import com.ibm.team.calm.foundation.rcp.ui.linking.BackgroundProgressMonitorPart;
import com.ibm.team.calm.foundation.rcp.ui.linking.PickerSelectionDialog;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class PickerSelectionViewer<ServiceProviderType, PickerDescriptionType>
extends Composite {
    private final PickerSelectionDialog.SelectorArguments<ServiceProviderType, PickerDescriptionType> args;
    private ListViewer providerList;
    private Button selectionButton;
    private ComboViewer selectionCombo;
    private Button creationButton;
    private ComboViewer creationCombo;
    private Control okButton;
    private ProgressMonitorPart monitorPart;
    private ServiceProviderType currentProvider;
    private PickerDescriptionType currentSelection;
    private final Map<ServiceProviderType, PickerSelectionDialog.Pickers<PickerDescriptionType>> pickerMap = new HashMap<ServiceProviderType, PickerSelectionDialog.Pickers<PickerDescriptionType>>();

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        PickerSelectionDialog.SelectorArguments selectorArgs = new PickerSelectionDialog.SelectorArguments();
        selectorArgs.linkTargetDisplayName = "Is related to";
        selectorArgs.serviceProviders = Arrays.asList("Provider A", "Provider B", "Provider C", "Provider D");
        selectorArgs.pickerRetriever = new PickerSelectionDialog.PickerRetriever<String, String>(){

            @Override
            public PickerSelectionDialog.Pickers<String> getPickersForProvider(String provider, IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                progress.setTaskName("Doing slow stuff");
                try {
                    int i = 0;
                    while (i < 5) {
                        if (!monitor.isCanceled()) {
                            Thread.sleep(50L);
                            progress.worked(1);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                PickerSelectionDialog.Pickers<String> result = new PickerSelectionDialog.Pickers<String>();
                if (!"Provider C".equals(provider)) {
                    if (!"Provider A".equals(provider)) {
                        result.creationPickers = Arrays.asList("Creation picker for " + provider, "Another picker");
                    }
                    if (!"Provider D".equals(provider)) {
                        result.selectionPickers = Arrays.asList("Selection picker for " + provider);
                    }
                }
                return result;
            }

            @Override
            public IStatus statusForError(TeamRepositoryException error, String provider) {
                return Status.CANCEL_STATUS;
            }
        };
        PickerSelectionDialog dialog = PickerSelectionDialog.create(shell, selectorArgs);
        int result = dialog.open();
        if (result == 0) {
            System.out.println("Selection: " + dialog.getSelectedPicker());
        } else {
            System.out.println("Cancelled");
        }
    }

    public static <ServiceProvider, PickerDescription> PickerSelectionViewer<ServiceProvider, PickerDescription> create(Composite parent, int style, PickerSelectionDialog.SelectorArguments<ServiceProvider, PickerDescription> args) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull(args);
        return new PickerSelectionViewer<ServiceProvider, PickerDescription>(parent, style, args);
    }

    private PickerSelectionViewer(Composite parent, int style, PickerSelectionDialog.SelectorArguments<ServiceProviderType, PickerDescriptionType> args) {
        super(parent, style);
        this.args = args;
        this.createInternalControls();
    }

    public void setOkButton(Control okButton) {
        Assert.isNotNull((Object)okButton);
        this.okButton = okButton;
        this.updateControlState();
    }

    public PickerDescriptionType getSelectedPicker() {
        return this.currentSelection;
    }

    private void createInternalControls() {
        this.setLayout((Layout)new GridLayout(1, false));
        GridData layoutData = new GridData(4, 4, true, true);
        this.setLayoutData(layoutData);
        this.createProviderListControl();
        this.createItemTypeSelectionControl();
        this.createProgressMonitorContorl();
        if (!this.args.serviceProviders.isEmpty()) {
            this.providerList.getList().select(0);
            this.providerListSelectionChanged();
        }
        this.pack();
    }

    private void createProviderListControl() {
        Composite projComp = new Composite((Composite)this, 0);
        projComp.setLayout((Layout)new GridLayout(1, false));
        projComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label projectLabel = new Label(projComp, 64);
        GridData labelData = new GridData();
        labelData.widthHint = PickerSelectionViewer.convertWidthInCharsToPixels(50, (Control)projectLabel);
        labelData.horizontalAlignment = 4;
        projectLabel.setLayoutData((Object)labelData);
        projectLabel.setText(Messages.ServiceProviderSelectionDialog_LABEL_SERVICE_PROVIDER);
        this.providerList = new ListViewer(projComp, 2568);
        this.providerList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.providerList.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.providerList.setInput(this.args.serviceProviders);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = PickerSelectionViewer.convertHeightInCharsToPixels(PickerSelectionViewer.constrainToRange(this.args.serviceProviders.size(), 4, 7), (Control)this.providerList.getList());
        data.horizontalIndent = 10;
        this.providerList.getList().setLayoutData((Object)data);
        this.providerList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PickerSelectionViewer.this.providerListSelectionChanged();
            }
        });
    }

    private void createItemTypeSelectionControl() {
        Composite actionComp = new Composite((Composite)this, 0);
        actionComp.setLayout((Layout)new GridLayout(2, false));
        actionComp.setLayoutData((Object)new GridData(4, 0, true, false));
        Label actionLabel = new Label(actionComp, 64);
        GridData actionData = new GridData();
        actionData.widthHint = PickerSelectionViewer.convertWidthInCharsToPixels(50, (Control)actionLabel);
        actionData.horizontalSpan = 2;
        actionData.horizontalAlignment = 4;
        actionLabel.setLayoutData((Object)actionData);
        actionLabel.setText(Messages.ServiceProviderSelectionDialog_LABEL_LINK_ACTION);
        Composite columComp = new Composite(actionComp, 0);
        columComp.setLayout((Layout)new GridLayout(2, false));
        columComp.setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)columComp.getLayoutData()).horizontalSpan = 2;
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PickerSelectionViewer.this.updateControlState();
            }
        };
        this.selectionButton = new Button(columComp, 16);
        this.selectionButton.setLayoutData((Object)new GridData(0x1000000));
        ((GridData)this.selectionButton.getLayoutData()).verticalAlignment = 0x1000000;
        this.selectionButton.setText(Messages.ServiceProviderSelectionDialog_LABEL_SELECTION_BUTTON);
        this.selectionButton.addSelectionListener((SelectionListener)selectionListener);
        this.selectionButton.setEnabled(false);
        this.selectionCombo = new ComboViewer(columComp, 8);
        this.selectionCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectionCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.selectionCombo.getCombo().setLayout((Layout)new GridLayout(1, false));
        this.selectionCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)this.selectionCombo.getCombo().getLayoutData()).verticalAlignment = 0x1000000;
        this.selectionCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    PickerSelectionViewer.this.selectionButton.setSelection(true);
                    PickerSelectionViewer.this.creationButton.setSelection(false);
                }
                PickerSelectionViewer.this.updateControlState();
            }
        });
        this.selectionCombo.getCombo().setEnabled(false);
        this.creationButton = new Button(columComp, 16);
        this.creationButton.setLayoutData((Object)new GridData(0x1000000));
        ((GridData)this.creationButton.getLayoutData()).verticalAlignment = 0x1000000;
        this.creationButton.setText(Messages.ServiceProviderSelectionDialog_LABEL_CREATION_BUTTON);
        this.creationButton.addSelectionListener((SelectionListener)selectionListener);
        this.creationButton.setEnabled(false);
        this.creationCombo = new ComboViewer(columComp, 8);
        this.creationCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.creationCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.creationCombo.getCombo().setLayout((Layout)new GridLayout(1, false));
        this.creationCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
        ((GridData)this.creationCombo.getCombo().getLayoutData()).verticalAlignment = 0x1000000;
        this.creationCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    PickerSelectionViewer.this.selectionButton.setSelection(false);
                    PickerSelectionViewer.this.creationButton.setSelection(true);
                }
                PickerSelectionViewer.this.updateControlState();
            }
        });
        this.creationCombo.getCombo().setEnabled(false);
    }

    private void createProgressMonitorContorl() {
        this.monitorPart = new BackgroundProgressMonitorPart(this, (Layout)new GridLayout(1, false));
        this.monitorPart.setLayoutData((Object)new GridData(768));
    }

    protected void updateControlState() {
        assert (!this.selectionButton.getSelection() || !this.creationButton.getSelection());
        this.currentSelection = this.selectionButton.getSelection() ? this.getSelectedPicker(this.selectionCombo) : (this.creationButton.getSelection() ? this.getSelectedPicker(this.creationCombo) : null);
        this.okButton.setEnabled(this.currentSelection != null);
    }

    protected void providerListSelectionChanged() {
        ServiceProviderType provider = this.getCurrentProvider();
        if (!this.pickerMap.containsKey(provider)) {
            this.monitorPart.setVisible(true);
            FetchPickersJob job = new FetchPickersJob(provider);
            job.schedule();
        } else if (!provider.equals(this.currentProvider)) {
            this.updateCurrentProvider();
        }
    }

    private void updateCurrentProvider() {
        boolean selectionOk = false;
        boolean creationOk = false;
        ServiceProviderType provider = this.getCurrentProvider();
        PickerSelectionDialog.Pickers<PickerDescriptionType> pickers = this.pickerMap.get(provider);
        if (pickers != null) {
            this.selectionCombo.setInput(pickers.selectionPickers);
            if (!pickers.selectionPickers.isEmpty()) {
                selectionOk = true;
                this.selectionCombo.getCombo().select(0);
            } else {
                this.selectionButton.setSelection(false);
            }
            this.creationCombo.setInput(pickers.creationPickers);
            if (!pickers.creationPickers.isEmpty()) {
                creationOk = true;
                this.creationCombo.getCombo().select(0);
            } else {
                this.creationButton.setSelection(false);
            }
        }
        this.selectionButton.setEnabled(selectionOk);
        this.selectionCombo.getCombo().setEnabled(selectionOk && pickers.selectionPickers.size() > 1);
        this.creationButton.setEnabled(creationOk);
        this.creationCombo.getCombo().setEnabled(creationOk && pickers.creationPickers.size() > 1);
        if (!this.selectionButton.getSelection() && !this.creationButton.getSelection()) {
            if (selectionOk) {
                this.selectionButton.setSelection(true);
            } else if (creationOk) {
                this.creationButton.setSelection(true);
            }
        }
        this.currentProvider = provider;
        this.updateControlState();
    }

    private ServiceProviderType getCurrentProvider() {
        IStructuredSelection selection = (IStructuredSelection)this.providerList.getSelection();
        return (ServiceProviderType)selection.getFirstElement();
    }

    private PickerDescriptionType getSelectedPicker(ComboViewer combo) {
        IStructuredSelection selection = (IStructuredSelection)combo.getSelection();
        return (PickerDescriptionType)selection.getFirstElement();
    }

    static int constrainToRange(int value, int minimum, int maximum) {
        return Math.max(minimum, Math.min(value, maximum));
    }

    static int convertHeightInCharsToPixels(int numRows, Control c) {
        GC gc = new GC((Drawable)c);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            int n = fontMetrics.getHeight() * numRows;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    static int convertWidthInCharsToPixels(int numCharacters, Control c) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < numCharacters) {
            text.append('m');
            ++i;
        }
        GC gc = new GC((Drawable)c);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            int n = fontMetrics.getAverageCharWidth() * numCharacters;
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private class FetchPickersJob
    extends Job {
        final ServiceProviderType forProvider;
        final Display ui;

        public FetchPickersJob(ServiceProviderType forProvider) {
            super("Retrieve remote dialog information");
            this.forProvider = forProvider;
            this.ui = PickerSelectionViewer.this.monitorPart.getDisplay();
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus result;
            PickerSelectionDialog.Pickers pickers;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)PickerSelectionViewer.this.monitorPart, (int)1);
            try {
                pickers = ((PickerSelectionViewer)PickerSelectionViewer.this).args.pickerRetriever.getPickersForProvider(this.forProvider, (IProgressMonitor)subMonitor.newChild(1));
                result = Status.OK_STATUS;
            }
            catch (TeamRepositoryException e) {
                pickers = new PickerSelectionDialog.Pickers();
                result = ((PickerSelectionViewer)PickerSelectionViewer.this).args.pickerRetriever.statusForError(e, this.forProvider);
            }
            final PickerSelectionDialog.Pickers finalPickers = pickers;
            this.ui.asyncExec(new Runnable(){

                @Override
                public void run() {
                    FetchPickersJob.this.updateUI(finalPickers);
                }
            });
            return result;
        }

        void updateUI(PickerSelectionDialog.Pickers<PickerDescriptionType> pickers) {
            if (!PickerSelectionViewer.this.monitorPart.isDisposed()) {
                PickerSelectionViewer.this.monitorPart.setVisible(false);
            }
            PickerSelectionViewer.this.pickerMap.put(this.forProvider, this.sanitizeInput(pickers));
            PickerSelectionViewer.this.updateCurrentProvider();
        }

        private PickerSelectionDialog.Pickers<PickerDescriptionType> sanitizeInput(PickerSelectionDialog.Pickers<PickerDescriptionType> pickers) {
            if (pickers.creationPickers != null && pickers.selectionPickers != null) {
                return pickers;
            }
            PickerSelectionDialog.Pickers result = new PickerSelectionDialog.Pickers();
            result.creationPickers = pickers.creationPickers;
            if (result.creationPickers == null) {
                result.creationPickers = Collections.emptySet();
            }
            result.selectionPickers = pickers.selectionPickers;
            if (result.selectionPickers == null) {
                result.selectionPickers = Collections.emptySet();
            }
            return result;
        }
    }
}

