/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.linking;

import com.ibm.team.calm.foundation.rcp.ui.internal.linking.Messages;
import com.ibm.team.calm.foundation.rcp.ui.linking.PickerSelectionViewer;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class PickerSelectionDialog<ServiceProviderType, PickerDescriptionType>
extends TitleAreaDialog {
    private final SelectorArguments<ServiceProviderType, PickerDescriptionType> args;
    private PickerSelectionViewer<ServiceProviderType, PickerDescriptionType> selector;

    public static <ServiceProvider, PickerDescription> PickerSelectionDialog<ServiceProvider, PickerDescription> create(Shell parentShell, SelectorArguments<ServiceProvider, PickerDescription> args) {
        Assert.isNotNull((Object)parentShell);
        Assert.isNotNull(args);
        PickerSelectionDialog.assertArgsValid(args);
        return new PickerSelectionDialog<ServiceProvider, PickerDescription>(parentShell, args);
    }

    private static void assertArgsValid(SelectorArguments<?, ?> args) {
        Assert.isNotNull((Object)args.linkTargetDisplayName);
        Assert.isNotNull(args.pickerRetriever);
        Assert.isNotNull(args.serviceProviders);
    }

    private PickerSelectionDialog(Shell parentShell, SelectorArguments<ServiceProviderType, PickerDescriptionType> args) {
        super(parentShell);
        this.args = args;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public PickerDescriptionType getSelectedPicker() {
        return this.selector.getSelectedPicker();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ServiceProviderSelectionDialog_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        this.initHelp(area);
        this.setTitle(NLS.bind((String)Messages.ServiceProviderSelectionDialog_DIALOG_TITLE_ACTION, (Object)this.args.linkTargetDisplayName, (Object[])new Object[0]));
        this.selector = PickerSelectionViewer.create(area, 0, this.args);
        this.updateStatus(Status.OK_STATUS);
        return area;
    }

    private void initHelp(Composite dialogArea) {
        boolean providingHelp = false;
    }

    protected Control createButtonBar(Composite parent) {
        assert (this.selector != null);
        Control result = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        this.selector.setOkButton((Control)okButton);
        return result;
    }

    private void updateStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                this.setMessage(status.getMessage(), 1);
                break;
            }
            case 2: {
                this.setMessage(status.getMessage(), 2);
                break;
            }
            case 4: {
                this.setMessage(status.getMessage(), 3);
                break;
            }
            default: {
                this.setMessage(Messages.ServiceProviderSelectionDialog_DIALOG_TITLE_MESSAGE);
            }
        }
    }

    public static interface PickerRetriever<ServiceProviderType, PickerDescriptionType> {
        public Pickers<PickerDescriptionType> getPickersForProvider(ServiceProviderType var1, IProgressMonitor var2) throws TeamRepositoryException;

        public IStatus statusForError(TeamRepositoryException var1, ServiceProviderType var2);
    }

    public static class Pickers<PickerDescriptionType> {
        public Collection<PickerDescriptionType> selectionPickers = new ArrayList<PickerDescriptionType>();
        public Collection<PickerDescriptionType> creationPickers = new ArrayList<PickerDescriptionType>();
    }

    public static final class SelectorArguments<ServiceProviderType, PickerDescriptionType> {
        public String linkTargetDisplayName;
        public Collection<ServiceProviderType> serviceProviders;
        public PickerRetriever<ServiceProviderType, PickerDescriptionType> pickerRetriever;
    }
}

