/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.linking;

import com.ibm.team.calm.foundation.common.Size;
import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.common.linking.PickerDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.CALMFoundationRCPUIPlugin;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.Messages;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.transport.UriUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OSLCPickerDialog
extends Dialog {
    private static final String PROTOCOL = "comBrowser://";
    private static final String OSLC_RESPONSE_MESSAGE = "oslc-response:";
    private static final String OSLC_RESIZE_MESSAGE = "oslc-resize:";
    private static final String OSLC_PARAM_WIDTH = "oslc:hintWidth";
    private static final String OSLC_PARAM_HEIGHT = "oslc:hintHeight";
    private final PickerDescription fPickerDescription;
    private Browser fBrowser;
    private Collection<OSLCReference> fResult;
    private Composite fContainer;
    private boolean registered;
    private boolean reRegisterRequested;
    private static final boolean DEBUG = Boolean.getBoolean(String.valueOf(OSLCPickerDialog.class.getName()) + ".debug");

    public OSLCPickerDialog(Shell parentShell, PickerDescription pickerDescription) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fPickerDescription = pickerDescription;
    }

    public Collection<OSLCReference> getReferences() {
        return this.fResult;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fPickerDescription.getTitle());
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.fContainer = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)this.fContainer.getLayoutData();
        gd.widthHint = this.fPickerDescription.getWidthHintInPixels(500);
        gd.heightHint = this.fPickerDescription.getHeightHintInPixels(200);
        GridLayout layout = (GridLayout)this.fContainer.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        String protocol = "oslc".equals(this.fPickerDescription.getResultNamespace()) ? "#oslc-core-postMessage-1.0" : "#oslc-postMessage-1.0";
        final String url = String.valueOf(this.fPickerDescription.getPickerURL()) + protocol;
        final Composite composite = new Composite(this.fContainer, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new StackLayout());
        this.fBrowser = new Browser(composite, 0);
        final Composite progress = new Composite(composite, 0);
        progress.setLayout((Layout)new GridLayout());
        final ProgressMonitorPart monitor = new ProgressMonitorPart(progress, (Layout)new GridLayout());
        monitor.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        ((StackLayout)composite.getLayout()).topControl = progress;
        monitor.beginTask(Messages.OSLCPickerDialog_PROGRESS_TASK, 5);
        this.fBrowser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Browser logInBrowser;
                Shell shell = new Shell(OSLCPickerDialog.this.fBrowser.getShell());
                shell.setLayout((Layout)new FillLayout());
                event.browser = logInBrowser = new Browser((Composite)shell, 0);
                logInBrowser.addVisibilityWindowListener(new VisibilityWindowListener(){

                    public void show(WindowEvent event) {
                        Shell shell = logInBrowser.getShell();
                        if (event.location != null) {
                            shell.setLocation(event.location);
                        }
                        if (event.size != null) {
                            shell.setSize(650, 500);
                        }
                        shell.open();
                    }

                    public void hide(WindowEvent event) {
                    }
                });
                logInBrowser.addCloseWindowListener(new CloseWindowListener(){

                    public void close(WindowEvent event) {
                        Browser browser = (Browser)event.widget;
                        Shell shell = browser.getShell();
                        shell.close();
                    }
                });
            }
        });
        this.fBrowser.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                if (evt.character == '\u001b') {
                    OSLCPickerDialog.this.close();
                }
            }

            public void keyReleased(KeyEvent evt) {
            }
        });
        this.fBrowser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                if (!progress.isDisposed()) {
                    monitor.done();
                    progress.dispose();
                }
                OSLCPickerDialog.this.fBrowser.setVisible(true);
                ((StackLayout)composite.getLayout()).topControl = OSLCPickerDialog.this.fBrowser;
            }

            public void changed(ProgressEvent evt) {
                if (!monitor.isDisposed()) {
                    monitor.worked(evt.current);
                }
            }
        });
        this.fBrowser.addTitleListener(new TitleListener(){
            private String fLastMessage = null;

            public void changed(TitleEvent event) {
                try {
                    OSLCPickerDialog.this.debug("Title changed: " + event.title);
                    String result = (String)OSLCPickerDialog.this.fBrowser.evaluate("return window.oslcResult;");
                    if (result == null) {
                        if (OSLCPickerDialog.this.registered && event.title != null) {
                            if (event.title.equals(url) || url.contains(event.title)) {
                                if (OSLCPickerDialog.this.reRegisterRequested) {
                                    OSLCPickerDialog.this.debug("Reregistering event handlers");
                                    OSLCPickerDialog.this.registerMessageHandler();
                                    OSLCPickerDialog.this.reRegisterRequested = false;
                                }
                            } else {
                                OSLCPickerDialog.this.debug("Title change has triggered need to reregister handlers");
                                OSLCPickerDialog.this.reRegisterRequested = true;
                            }
                        }
                    } else {
                        this.textChanged(result);
                    }
                }
                catch (Exception e) {
                    OSLCPickerDialog.this.debug("Exception obtaining OSLC result", e);
                }
            }

            private void textChanged(String text) {
                OSLCPickerDialog.this.debug("Message recieved: " + text);
                if (!text.equals(this.fLastMessage) && text.startsWith(OSLCPickerDialog.PROTOCOL)) {
                    OSLCPickerDialog.this.performMessagePosted(text.substring(OSLCPickerDialog.PROTOCOL.length()));
                }
                this.fLastMessage = text;
            }
        });
        this.fBrowser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent event) {
                OSLCPickerDialog.this.debug("Location changed: " + event.location);
                if (OSLCPickerDialog.isEqualURL(event.location, OSLCPickerDialog.this.fPickerDescription.getPickerURL())) {
                    OSLCPickerDialog.this.debug("Setting URL: " + url);
                    OSLCPickerDialog.this.fBrowser.setUrl(url);
                } else if (OSLCPickerDialog.isEqualURL(event.location, url)) {
                    OSLCPickerDialog.this.debug("Registering event handlers");
                    OSLCPickerDialog.this.registerMessageHandler();
                }
            }

            public void changing(LocationEvent event) {
            }
        });
        this.fBrowser.setUrl(url);
        OSLCPickerDialog.applyDialogFont((Control)this.fContainer);
        return this.fContainer;
    }

    private void registerMessageHandler() {
        if (!this.fBrowser.execute("window.postMessage= function(e) { var r= 'comBrowser://' + e; window.oslcResult= r; window.document.title= r; }")) {
            this.warn("Failed to set window.postMessage. OSLC dialogs may not work properly");
        }
        if (!this.fBrowser.execute("window.addEventListener('message', function(e) { var r= 'comBrowser://' + e.data; window.oslcResult= r; window.document.title= r; })")) {
            this.warn("Failed to window.addEventListener. OSLC dialogs may not work properly");
        }
        this.registered = true;
    }

    protected void debug(String message, Exception e) {
        if (DEBUG) {
            this.warn(message, e);
        }
    }

    protected void debug(String message) {
        this.debug(message, null);
    }

    private void warn(String message) {
        this.warn(message, null);
    }

    protected void warn(String message, Exception e) {
        Status status = new Status(2, "com.ibm.team.calm.foundation.rcp.ui", 0, message, (Throwable)e);
        CALMFoundationRCPUIPlugin.getDefault().log((IStatus)status);
    }

    protected void performMessagePosted(String text) {
        if (text.startsWith(OSLC_RESPONSE_MESSAGE)) {
            this.processResult(text.substring(OSLC_RESPONSE_MESSAGE.length()));
        }
        if (text.startsWith(OSLC_RESIZE_MESSAGE)) {
            this.processResize(text.substring(OSLC_RESIZE_MESSAGE.length()));
        }
    }

    protected void processResize(String sizeString) {
        try {
            if (this.fContainer == null) {
                return;
            }
            JSONObject newSizeObj = JSONObject.parse((Reader)new StringReader(sizeString));
            Object widthObj = newSizeObj.get((Object)OSLC_PARAM_WIDTH);
            Object heightObj = newSizeObj.get((Object)OSLC_PARAM_HEIGHT);
            String widthStr = widthObj instanceof String ? (String)widthObj : "-1px";
            String heightStr = heightObj instanceof String ? (String)heightObj : "-1px";
            boolean hasChanged = false;
            Size newSize = Size.parse((String)widthStr, (String)heightStr, (Size)new Size(-1, -1, Size.SizeUnit.px));
            GridData gridData = (GridData)this.fContainer.getLayoutData();
            int newWidth = newSize.getWidth(Size.SizeUnit.px);
            int newHeight = newSize.getHeight(Size.SizeUnit.px);
            if (newWidth != -1 && gridData.widthHint != newWidth) {
                gridData.widthHint = newWidth;
                hasChanged = true;
            }
            if (newHeight != -1 && gridData.heightHint != newHeight) {
                gridData.heightHint = newHeight;
                hasChanged = true;
            }
            if (hasChanged) {
                this.initializeBounds();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected boolean processResult(String data) {
        if (data.length() != 0) {
            this.fResult = this.parseReferencesFromJson(data);
            this.setReturnCode(0);
            this.getParentShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OSLCPickerDialog.this.close();
                }
            });
            return true;
        }
        return false;
    }

    private Collection<OSLCReference> parseReferencesFromJson(String data) {
        String namespace = this.fPickerDescription.getResultNamespace();
        String resultsKey = String.valueOf(namespace) + ":results";
        JSONObject jsResult = null;
        try {
            jsResult = JSONObject.parse((Reader)new StringReader(data));
        }
        catch (IOException ex) {
            String message = MessageFormat.format(Messages.OSLCPickerDialog_ERROR_DIALOG_RESULT, data);
            Status status = new Status(4, "com.ibm.team.calm.foundation.rcp.ui", 4, message, (Throwable)ex);
            CALMFoundationRCPUIPlugin.getDefault().log((IStatus)status);
        }
        if (jsResult != null) {
            String labelKey = String.valueOf(namespace) + ":label";
            String resourceKey = "rdf:resource";
            Object object = jsResult.get((Object)resultsKey);
            if (!(object instanceof JSONArray) && "oslc_rm".equals(namespace)) {
                object = jsResult.get((Object)"http://open-services.net/xmlns/rm/1.0/web/results");
                resourceKey = "http://www.w3.org/1999/02/22-rdf-syntax-ns#resource";
                labelKey = "http://www.w3.org/2000/01/rdf-schema#label";
            }
            if (object instanceof JSONArray) {
                JSONArray jsElements = (JSONArray)object;
                HashSet<OSLCReference> result = new HashSet<OSLCReference>();
                for (Object cur : jsElements) {
                    OSLCReference curRef;
                    if (!(cur instanceof JSONObject) || (curRef = this.parseReferenceFromJson((JSONObject)cur, labelKey, resourceKey)) == null) continue;
                    result.add(curRef);
                }
                return result;
            }
        }
        return Collections.emptySet();
    }

    private OSLCReference parseReferenceFromJson(JSONObject jsObject, String labelKey, String resourceKey) {
        Object url = jsObject.get((Object)resourceKey);
        Object label = jsObject.get((Object)labelKey);
        if (url instanceof String && label instanceof String) {
            try {
                URI uri = new URI((String)url);
                return new OSLCReference(uri, (String)label);
            }
            catch (URISyntaxException ex) {
                Status status = new Status(4, "com.ibm.team.calm.foundation.rcp.ui", 4, Messages.OSLCPickerDialog_ERROR_INVALID_URL, (Throwable)ex);
                CALMFoundationRCPUIPlugin.getDefault().log((IStatus)status);
            }
        } else {
            String message = MessageFormat.format(Messages.OSLCPickerDialog_ERROR_CANNOT_CREATE_REFERENCE_FROM_JSON, url);
            Status status = new Status(4, "com.ibm.team.calm.foundation.rcp.ui", 4, message, null);
            CALMFoundationRCPUIPlugin.getDefault().log((IStatus)status);
        }
        return null;
    }

    private static URI getURI(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        int port = uri.getPort();
        if (port == -1) {
            port = "https".equalsIgnoreCase(uri.getScheme()) ? 443 : 80;
        }
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), port, uri.getPath(), "", uri.getFragment());
    }

    private static boolean isEqualQuery(String q1, String q2) {
        if (q1 == null || q2 == null) {
            return q1 == q2;
        }
        Map m1 = UriUtil.parseQueryParameters((String)q1);
        Map m2 = UriUtil.parseQueryParameters((String)q2);
        if (m1.size() != m2.size()) {
            return false;
        }
        for (Map.Entry entry1 : m1.entrySet()) {
            Object[] values1 = (String[])entry1.getValue();
            Object[] values2 = (String[])m2.get(entry1.getKey());
            if (values1 == null || values2 == null) {
                return values1 == values2;
            }
            if (values1.length != values2.length) {
                return false;
            }
            Arrays.sort(values1);
            Arrays.sort(values2);
            if (Arrays.equals(values1, values2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqualURL(String url1, String url2) {
        if (url1.equals(url2)) {
            return true;
        }
        try {
            URI uri1 = OSLCPickerDialog.getURI(url1);
            URI uri2 = OSLCPickerDialog.getURI(url2);
            return uri1.equals(uri2) && OSLCPickerDialog.isEqualQuery(uri1.getQuery(), uri2.getQuery());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

