/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.linking;

import com.ibm.team.calm.foundation.common.internal.ICALMFoundationRPCService;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.GCInfo_DTO;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.OslcDialog_DTO;
import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.PickerDescription;
import com.ibm.team.calm.foundation.rcp.ui.linking.OSLCPickerDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GcPickerDialog {
    private final ITeamRepository[] fRepositories;
    private final IRunnableContext fRunnableContext;
    private final Shell fShell;
    private OslcDialog_DTO gcSelectionDialog = null;

    public GcPickerDialog(Shell shell, IRunnableContext runnableContext, ITeamRepository[] repos) {
        this.fRunnableContext = runnableContext;
        this.fRepositories = repos;
        this.fShell = shell;
    }

    private Collection<OSLCReference> openAndGetResultsInternal() {
        boolean isDefault;
        Set identifiers;
        OSLCResourceDescription.PickerType pickerType;
        String resultNamespace;
        String heightHint;
        String widthHint;
        String pickerURL;
        String label;
        if (this.gcSelectionDialog == null) {
            return Collections.emptySet();
        }
        String title = this.gcSelectionDialog.getTitle();
        PickerDescription pickerDesc = new PickerDescription(title, label = this.gcSelectionDialog.getLabel(), pickerURL = this.gcSelectionDialog.getDialogUri(), widthHint = this.gcSelectionDialog.getHintWidth(), heightHint = this.gcSelectionDialog.getHintHeight(), resultNamespace = "oslc", pickerType = OSLCResourceDescription.PickerType.SELECTION, identifiers = Collections.emptySet(), isDefault = true);
        OSLCPickerDialog dialog = new OSLCPickerDialog(this.fShell, pickerDesc);
        if (dialog.open() == 0) {
            return dialog.getReferences();
        }
        return Collections.emptySet();
    }

    private static GCInfo_DTO getGcUri(ITeamRepository[] repos) {
        ITeamRepository[] iTeamRepositoryArray = repos;
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            IClientLibraryContext context;
            ICALMFoundationRPCService gcService;
            ITeamRepository repo = iTeamRepositoryArray[n2];
            if (GcPickerDialog.checkLoggedInRepository(repo) && repo instanceof IClientLibraryContext && (gcService = (ICALMFoundationRPCService)(context = (IClientLibraryContext)repo).getServiceInterface(ICALMFoundationRPCService.class)) != null) {
                return gcService.getGcUri();
            }
            ++n2;
        }
        return null;
    }

    private static boolean checkLoggedInRepository(ITeamRepository repository) {
        return repository.loggedIn();
    }

    private void threadSaveGetGcInfo() {
        if (this.fShell.getDisplay().getThread() == Thread.currentThread()) {
            try {
                this.fRunnableContext.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        GCInfo_DTO gcInfo = GcPickerDialog.getGcUri(GcPickerDialog.this.fRepositories);
                        if (gcInfo != null) {
                            GcPickerDialog.this.gcSelectionDialog = gcInfo.getPickerDialog();
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        } else {
            GCInfo_DTO gcInfo = GcPickerDialog.getGcUri(this.fRepositories);
            if (gcInfo != null) {
                this.gcSelectionDialog = gcInfo.getPickerDialog();
            }
        }
    }

    public static boolean isGcPickerAvailable(ITeamRepository[] repos) {
        return GcPickerDialog.getGcUri(repos) != null;
    }

    public Collection<OSLCReference> openAndGetResults() {
        this.threadSaveGetGcInfo();
        Display display = this.fShell.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            return this.openAndGetResultsInternal();
        }
        final LinkedList<OSLCReference> results = new LinkedList<OSLCReference>();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                results.addAll(GcPickerDialog.this.openAndGetResultsInternal());
            }
        });
        return results;
    }
}

