/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.linking;

import com.ibm.icu.text.Collator;
import com.ibm.team.calm.foundation.client.IServiceProviderClient;
import com.ibm.team.calm.foundation.client.linking.CALMLinkingCache;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.OSLCReference;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.PickerDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogRegistry;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.Messages;
import com.ibm.team.calm.foundation.rcp.ui.linking.AbstractItemPickerDialog;
import com.ibm.team.calm.foundation.rcp.ui.linking.IItemPickerDialog;
import com.ibm.team.calm.foundation.rcp.ui.linking.OSLCPickerDialog;
import com.ibm.team.calm.foundation.rcp.ui.linking.PickerSelectionDialog;
import com.ibm.team.calm.foundation.rcp.ui.linking.ServiceProviderSelectionDialog;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.CollatorCache;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CALMResourcePickerDialog {
    private final CALMLinkTypeInformation fLinkType;
    private final ServiceProviderDescriptor fServiceProviderDescriptor;
    private final Collection<ServiceProvider> fServiceProviders;
    private final ITeamRepository fRepository;
    private final IRunnableContext fRunnableContext;
    private final Shell fShell;
    private Collection<OSLCReference> fPickedReferences;
    private final String fGlobalConfigurationParameter;

    public CALMResourcePickerDialog(Shell shell, IRunnableContext runnableContext, CALMLinkTypeInformation linkType, IProjectAreaHandle project, Collection<ServiceProvider> serviceProviders) {
        this(shell, runnableContext, linkType, project, serviceProviders, null);
    }

    public CALMResourcePickerDialog(Shell shell, IRunnableContext runnableContext, CALMLinkTypeInformation linkType, IProjectAreaHandle project, Collection<ServiceProvider> serviceProviders, String globalConfigurationParameter) {
        this.fRunnableContext = runnableContext;
        this.fLinkType = linkType;
        this.fServiceProviders = serviceProviders;
        this.fRepository = (ITeamRepository)project.getOrigin();
        this.fServiceProviderDescriptor = new ServiceProviderDescriptor(linkType, project);
        this.fShell = shell;
        this.fGlobalConfigurationParameter = globalConfigurationParameter;
    }

    public CALMResourcePickerDialog(Shell shell, IRunnableContext runnableContext, String linkType, CALMLinkingCache calmLinkingCache, String globalConfigurationParameter) {
        this.fRunnableContext = runnableContext;
        Collection cachedLinkTypes = calmLinkingCache.getAvailableLinkTypes();
        CALMLinkTypeInformation linkTypeInfo = null;
        for (CALMLinkTypeInformation cachedInfo : cachedLinkTypes) {
            ILinkType cachedLinkType = cachedInfo.getItemLinkType();
            if (!linkType.equals(cachedLinkType.getLinkTypeId())) continue;
            linkTypeInfo = cachedInfo;
            break;
        }
        if (linkType == null) {
            throw new IllegalArgumentException();
        }
        this.fLinkType = linkTypeInfo;
        this.fServiceProviders = calmLinkingCache.getServiceProviders(this.fLinkType);
        this.fRepository = (ITeamRepository)calmLinkingCache.getProjectArea().getOrigin();
        this.fServiceProviderDescriptor = new ServiceProviderDescriptor(this.fLinkType, calmLinkingCache.getProjectArea());
        this.fShell = shell;
        this.fGlobalConfigurationParameter = globalConfigurationParameter;
    }

    @Deprecated
    public CALMResourcePickerDialog(IWorkbenchWindow window, CALMLinkTypeInformation linkType, IProjectAreaHandle project, Collection<ServiceProvider> serviceProviders) {
        this(null, (IRunnableContext)window, linkType, project, serviceProviders);
    }

    @Deprecated
    public CALMResourcePickerDialog(IWorkbenchWindow window, CALMLinkTypeInformation linkType, ITeamRepository repository, Collection<ServiceProvider> serviceProviders) {
        this.fRunnableContext = window;
        this.fLinkType = linkType;
        this.fServiceProviders = serviceProviders;
        this.fRepository = repository;
        this.fServiceProviderDescriptor = null;
        this.fShell = window.getShell();
        this.fGlobalConfigurationParameter = null;
    }

    public int open() {
        ServiceProviderSelectionDialog providerDialog = new ServiceProviderSelectionDialog(this.fLinkType, this.fServiceProviders, this.fRepository, this.fShell, this.fServiceProviderDescriptor, this.fGlobalConfigurationParameter);
        int result = providerDialog.open();
        this.fPickedReferences = result == 0 ? this.selectReferences(providerDialog) : Collections.emptySet();
        return result;
    }

    public int open2() {
        PickerSelectionDialog.SelectorArguments args = new PickerSelectionDialog.SelectorArguments();
        args.linkTargetDisplayName = this.fLinkType.getItemLinkType().getTargetEndPointDescriptor().getDisplayName();
        args.serviceProviders = ServiceProviderWrapper.create(this.fServiceProviders);
        args.pickerRetriever = new PickerSelectionDialog.PickerRetriever<ServiceProviderWrapper, PickerWrapper>(){

            @Override
            public PickerSelectionDialog.Pickers<PickerWrapper> getPickersForProvider(ServiceProviderWrapper wrapper, IProgressMonitor monitor) throws TeamRepositoryException {
                return CALMResourcePickerDialog.this.pickersForServiceProvider(wrapper.provider, monitor);
            }

            @Override
            public IStatus statusForError(TeamRepositoryException error, ServiceProviderWrapper wrapper) {
                return CALMResourcePickerDialog.this.createUserLevelStatus((Exception)((Object)error), wrapper.provider);
            }
        };
        PickerSelectionDialog pickerDialog = PickerSelectionDialog.create(this.fShell, args);
        int result = pickerDialog.open();
        this.fPickedReferences = result == 0 ? this.selectReferences((PickerWrapper)pickerDialog.getSelectedPicker()) : Collections.emptySet();
        return result;
    }

    private IStatus createUserLevelStatus(Exception ex, ServiceProvider provider) {
        Throwable target = ex.getCause() == null ? ex : ex.getCause();
        String host = URI.create(provider.getProviderServiceUrl()).getHost();
        Status status = target instanceof AuthenticationException ? new Status(2, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_WARNING_SERVICE_PROVIDER_ACCESS_DENIED, (Object)host, (Object[])new Object[0]), target) : (target instanceof SocketTimeoutException ? new Status(2, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_WARNING_SERVICE_PROVIDER_CONNECTION_TIMEOUT, (Object)host, (Object[])new Object[0]), target) : (target instanceof PermissionDeniedException ? new Status(4, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_ERROR_SERVICE_PROVIDER_PERMISSION_DENIED, (Object)host, (Object[])new Object[0]), target) : new Status(4, "com.ibm.team.calm.foundation.rcp.ui", NLS.bind((String)Messages.ServiceProviderSelectionDialog_ERROR_ACCESSING_SERVICE_DOCUMENT, (Object)host, (Object[])new Object[0]), target)));
        return status;
    }

    protected PickerSelectionDialog.Pickers<PickerWrapper> pickersForServiceProvider(ServiceProvider provider, IProgressMonitor monitor) throws TeamRepositoryException {
        PickerSelectionDialog.Pickers<PickerWrapper> result = new PickerSelectionDialog.Pickers<PickerWrapper>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IServiceProviderClient calmFoundationClient = (IServiceProviderClient)this.fRepository.getClientLibrary(IServiceProviderClient.class);
        progress.setTaskName(Messages.ServiceProviderSelectionDialog_TASK_FIND_REPOSITORY_CONNECTION);
        IProjectAreaHandle localProject = calmFoundationClient.findRepositoryConnection(provider, (IProgressMonitor)progress.newChild(1));
        if (localProject != null) {
            PickerWrapper selectWrapper;
            String targetResourceId = provider.getLinkTypeInfo().getTargetResourceId();
            PickerWrapper createWrapper = PickerWrapper.create(ItemPickerDialogRegistry.getItemPickerDescription(targetResourceId, OSLCResourceDescription.PickerType.CREATION), localProject);
            if (createWrapper != null) {
                result.creationPickers.add(createWrapper);
            }
            if ((selectWrapper = PickerWrapper.create(ItemPickerDialogRegistry.getItemPickerDescription(targetResourceId, OSLCResourceDescription.PickerType.SELECTION), localProject)) != null) {
                result.selectionPickers.add(selectWrapper);
            }
        }
        if (result.creationPickers.isEmpty() || result.selectionPickers.isEmpty()) {
            progress.setTaskName(Messages.ServiceProviderSelectionDialog_TASK_RETRIEVE_REMOTE_DIALOG_INFO);
            OSLCResourceDescription.ServiceDocument serviceDocument = calmFoundationClient.fetchServiceDocument(provider, (IProgressMonitor)progress.newChild(1));
            if (serviceDocument != null) {
                if (result.creationPickers.isEmpty()) {
                    result.creationPickers.addAll(PickerWrapper.create(this.sortPickers(serviceDocument.getPickerDescriptions(OSLCResourceDescription.PickerType.CREATION, this.fLinkType, this.fGlobalConfigurationParameter))));
                }
                if (result.selectionPickers.isEmpty()) {
                    result.selectionPickers.addAll(PickerWrapper.create(this.sortPickers(serviceDocument.getPickerDescriptions(OSLCResourceDescription.PickerType.SELECTION, this.fLinkType, this.fGlobalConfigurationParameter))));
                }
            }
        }
        return result;
    }

    private List<PickerDescription> sortPickers(List<PickerDescription> pickerDescriptions) {
        Comparator<PickerDescription> pickerDescriptionComparator = new Comparator<PickerDescription>(){
            Collator collator = CollatorCache.getInstance();

            @Override
            public int compare(PickerDescription p1, PickerDescription p2) {
                String right;
                String left = p1 != null ? p1.getTitle() : null;
                String string = right = p2 != null ? p2.getTitle() : null;
                if (left == null && right == null) {
                    return 0;
                }
                if (left == null) {
                    return 1;
                }
                if (right == null) {
                    return -1;
                }
                return this.collator.compare(left, right);
            }
        };
        if (pickerDescriptions != null && pickerDescriptions.size() > 1) {
            ArrayList<PickerDescription> sorted = new ArrayList<PickerDescription>(pickerDescriptions);
            Collections.sort(sorted, pickerDescriptionComparator);
            return sorted;
        }
        return pickerDescriptions;
    }

    public Collection<OSLCReference> openAndGetResults() {
        Runnable doOpen = new Runnable(){

            @Override
            public void run() {
                CALMResourcePickerDialog.this.open2();
            }
        };
        Display display = this.fShell.getDisplay();
        if (display.getThread() == Thread.currentThread()) {
            doOpen.run();
        } else {
            display.syncExec(doOpen);
        }
        return this.getPickedReferences();
    }

    public Collection<OSLCReference> getPickedReferences() {
        return this.fPickedReferences;
    }

    private Collection<OSLCReference> selectReferences(ServiceProviderSelectionDialog providerDialog) {
        ItemPickerDialogDescription pickerDialogDescription;
        if (providerDialog.getItemPickerDescription() != null && (pickerDialogDescription = providerDialog.getItemPickerDescription()) != null) {
            return this.selectResourcesWithRepositoryConnection(pickerDialogDescription, providerDialog.getLocalProject());
        }
        return this.selectResourcesWithRemotePickerDialog(providerDialog.getOSLCPickerDescription());
    }

    private Collection<OSLCReference> selectReferences(PickerWrapper picker) {
        Collection<OSLCReference> result = picker.isOslcPicker() ? this.selectResourcesWithRemotePickerDialog(picker.getOslcPicker()) : this.selectResourcesWithRepositoryConnection(picker.getSwtPicker(), picker.getProjectArea());
        return result;
    }

    private Collection<OSLCReference> selectResourcesWithRepositoryConnection(ItemPickerDialogDescription pickerDesc, IProjectAreaHandle project) {
        try {
            IItemPickerDialog pickerDialog = pickerDesc.getPickerDialog();
            if (pickerDialog instanceof AbstractItemPickerDialog) {
                List pickerIds;
                if (this.fLinkType != null && (pickerIds = this.fLinkType.getPickerIds(pickerDesc.getPickerType())) != null && pickerIds.size() > 0) {
                    ((AbstractItemPickerDialog)pickerDialog).setCalmItemType((String)pickerIds.get(0));
                }
                if (((AbstractItemPickerDialog)pickerDialog).open(this.fShell, project, this.fRunnableContext) == 0) {
                    return pickerDialog.getReferences();
                }
            } else {
                IWorkbenchWindow window;
                IWorkbenchWindow iWorkbenchWindow = window = this.fRunnableContext instanceof IWorkbenchWindow ? (IWorkbenchWindow)this.fRunnableContext : PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (pickerDialog.open(project, window) == 0) {
                    return pickerDialog.getReferences();
                }
            }
        }
        catch (TeamRepositoryException ex) {
            String message = NLS.bind((String)Messages.CALMResourcePickerDialog_ERROR_RETRIEVE_LOCAL_DIALOG, (Object)ex.getLocalizedMessage(), (Object[])new Object[0]);
            Status status = new Status(4, "com.ibm.team.calm.foundation.rcp.ui", 4, message, (Throwable)ex);
            ErrorDialog.openError((Shell)this.fShell, (String)Messages.CALMResourcePickerDialog_ERROR_TITLE, (String)message, (IStatus)status);
        }
        return Collections.emptySet();
    }

    private Collection<OSLCReference> selectResourcesWithRemotePickerDialog(PickerDescription pickerDesc) {
        OSLCPickerDialog dialog = new OSLCPickerDialog(this.fShell, pickerDesc);
        if (dialog.open() == 0) {
            return dialog.getReferences();
        }
        return Collections.emptySet();
    }

    private static class PickerWrapper {
        final PickerDescription oslcPicker;
        final ItemPickerDialogDescription swtPicker;
        final IProjectAreaHandle projectArea;

        public static Collection<PickerWrapper> create(Collection<PickerDescription> oslcPickers) {
            ArrayList<PickerWrapper> result = new ArrayList<PickerWrapper>(oslcPickers.size());
            for (PickerDescription d : oslcPickers) {
                result.add(new PickerWrapper(d, null, null));
            }
            return result;
        }

        public static PickerWrapper create(ItemPickerDialogDescription swtPicker, IProjectAreaHandle projectArea) {
            if (swtPicker == null) {
                return null;
            }
            return new PickerWrapper(null, swtPicker, projectArea);
        }

        private PickerWrapper(PickerDescription oslcPicker, ItemPickerDialogDescription swtPicker, IProjectAreaHandle projectArea) {
            this.oslcPicker = oslcPicker;
            this.swtPicker = swtPicker;
            this.projectArea = projectArea;
            Assert.isLegal((boolean)(oslcPicker == null ^ swtPicker == null), (String)"Must be a single picker type");
            Assert.isLegal((swtPicker == null || projectArea != null ? 1 : 0) != 0, (String)"Local pickers must have a project area");
        }

        public boolean isOslcPicker() {
            return this.oslcPicker != null;
        }

        public PickerDescription getOslcPicker() {
            Assert.isLegal((boolean)this.isOslcPicker());
            return this.oslcPicker;
        }

        public ItemPickerDialogDescription getSwtPicker() {
            Assert.isLegal((!this.isOslcPicker() ? 1 : 0) != 0);
            return this.swtPicker;
        }

        public IProjectAreaHandle getProjectArea() {
            return this.projectArea;
        }

        public String toString() {
            if (this.isOslcPicker()) {
                return this.getOslcPicker().getLabel();
            }
            return this.getSwtPicker().getLabel();
        }
    }

    class ServiceProviderDescriptor {
        private final CALMLinkTypeInformation fCalmLinkType;
        private final IProjectAreaHandle fProjectArea;

        private ServiceProviderDescriptor(CALMLinkTypeInformation calmLinkType, IProjectAreaHandle project) {
            this.fCalmLinkType = calmLinkType;
            this.fProjectArea = project;
        }

        CALMLinkTypeInformation getLinkTypeInformation() {
            return this.fCalmLinkType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fCalmLinkType == null ? 0 : this.fCalmLinkType.hashCode());
            result = 31 * result + (this.fProjectArea == null ? 0 : this.fProjectArea.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServiceProviderDescriptor other = (ServiceProviderDescriptor)obj;
            if (this.fCalmLinkType == null ? other.fCalmLinkType != null : !this.fCalmLinkType.equals(other.fCalmLinkType)) {
                return false;
            }
            return !(this.fProjectArea == null ? other.fProjectArea != null : !this.fProjectArea.equals((Object)other.fProjectArea));
        }
    }

    private static class ServiceProviderWrapper {
        final ServiceProvider provider;

        public static Collection<ServiceProviderWrapper> create(Collection<ServiceProvider> providers) {
            ArrayList<ServiceProviderWrapper> result = new ArrayList<ServiceProviderWrapper>(providers.size());
            for (ServiceProvider p : providers) {
                result.add(new ServiceProviderWrapper(p));
            }
            return result;
        }

        public ServiceProviderWrapper(ServiceProvider provider) {
            this.provider = provider;
        }

        public String toString() {
            return this.provider.getProviderName();
        }
    }
}

