/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.internal.preview;

import com.ibm.team.calm.foundation.client.preview.IResourceReference;
import com.ibm.team.calm.foundation.client.preview.ResourceReferenceResolver;
import com.ibm.team.calm.foundation.common.preview.ResourcePreview;
import com.ibm.team.calm.foundation.rcp.ui.internal.preview.Messages;
import com.ibm.team.foundation.common.internal.util.XMLBuilder;
import com.ibm.team.jface.preview.DomainAdapter;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.net.URI;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class ResourceReferenceDomainAdapter
extends DomainAdapter {
    public String generateContentAsText(Object input) {
        if (input instanceof IResourceReference) {
            IDomainAdapter adapter;
            Object resolved = ((IResourceReference)input).resolve();
            if (resolved instanceof ResourcePreview) {
                ResourcePreview ref = (ResourcePreview)resolved;
                if (ref.getTitle() != null) {
                    return ref.getTitle().getPlainText();
                }
            } else if (resolved != null && (adapter = DomainAdapterUtils.getDomainAdapter((Object)resolved)) != null) {
                return adapter.generateContentAsText(resolved);
            }
        }
        return "";
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        this.generateContentAsHTML(head, body, input, info, (IProgressMonitor)new NullProgressMonitor());
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info, IProgressMonitor monitor) {
        if (input instanceof IResourceReference) {
            IResourceReference reference = (IResourceReference)input;
            Object resolved = ((IResourceReference)input).resolve();
            if (resolved == null || resolved != null && resolved instanceof ResourcePreview && ((ResourcePreview)resolved).hasAuthenticationError()) {
                ResourceReferenceResolver resolver = new ResourceReferenceResolver();
                if (info.isHoverTooltip) {
                    try {
                        resolver.resolve((IReference)reference, 0, false, (IProgressMonitor)new NullProgressMonitor());
                        resolved = reference.resolve();
                    }
                    catch (AuthenticationException e) {
                        XMLBuilder builder = new XMLBuilder();
                        if (reference.getURI() != null && reference.getURI().isAbsolute()) {
                            builder.xml("<p>").plain(NLS.bind((String)Messages.ResourceReferenceDomainAdapter_F2_LOGIN_HOST, (Object)(String.valueOf(reference.getURI().getScheme()) + "://" + reference.getURI().getHost()), (Object[])new Object[0])).xml("</p>");
                        } else {
                            builder.xml("<p>").plain(Messages.ResourceReferenceDomainAdapter_F2_LOGIN).xml("</p>");
                        }
                        body.append(builder);
                        return;
                    }
                    catch (TeamRepositoryException e) {}
                } else {
                    try {
                        resolver.resolve((IReference)reference, 0, true, (IProgressMonitor)new NullProgressMonitor());
                        resolved = reference.resolve();
                    }
                    catch (AuthenticationException e) {
                        body.append(e.getMessage());
                    }
                    catch (TeamRepositoryException e) {
                        // empty catch block
                    }
                }
            }
            if (resolved != null && (!(resolved instanceof ResourcePreview) || resolved instanceof ResourcePreview && !((ResourcePreview)resolved).hasErrors())) {
                if (resolved instanceof ResourcePreview) {
                    ResourcePreview ref = (ResourcePreview)resolved;
                    if (ref.getSmallPreviewURI() == null && ref.getLargePreviewURI() == null) {
                        this.showTooltipForUnknownResource(body, reference, info);
                    } else if (info.isHoverTooltip) {
                        URI smallPreviewURI = ref.getSmallPreviewURI() != null ? ref.getSmallPreviewURI() : ref.getLargePreviewURI();
                        String smallPreviewURIString = smallPreviewURI.toString();
                        Long desiredWidth = ref.getSmallPreviewWidth() != null ? ref.getSmallPreviewWidth() : ref.getLargePreviewWidth();
                        Long desiredHeight = ref.getSmallPreviewHeight() != null ? ref.getSmallPreviewHeight() : ref.getLargePreviewHeight();
                        boolean hasQuery = smallPreviewURI.getQuery() != null;
                        smallPreviewURIString = String.valueOf(smallPreviewURIString) + (hasQuery ? "&_compactHover=true" : "?_compactHover=true");
                        this.loadCompactRendering(head, body, ref, URI.create(smallPreviewURIString), desiredWidth, desiredHeight, info);
                    } else {
                        URI largePreviewURI = ref.getLargePreviewURI() != null ? ref.getLargePreviewURI() : ref.getSmallPreviewURI();
                        Long desiredWidth = ref.getLargePreviewWidth() != null ? ref.getLargePreviewWidth() : ref.getSmallPreviewWidth();
                        Long desiredHeight = ref.getLargePreviewHeight() != null ? ref.getLargePreviewHeight() : ref.getSmallPreviewHeight();
                        this.loadCompactRendering(head, body, ref, largePreviewURI, desiredWidth, desiredHeight, info);
                    }
                } else {
                    IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter((Object)resolved);
                    if (adapter instanceof DomainAdapter) {
                        ((DomainAdapter)adapter).generateContentAsHTML(head, body, resolved, info, monitor);
                    } else if (adapter != null) {
                        adapter.generateContentAsHTML(head, body, input, info);
                    } else {
                        this.showTooltipForUnknownResource(body, reference, info);
                    }
                }
            } else {
                this.showTooltipForUnknownResource(body, reference, info);
            }
        }
    }

    private void showTooltipForUnknownResource(StringBuffer body, IResourceReference reference, IDomainAdapter.Info info) {
        String uri;
        XMLBuilder builder = new XMLBuilder();
        String comment = reference.getComment();
        String string = uri = reference.getURI() != null ? reference.getURI().toString() : null;
        if (info.isHoverTooltip) {
            if (comment != null && comment.length() > 0) {
                builder.plain(comment);
            } else if (uri != null && uri.length() > 0) {
                builder.plain(uri);
            }
        } else if (uri != null && uri.length() > 0 && comment != null && comment.length() > 0) {
            builder.xml("<a href=\"").plain(uri).xml("\">").plain(comment).xml("</a>");
        } else if (uri != null && uri.length() > 0) {
            builder.xml("<a href=\"").plain(uri).xml("\">").plain(uri).xml("</a>");
        } else if (comment != null && comment.length() > 0) {
            builder.plain(comment);
        }
        body.append(builder);
    }

    private void loadCompactRendering(HashMap head, StringBuffer body, ResourcePreview ref, URI previewUri, Long desiredWidth, Long desiredHeight, IDomainAdapter.Info info) {
        this.loadCompactRenderingWithIFrame(body, previewUri, desiredWidth, desiredHeight, info);
    }

    private void loadCompactRenderingWithIFrame(StringBuffer body, URI previewUri, Long desiredWidth, Long desiredHeight, IDomainAdapter.Info info) {
        String desiredWidthVal = desiredWidth != null ? desiredWidth.toString() : "100%";
        String desiredHeightVal = desiredHeight != null ? desiredHeight.toString() : "100%";
        XMLBuilder iFrame = new XMLBuilder();
        iFrame.xml("<iframe frameborder=\"0\" allowtransparency=\"true\" width=\"").plain(desiredWidthVal).xml("\" height=\"").plain(desiredHeightVal).xml("\" src=\"");
        iFrame.plain(previewUri.toString()).plain("#resourcedetailsmarker").xml("\"></iframe>");
        body.append(iFrame);
    }

    private void loadCompactRenderingWithMetaRefresh(HashMap head, StringBuffer body, ResourcePreview ref, URI previewUri, IDomainAdapter.Info info) {
        StringBuilder meta = new StringBuilder();
        meta.append("<meta HTTP-EQUIV=\"REFRESH\" content=\"1; url=");
        meta.append(previewUri);
        meta.append("#resourcedetailsmarker");
        meta.append("\">");
        head.put(previewUri, meta.toString());
        Long desiredWidth = info.isHoverTooltip ? ref.getSmallPreviewWidth() : ref.getLargePreviewWidth();
        Long desiredHeight = info.isHoverTooltip ? ref.getSmallPreviewHeight() : ref.getLargePreviewHeight();
        body.append("<div style=\"width: ").append(desiredWidth).append("px; height: ").append(desiredHeight).append("px;\">&nbsp;</div>");
    }

    public String generateTitle(Object input) {
        if (input instanceof IResourceReference) {
            IDomainAdapter adapter;
            Object resolved = ((IResourceReference)input).resolve();
            if (resolved instanceof ResourcePreview) {
                ResourcePreview ref = (ResourcePreview)resolved;
                if (ref.getTitle() != null) {
                    return ref.getTitle().getPlainText();
                }
            } else if (resolved != null && (adapter = DomainAdapterUtils.getDomainAdapter((Object)resolved)) != null) {
                return adapter.generateTitle(resolved);
            }
        }
        return "";
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        return Messages.ResourceReferenceDomainAdapter_LOADING_INFORMATION;
    }

    protected Object convertToDomainObject(Object object) {
        if (object instanceof IResourceReference) {
            return ((IResourceReference)object).resolve();
        }
        return null;
    }
}

