/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.internal.linking;

import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogElement;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;

public class ItemPickerDialogRegistry {
    static final String EXTENSION_POINT_ID = "itemPickerDialogs";
    static final String ELEMENT_DIALOG = "itemPickerDialog";
    static final String ELEMENT_DIALOG_DESCRIPTION = "dialogDescription";
    static final String ATTR_RESOURCE_ID = "resourceId";
    static final String ATTR_PICKER_TYPE = "pickerType";
    static final String ATTR_DIALOG_IMPLEMENTATION = "dialogImplementation";
    static final String VALUE_SELECTION_PICKER = "selection";
    static final String VALUE_CREATION_PICKER = "creation";
    private static ItemPickerDialogRegistry fgInstance;
    private Map<String, List<ItemPickerDialogDescription>> fItemToPickerDescriptionsMap = new HashMap<String, List<ItemPickerDialogDescription>>();

    public static ItemPickerDialogDescription getItemPickerDescription(String resourceId, OSLCResourceDescription.PickerType type) {
        List<ItemPickerDialogDescription> pickerDescriptions = ItemPickerDialogRegistry.getInstance().getDialogs(resourceId);
        if (pickerDescriptions != null) {
            for (ItemPickerDialogDescription cur : pickerDescriptions) {
                if (!type.equals((Object)cur.getPickerType())) continue;
                return cur;
            }
        }
        return null;
    }

    private static ItemPickerDialogRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new ItemPickerDialogRegistry();
            fgInstance.initialize();
        }
        return fgInstance;
    }

    public List<ItemPickerDialogDescription> getDialogs(String resourceId) {
        return this.fItemToPickerDescriptionsMap.get(resourceId);
    }

    private ItemPickerDialogRegistry() {
    }

    private void initialize() {
        new ItemPickerDialogRegistryReader().start();
    }

    private class ItemPickerDialogRegistryReader
    extends ExtensionRegistryReader<ItemPickerDialogElement> {
        ItemPickerDialogRegistryReader() {
            super("com.ibm.team.calm.foundation.rcp.ui", ItemPickerDialogRegistry.EXTENSION_POINT_ID);
        }

        protected ItemPickerDialogElement handleExtensionAdded(IConfigurationElement element) throws TeamServiceRegistryException {
            ItemPickerDialogElement descriptor = new ItemPickerDialogElement(element);
            ItemPickerDialogRegistry.this.fItemToPickerDescriptionsMap.put(descriptor.getResourceId(), descriptor.getDialogDescriptions());
            return descriptor;
        }

        protected void handleExtensionRemoved(IConfigurationElement element, ItemPickerDialogElement descriptor) throws TeamServiceRegistryException {
            descriptor.remove();
        }
    }
}

