/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.rcp.ui.internal.linking;

import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.ItemPickerDialogDescription;
import com.ibm.team.calm.foundation.rcp.ui.internal.linking.Messages;
import com.ibm.team.calm.foundation.rcp.ui.linking.IItemPickerDialog;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

class ItemPickerDialogDescriptionElement
extends AbstractElementDescriptor {
    protected ItemPickerDialogDescriptionElement(IConfigurationElement element) {
        super(element, "dialogDescription");
    }

    void remove() throws TeamServiceRegistryException {
    }

    public ItemPickerDialogDescription getDialogDescription() {
        return new ItemPickerDialogDescription(this);
    }

    public OSLCResourceDescription.PickerType getPickerType() {
        String pickerType = this.getAttribute("pickerType").toLowerCase();
        if ("creation".equals(pickerType)) {
            return OSLCResourceDescription.PickerType.CREATION;
        }
        return OSLCResourceDescription.PickerType.SELECTION;
    }

    public IItemPickerDialog getPickerDialog() throws TeamServiceRegistryException {
        return this.createItemPickerDialog();
    }

    private IItemPickerDialog createItemPickerDialog() throws TeamServiceRegistryException {
        IItemPickerDialog pickerDialog = null;
        String bundle = this.getBundleSymbolicName();
        String implementationClassName = this.getAttribute("dialogImplementation");
        try {
            Object instance = this.createInstance("dialogImplementation");
            if (instance == null) {
                String message = NLS.bind((String)Messages.ItemPickerDialogDescriptionElement_FailedToCreateServiceInstance, (Object)bundle, (Object[])new Object[]{implementationClassName});
                throw new TeamServiceRegistryException(message);
            }
            if (!(instance instanceof IItemPickerDialog)) {
                String message = NLS.bind((String)Messages.ItemPickerDialogDescriptionElement_ServiceImplementedDoesNotImplementIService, (Object)implementationClassName, (Object[])new Object[]{IItemPickerDialog.class.getName()});
                throw new TeamServiceRegistryException(message);
            }
            pickerDialog = (IItemPickerDialog)instance;
        }
        catch (CoreException ex) {
            IStatus status = ex.getStatus();
            TeamServiceRegistryException exp = new TeamServiceRegistryException(status.getMessage(), status.getException());
            String message = NLS.bind((String)Messages.ItemPickerDialogDescriptionElement_FailedToCreateServiceInstance, (Object)bundle, (Object[])new Object[]{implementationClassName});
            throw new TeamServiceRegistryException(message, (Throwable)exp);
        }
        return pickerDialog;
    }
}

