/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.linktypes.common.internal;

import com.ibm.team.links.common.ILinkTypeDTO;
import com.ibm.team.links.common.ILinkTypeWithExtendedProperties;
import com.ibm.team.links.common.LinkTypeExtendedProperty;
import com.ibm.team.links.common.internal.BasicLinkTypeDTOUtils;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.internal.linksDTO.BasicLinkTypeDTO;
import com.ibm.team.linktypes.common.ICustomLinkType;
import com.ibm.team.linktypes.common.ICustomLinkTypeDTO;
import com.ibm.team.linktypes.internal.dto.linktypesDTO.CustomLinkTypeDTO;
import com.ibm.team.linktypes.internal.dto.linktypesDTO.LinkTypePropertyDTO;
import com.ibm.team.linktypes.internal.dto.linktypesDTO.LinktypesDTOFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CustomLinkTypeDTOUtility {
    private CustomLinkTypeDTOUtility() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    public static CustomLinkTypeDTO toCustomLinkTypeDTO(ICustomLinkType linkType) {
        CustomLinkTypeDTO dto = LinktypesDTOFactory.eINSTANCE.createCustomLinkTypeDTO();
        dto.setBasicLinkType((ILinkTypeDTO)BasicLinkTypeDTOUtils.toBasicLinkTypeDTO((ILinkTypeWithExtendedProperties)linkType, (boolean)false));
        List properties = dto.getProperties();
        for (String propertyName : linkType.getPropertyNames()) {
            String value = linkType.getProperty(propertyName);
            LinkTypePropertyDTO propertyDto = LinktypesDTOFactory.eINSTANCE.createLinkTypePropertyDTO();
            propertyDto.setKey(propertyName);
            propertyDto.setValue(value);
            properties.add(propertyDto);
        }
        if (linkType.getSourceOslcResourceURI() != null) {
            dto.setSourceOslcResourceURI(linkType.getSourceOslcResourceURI().toString());
        }
        Collection<URI> resourceURIs = linkType.getTargetOslcResourceURIs();
        List dtoResource = dto.getTargetOslcResourceURIs();
        for (URI resource : resourceURIs) {
            dtoResource.add(resource.toString());
        }
        return dto;
    }

    public static final class CustomLinkTypeDTOConverter
    implements ICustomLinkType {
        private final CustomLinkTypeDTO dtoValue;
        private Map<String, String> propertyMap;

        public CustomLinkTypeDTOConverter(ICustomLinkTypeDTO dtoValue) {
            this.dtoValue = (CustomLinkTypeDTO)dtoValue;
        }

        public String getLinkTypeId() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.getLinkTypeId();
        }

        public IEndPointDescriptor getSourceEndPointDescriptor() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.getSourceEndPointDescriptor();
        }

        public IEndPointDescriptor getTargetEndPointDescriptor() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.getTargetEndPointDescriptor();
        }

        @Override
        public URI getSourceOslcResourceURI() {
            return URI.create(this.dtoValue.getSourceOslcResourceURI());
        }

        @Override
        public Collection<URI> getTargetOslcResourceURIs() {
            List resourceURIs = this.dtoValue.getTargetOslcResourceURIs();
            ArrayList<URI> resultURIs = new ArrayList<URI>(resourceURIs.size());
            for (String resource : resourceURIs) {
                resultURIs.add(URI.create(resource));
            }
            return Collections.unmodifiableList(resultURIs);
        }

        public boolean isConstrained() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.isConstrained();
        }

        public boolean isInternal() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.isInternal();
        }

        public String getComponentId() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.getComponentId();
        }

        public boolean isConfigAware() {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.isConfigAware();
        }

        public Object getExtendedProperty(LinkTypeExtendedProperty property) {
            ILinkTypeWithExtendedProperties linkType = this.getBasicLinkType();
            return linkType.getExtendedProperty(property);
        }

        @Override
        public String getProperty(String key) {
            this.setupPropertyMap();
            return this.propertyMap.get(key);
        }

        @Override
        public Collection<String> getPropertyNames() {
            this.setupPropertyMap();
            return Collections.unmodifiableCollection(this.propertyMap.keySet());
        }

        private ILinkTypeWithExtendedProperties getBasicLinkType() {
            BasicLinkTypeDTO linkTypeDto = (BasicLinkTypeDTO)this.dtoValue.getBasicLinkType();
            ILinkTypeWithExtendedProperties linkType = BasicLinkTypeDTOUtils.toBasicLinkType((BasicLinkTypeDTO)linkTypeDto);
            return linkType;
        }

        private synchronized void setupPropertyMap() {
            if (this.propertyMap == null) {
                this.propertyMap = new HashMap<String, String>();
            }
            List properties = this.dtoValue.getProperties();
            for (LinkTypePropertyDTO entry : properties) {
                this.propertyMap.put(entry.getKey(), entry.getValue());
            }
        }
    }
}

