/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.linktypes.common.internal;

import com.ibm.team.links.common.BasicLinkTypeHandle;
import com.ibm.team.links.common.LinkTypeExtendedProperty;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.linktypes.common.ICustomLinkType;
import com.ibm.team.linktypes.common.internal.CustomEndPointDescriptor;
import com.ibm.team.linktypes.common.internal.CustomLinkTypeDTOUtility;
import com.ibm.team.repository.common.IDtoConverter;
import com.ibm.team.repository.common.IDtoReverseConverter;
import com.ibm.team.repository.common.IItemType;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CustomLinkType
implements ICustomLinkType,
IDtoConverter<ICustomLinkType> {
    private final String linkTypeId;
    private final String linkTypeInstanceId;
    private final String description;
    private final URI oslcPropertyUri;
    private final Map<String, String> properties;
    private final CustomEndPointDescriptor source;
    private final URI sourceOslcResourceURI;
    private final CustomEndPointDescriptor target;
    private final Collection<URI> targetOslcResourceURIs;

    public CustomLinkType(String linkTypeId, String linkTypeInstanceId, String description, URI oslcPropertyUri, Map<String, String> properties, IItemType source, String sourceLabel, String targetLabel, URI sourceOslcResourceURI, Collection<URI> targetOslcResourceURIs) {
        this.linkTypeId = linkTypeId;
        this.linkTypeInstanceId = linkTypeInstanceId;
        this.description = description;
        this.oslcPropertyUri = oslcPropertyUri;
        this.properties = new HashMap<String, String>(properties);
        this.source = new CustomEndPointDescriptor(source, true, targetLabel);
        IItemType target = null;
        this.target = new CustomEndPointDescriptor(target, false, sourceLabel);
        this.sourceOslcResourceURI = sourceOslcResourceURI;
        this.targetOslcResourceURIs = targetOslcResourceURIs != null ? Collections.unmodifiableCollection(targetOslcResourceURIs) : Collections.emptyList();
    }

    public String getLinkTypeId() {
        return this.linkTypeId;
    }

    public IEndPointDescriptor getSourceEndPointDescriptor() {
        return this.source;
    }

    @Override
    public URI getSourceOslcResourceURI() {
        return this.sourceOslcResourceURI;
    }

    public IEndPointDescriptor getTargetEndPointDescriptor() {
        return this.target;
    }

    @Override
    public Collection<URI> getTargetOslcResourceURIs() {
        return this.targetOslcResourceURIs;
    }

    public boolean isConstrained() {
        return false;
    }

    public boolean isInternal() {
        return false;
    }

    public String getComponentId() {
        return null;
    }

    public boolean isConfigAware() {
        return false;
    }

    public Object getExtendedProperty(LinkTypeExtendedProperty property) {
        switch (property) {
            case MODIFIABLE: {
                return true;
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
            case OSLC_URI: {
                return this.getOslcPropertyUri();
            }
            case LINK_TYPE_HANDLE: {
                return new BasicLinkTypeHandle(this.linkTypeId, this.linkTypeInstanceId);
            }
        }
        return null;
    }

    private URI getOslcPropertyUri() {
        return this.oslcPropertyUri;
    }

    private String getDescription() {
        return this.description;
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableCollection(this.properties.keySet());
    }

    public IDtoReverseConverter<ICustomLinkType> toDtoObject() {
        return CustomLinkTypeDTOUtility.toCustomLinkTypeDTO(this);
    }
}

