/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.linktypes.common.internal;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.common.internal.CustomLinkType;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class CustomEndPointDescriptor
implements IEndPointDescriptor {
    private static final String ZERO_TO_MANY = "0..n";
    private CustomLinkType linkType;
    private boolean isSource;
    private String displayName;
    private String id;
    private IItemType itemType;
    private boolean isItemReference;

    CustomEndPointDescriptor(String id, boolean isSource, String displayName) {
        this.isItemReference = false;
        this.itemType = null;
        this.id = id;
        this.isSource = isSource;
        this.displayName = displayName;
        if (this.displayName == null) {
            throw new IllegalArgumentException("displayName cannot be null");
        }
    }

    CustomEndPointDescriptor(IItemType itemType, boolean isSource, String displayName) {
        this.isItemReference = itemType != null;
        this.id = null;
        this.itemType = itemType;
        this.isSource = isSource;
        this.displayName = displayName;
        if (this.displayName == null) {
            throw new IllegalArgumentException("displayName cannot be null");
        }
    }

    public String getMultiplicity() {
        return ZERO_TO_MANY;
    }

    public ILinkType getLinkType() {
        return this.linkType;
    }

    public IItemType getReferencedItemType() {
        return this.itemType;
    }

    public boolean isItemReference() {
        return this.isItemReference;
    }

    public boolean isMultiValued() {
        return true;
    }

    public boolean isSingleValued() {
        return false;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public boolean isTarget() {
        return !this.isSource();
    }

    public boolean checkReferencedItemType(IItemHandle item) {
        IItemType type = item.getItemType();
        try {
            if (this.getReferencedItemType().getName().equals(type.getName()) && this.getReferencedItemType().getNamespaceURI().equals(type.getNamespaceURI())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setLinkType(CustomLinkType linkType) {
        this.linkType = linkType;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public URL getIcon() {
        return null;
    }

    public List<String> getURLContentTypes() {
        return new ArrayList<String>(0);
    }
}

