/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.linking.CALMArtifactTypeUtils;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.linktypes.common.IOslcArtifactTypeInfo;

public class RegistedOslcArtifactTypeInfo
implements IOslcArtifactTypeInfo {
    private static String PREFERRED_OSLC_VERSION = "2.0";
    private final OSLCResourceDescription oslcResourceDescription;
    private final String resourceTypeUri;

    static RegistedOslcArtifactTypeInfo createCALMRegistedArtifactTypeInfo(OSLCResourceDescription oslcResourceDescription) {
        if (oslcResourceDescription.getResourceVersions().size() > 0) {
            return new RegistedOslcArtifactTypeInfo(oslcResourceDescription);
        }
        return null;
    }

    private RegistedOslcArtifactTypeInfo(OSLCResourceDescription oslcResourceDescription) {
        this.oslcResourceDescription = oslcResourceDescription;
        OSLCResourceDescription.ResourceVersion resourceVersion = oslcResourceDescription.getResourceVersion(PREFERRED_OSLC_VERSION);
        if (resourceVersion == null) {
            resourceVersion = oslcResourceDescription.getResourceVersions().get(0);
        }
        this.resourceTypeUri = CALMArtifactTypeUtils.getOslcResourceUri(resourceVersion);
    }

    @Override
    public String getAnyOslcResourceTypeUri() {
        return this.resourceTypeUri;
    }

    @Override
    public String getResourceDisplayName() {
        return this.oslcResourceDescription.getResourceLabel();
    }
}

