/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.OSLCResourcePreviewProperties;
import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IConfigurationElement;

public class OSLCResourceDescriptionRegistry {
    public static final String CORE_DOMAIN = "oslc";
    public static final String AM_DOMAIN = "oslc_am";
    public static final String CM_DOMAIN = "oslc_cm";
    public static final String QM_DOMAIN = "oslc_qm";
    public static final String RM_DOMAIN = "oslc_rm";
    public static final String SCM_DOMAIN = "oslc_scm";
    private static OSLCResourceDescriptionRegistry fgInstance;
    private static final FoundationLog LOGGER;
    private final Map<String, OSLCResourceDescription> fResourceDescriptions = new HashMap<String, OSLCResourceDescription>();

    static {
        LOGGER = FoundationLog.getLog(ExtensionRegistryReader.class);
    }

    public static synchronized OSLCResourceDescriptionRegistry getInstance() {
        if (fgInstance == null) {
            fgInstance = new OSLCResourceDescriptionRegistry();
            fgInstance.initialize();
        }
        return fgInstance;
    }

    private OSLCResourceDescriptionRegistry() {
    }

    public OSLCResourceDescription getResourceDescription(String resourceId) {
        return this.fResourceDescriptions.get(resourceId);
    }

    Collection<OSLCResourceDescription> getAllResourceDescriptions() {
        return Collections.unmodifiableCollection(this.fResourceDescriptions.values());
    }

    private void initialize() {
        new OSLCResourceExtensionRegistryReader().start();
    }

    private void addResourceDescription(OSLCResourceDescription description) {
        this.fResourceDescriptions.put(description.getResourceId(), description);
    }

    private class OSLCResourceDescriptor
    extends AbstractElementDescriptor {
        private static final String ELEMENT = "oslcResources";
        private static final String NS_ELEMENT = "ns";
        private static final String VERSION_ELEMENT = "version";
        private static final String OSLC_RESOURCE_DESC_ELEMENT = "oslcResource";
        private static final String SERVICE_DESC_ELEMENT = "serviceDescription";
        private static final String RESOURCE_VERSION_ELEMENT = "resourceVersion";
        private static final String PICKER_DESC_ELEMENT = "pickerDescription";
        private static final String FILTER_DESC_ELEMENT = "filterDescription";
        private static final String BACK_LINK_OPERATION_ELEMENT = "backLinkOperation";
        private static final String RESOURCE_UPDATER_ELEMENT = "resourceUpdater";
        private static final String PROPERTY_ELEMENT = "property";
        private static final String ATTR_TYPE = "type";
        private static final String ATTR_BASE_PATH = "basePath";
        private static final String ATTR_PICKER_URL_PATH = "pickerURLPath";
        private static final String ATTR_FILTER_URL_PATH = "filterURLPath";
        private static final String ATTR_DIALOG_TITLE_PATH = "dialogTitlePath";
        private static final String ATTR_TITLE_PATH = "titlePath";
        private static final String ATTR_LABEL_PATH = "labelPath";
        private static final String ATTR_WIDTH_HINT_PATH = "widthHintPath";
        private static final String ATTR_HEIGHT_HINT_PATH = "heightHintPath";
        private static final String ATTR_IS_DEFAULT_PATH = "isDefaultPath";
        private static final String ATTR_ID_PATH = "idPath";
        private static final String ATTR_USAGE_PATH = "usagePath";
        private static final String ATTR_RETURN_PROTOCOL = "returnProtocol";
        private static final String ATTR_ID = "id";
        private static final String ATTR_URI = "uri";
        private static final String ATTR_RESOURCE_ID = "resourceId";
        private static final String ATTR_RESOURCE_LABEL = "resourceLabel";
        private static final String ATTR_RESOURCE_OSLC_DOMAIN = "oslcDomain";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_NS = "ns";
        private static final String ATTR_CONTENT_TYPE = "contentType";
        private static final String ATTR_ELEMENT_NAME = "elementName";
        private static final String ATTR_ELEMENT_NAMESPACE = "elementNamespace";
        private static final String ATTR_HTTP_HEADER = "httpHeader";
        private static final String ATTR_HTTP_HEADER_KEY = "key";
        private static final String ATTR_HTTP_HEADER_VALUE = "value";
        private static final String TYPE_SELECTION = "selection";
        private static final String TYPE_CREATION = "creation";
        private Map<String, String> fNamespaces;

        protected OSLCResourceDescriptor(IConfigurationElement element) {
            super(element, ELEMENT);
        }

        void remove() throws TeamServiceRegistryException {
        }

        protected void processChild(IConfigurationElement child) {
            String elementName = child.getName();
            if (elementName.equals("ns")) {
                String id = child.getAttribute(ATTR_ID);
                String uri = child.getAttribute(ATTR_URI);
                if (this.fNamespaces == null) {
                    this.fNamespaces = new HashMap<String, String>();
                }
                this.fNamespaces.put(id, uri);
            } else if (elementName.equals(OSLC_RESOURCE_DESC_ELEMENT)) {
                String resourceId = child.getAttribute(ATTR_RESOURCE_ID);
                String oslcDomain = child.getAttribute(ATTR_RESOURCE_OSLC_DOMAIN);
                String resourceLabel = child.getAttribute(ATTR_RESOURCE_LABEL);
                IConfigurationElement[] versionConfs = child.getChildren(VERSION_ELEMENT);
                ArrayList<OSLCResourceDescription.ServiceDescription> serviceDescriptions = new ArrayList<OSLCResourceDescription.ServiceDescription>(versionConfs.length);
                ArrayList<OSLCResourceDescription.ResourceVersion> resourceVersions = new ArrayList<OSLCResourceDescription.ResourceVersion>(versionConfs.length);
                OSLCResourceDescription oslcResource = new OSLCResourceDescription(resourceId, resourceLabel, oslcDomain, serviceDescriptions, resourceVersions, new CustomNamespaceContext(this.fNamespaces));
                IConfigurationElement[] iConfigurationElementArray = versionConfs;
                int n = versionConfs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] serviceConfs;
                    IConfigurationElement currVersionConf = iConfigurationElementArray[n2];
                    String version = currVersionConf.getAttribute(ATTR_NAME);
                    OSLCResourceDescription.ResourceVersion currResourceVersion = null;
                    IConfigurationElement[] resourceConfs = currVersionConf.getChildren(RESOURCE_VERSION_ELEMENT);
                    if (resourceConfs.length > 0) {
                        if (resourceConfs.length > 1) {
                            LOGGER.error(MessageFormat.format("More than one resource version registered for {0} ({1}). Will take first instance.", resourceId, version), null);
                        }
                        currResourceVersion = this.createResourceVersion(oslcResource, resourceConfs[0], version, resourceId);
                        resourceVersions.add(currResourceVersion);
                    }
                    if ((serviceConfs = currVersionConf.getChildren(SERVICE_DESC_ELEMENT)).length > 0) {
                        if (serviceConfs.length > 1) {
                            LOGGER.error(MessageFormat.format("More than one service description registered for {0} ({1}). Will take first instance.", resourceId, version), null);
                        }
                        IConfigurationElement serviceConf = serviceConfs[0];
                        OSLCResourceDescription.ServiceDescription curServiceDesc = new OSLCResourceDescription.ServiceDescription(oslcResource, version, serviceConf.getAttribute(ATTR_CONTENT_TYPE), this.getHTTPHeaders(serviceConf));
                        curServiceDesc.setPickerDescriptions(this.processPickerDescriptions(serviceConf));
                        curServiceDesc.setFilterServiceDescriptions(this.processFilterDescriptions(serviceConf));
                        serviceDescriptions.add(curServiceDesc);
                    }
                    ++n2;
                }
                Comparator<OSLCResourceDescription.AbstractResourceVersion> comparator = new Comparator<OSLCResourceDescription.AbstractResourceVersion>(){

                    @Override
                    public int compare(OSLCResourceDescription.AbstractResourceVersion d1, OSLCResourceDescription.AbstractResourceVersion d2) {
                        return d2.getVersion().compareTo(d1.getVersion());
                    }
                };
                Collections.sort(serviceDescriptions, comparator);
                Collections.sort(resourceVersions, comparator);
                OSLCResourceDescriptionRegistry.this.addResourceDescription(oslcResource);
            } else {
                super.processChild(child);
            }
        }

        /*
         * Unable to fully structure code
         */
        private Map<OSLCResourceDescription.PickerType, OSLCResourceDescription.PickerServiceDescription> processPickerDescriptions(IConfigurationElement serviceDescElem) {
            result = new HashMap<OSLCResourceDescription.PickerType, OSLCResourceDescription.PickerServiceDescription>(2);
            var7_4 = children = serviceDescElem.getChildren("pickerDescription");
            var6_5 = children.length;
            var5_6 = 0;
            while (var5_6 < var6_5) {
                block3: {
                    attr = var7_4[var5_6];
                    type = attr.getAttribute("type");
                    if (!type.equals("creation")) break block3;
                    pickerType = OSLCResourceDescription.PickerType.CREATION;
                    ** GOTO lbl16
                }
                if (!type.equals("selection")) {
                    OSLCResourceDescriptionRegistry.access$0().error(MessageFormat.format("Invalid picker description type ''{0}''", new Object[]{type}), null);
                } else {
                    pickerType = OSLCResourceDescription.PickerType.SELECTION;
lbl16:
                    // 2 sources

                    basePath = attr.getAttribute("basePath");
                    pickerURLPath = attr.getAttribute("pickerURLPath");
                    dialogTitlePath = attr.getAttribute("dialogTitlePath");
                    labelPath = attr.getAttribute("labelPath");
                    widthHintPath = attr.getAttribute("widthHintPath");
                    heightHintPath = attr.getAttribute("heightHintPath");
                    returnProtocol = attr.getAttribute("returnProtocol");
                    identifierPath = attr.getAttribute("idPath");
                    isDefaultPath = attr.getAttribute("isDefaultPath");
                    usagePath = attr.getAttribute("usagePath");
                    result.put(pickerType, new OSLCResourceDescription.PickerServiceDescription(basePath, pickerURLPath, dialogTitlePath, labelPath, widthHintPath, heightHintPath, returnProtocol, identifierPath, isDefaultPath, usagePath));
                }
                ++var5_6;
            }
            return result;
        }

        private Map<String, OSLCResourceDescription.FilterServiceDescription> processFilterDescriptions(IConfigurationElement serviceDescElem) {
            IConfigurationElement[] children;
            HashMap<String, OSLCResourceDescription.FilterServiceDescription> result = new HashMap<String, OSLCResourceDescription.FilterServiceDescription>(2);
            IConfigurationElement[] iConfigurationElementArray = children = serviceDescElem.getChildren(FILTER_DESC_ELEMENT);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement attr = iConfigurationElementArray[n2];
                String id = attr.getAttribute(ATTR_ID);
                String basePath = attr.getAttribute(ATTR_BASE_PATH);
                String filterURLPath = attr.getAttribute(ATTR_FILTER_URL_PATH);
                String titlePath = attr.getAttribute(ATTR_TITLE_PATH);
                result.put(id, new OSLCResourceDescription.FilterServiceDescription(id, basePath, filterURLPath, titlePath));
                ++n2;
            }
            return result;
        }

        private OSLCResourceDescription.ResourceVersion createResourceVersion(OSLCResourceDescription oslcResource, IConfigurationElement resourceConf, String version, String resourceId) {
            IConfigurationElement[] propertyConfs;
            QName qualifiedName;
            IConfigurationElement[] backLinkOperationConfs = resourceConf.getChildren(BACK_LINK_OPERATION_ELEMENT);
            IConfigurationElement backLinkOperationConf = null;
            if (backLinkOperationConfs.length > 0) {
                if (backLinkOperationConfs.length > 1) {
                    LOGGER.error(MessageFormat.format("More than one back link operation registered for {0}. Will take first instance.", resourceId), null);
                }
                backLinkOperationConf = backLinkOperationConfs[0];
            }
            String elementNSPrefix = resourceConf.getAttribute(ATTR_ELEMENT_NAMESPACE);
            String elementNamespace = this.fNamespaces.get(elementNSPrefix);
            String elementName = resourceConf.getAttribute(ATTR_ELEMENT_NAME);
            if (elementName == null || elementNSPrefix == null || !this.isNullOrEmpty(elementNSPrefix) && elementNamespace == null) {
                LOGGER.error(MessageFormat.format("Invalid resource element name or namespace in {0} ({1})", resourceId, version), null);
                qualifiedName = null;
            } else {
                qualifiedName = new QName(elementNamespace, elementName);
            }
            IConfigurationElement[] resourceUpdaterConfs = resourceConf.getChildren(RESOURCE_UPDATER_ELEMENT);
            IConfigurationElement resourceUpdaterConf = null;
            if (resourceUpdaterConfs.length > 0) {
                if (resourceUpdaterConfs.length > 1) {
                    LOGGER.error(MessageFormat.format("More than one resource updater registered for {0}. Will take first instance.", resourceId), null);
                }
                resourceUpdaterConf = resourceUpdaterConfs[0];
            }
            ArrayList<OSLCResourceDescription.ResourcePropertyDescription> propertyDescriptions = new ArrayList<OSLCResourceDescription.ResourcePropertyDescription>();
            IConfigurationElement[] iConfigurationElementArray = propertyConfs = resourceConf.getChildren(PROPERTY_ELEMENT);
            int n = propertyConfs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement currConf = iConfigurationElementArray[n2];
                String id = currConf.getAttribute(ATTR_ID);
                String type = currConf.getAttribute(ATTR_TYPE);
                String name = currConf.getAttribute(ATTR_NAME);
                String nsPrefix = currConf.getAttribute("ns");
                String namespace = this.fNamespaces.get(nsPrefix);
                if (this.isNullOrEmpty(id) || this.isNullOrEmpty(name) || this.isNullOrEmpty(namespace)) {
                    LOGGER.error(MessageFormat.format("Invalid property defined for {0} ({1}).", resourceId, version), null);
                } else {
                    OSLCResourceDescription.PropertyType propertyType = "simple".equals(type) ? OSLCResourceDescription.PropertyType.SIMPLE : OSLCResourceDescription.PropertyType.LINK;
                    propertyDescriptions.add(new OSLCResourceDescription.ResourcePropertyDescription(id, propertyType, new Property(namespace, name), nsPrefix));
                }
                ++n2;
            }
            propertyDescriptions.addAll(OSLCResourcePreviewProperties.getInstance().getAllProperties());
            return new OSLCResourceDescription.ResourceVersion(oslcResource, version, resourceConf.getAttribute(ATTR_CONTENT_TYPE), this.getHTTPHeaders(resourceConf), qualifiedName, backLinkOperationConf, resourceUpdaterConf, propertyDescriptions);
        }

        private boolean isNullOrEmpty(String str) {
            return str == null || str.length() == 0;
        }

        private Map<String, String> getHTTPHeaders(IConfigurationElement configElem) {
            HashMap<String, String> headers = new HashMap<String, String>();
            IConfigurationElement[] iConfigurationElementArray = configElem.getChildren(ATTR_HTTP_HEADER);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cur = iConfigurationElementArray[n2];
                headers.put(cur.getAttribute(ATTR_HTTP_HEADER_KEY), cur.getAttribute(ATTR_HTTP_HEADER_VALUE));
                ++n2;
            }
            return headers;
        }
    }

    private class OSLCResourceExtensionRegistryReader
    extends ExtensionRegistryReader<OSLCResourceDescriptor> {
        private static final String EXTENSION_POINT_ID = "oslcResourceDescriptions";

        OSLCResourceExtensionRegistryReader() {
            super("com.ibm.team.calm.foundation.common", EXTENSION_POINT_ID);
        }

        protected OSLCResourceDescriptor handleExtensionAdded(IConfigurationElement element) throws TeamServiceRegistryException {
            return new OSLCResourceDescriptor(element);
        }

        protected void handleExtensionRemoved(IConfigurationElement element, OSLCResourceDescriptor descriptor) throws TeamServiceRegistryException {
            descriptor.remove();
        }
    }
}

