/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.linking.CALMArtifactTypeUtils;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.common.ICustomLinkType;
import com.ibm.team.repository.common.IItemType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CALMLinkTypeInformationUtil {
    public static CALMLinkTypeInformation getLinkTypeInfoForCustomType(ILinkType linkType) {
        ICustomLinkType customLinkType;
        if (linkType instanceof ICustomLinkType && (customLinkType = (ICustomLinkType)linkType).getTargetOslcResourceURIs().size() > 0) {
            URI targetURI = customLinkType.getTargetOslcResourceURIs().iterator().next();
            OSLCResourceDescription resourceDesc = CALMArtifactTypeUtils.findArtifactTypeFromOslcResourceTypeUri(targetURI);
            if (resourceDesc == null) {
                return null;
            }
            return new CALMLinkTypeInformation(linkType, "tracks-changes", resourceDesc.getResourceId(), null, Arrays.asList("*"), Collections.emptyList(), false);
        }
        return null;
    }

    public static List<CALMLinkTypeInformation> getLinkTypeInformations(IItemType itemType, URI targetResourceType) {
        ArrayList<CALMLinkTypeInformation> result = new ArrayList<CALMLinkTypeInformation>(7);
        OSLCResourceDescription targetResource = CALMArtifactTypeUtils.findArtifactTypeFromOslcResourceTypeUri(targetResourceType);
        if (targetResource == null) {
            return result;
        }
        for (CALMLinkTypeInformation linkTypeInfo : CALMLinkTypeInformationRegistry.getAllLinkTypeInformations(itemType)) {
            if (!linkTypeInfo.getTargetResourceId().equals(targetResource.getResourceId())) continue;
            result.add(linkTypeInfo);
        }
        return result;
    }
}

