/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.linking.ILocalProjectLink;
import com.ibm.team.calm.foundation.common.linking.IProjectLinkingContext;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescriptionRegistry;
import com.ibm.team.calm.foundation.common.linking.PickerDescription;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.process.common.IProjectLink;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;

public class CALMLinkTypeInformation {
    private final ILinkType fItemLinkType;
    private final String fProjectLinkType;
    private final String fTargetResourceId;
    private final List<String> fSelectionPickerIds;
    private final List<String> fCreationPickerIds;
    private final String fTargetResourceBackLinkProperty;
    private final boolean fSupportsLocalLinks;

    public CALMLinkTypeInformation(ILinkType itemLinkType, String projectLinkId, String targetResourceId, String targetResourceBackLinkProperty, List<String> selectionPickerIds, List<String> creationPickerIds, boolean supportsLocalLinks) {
        this.fItemLinkType = itemLinkType;
        this.fProjectLinkType = projectLinkId;
        this.fTargetResourceId = targetResourceId;
        this.fTargetResourceBackLinkProperty = targetResourceBackLinkProperty;
        this.fSelectionPickerIds = selectionPickerIds;
        this.fCreationPickerIds = creationPickerIds;
        this.fSupportsLocalLinks = supportsLocalLinks;
    }

    public String getItemLinkTypeId() {
        return this.fItemLinkType.getLinkTypeId();
    }

    public ILinkType getItemLinkType() {
        return this.fItemLinkType;
    }

    public boolean hasBackLinkElement(String version) {
        if (this.fTargetResourceBackLinkProperty == null) {
            return false;
        }
        OSLCResourceDescription.ResourceVersion resourceDescription = this.getTargetResourceDescription().getResourceVersion(version);
        return resourceDescription != null && resourceDescription.getResourcePropertyDescription(this.fTargetResourceBackLinkProperty) != null;
    }

    public boolean hasBackLinkElement() {
        if (this.fTargetResourceBackLinkProperty == null) {
            return false;
        }
        List<OSLCResourceDescription.ResourceVersion> resourceVersions = this.getTargetResourceDescription().getResourceVersions();
        for (OSLCResourceDescription.ResourceVersion resourceVersion : resourceVersions) {
            if (resourceVersion.getResourcePropertyDescription(this.fTargetResourceBackLinkProperty) == null) continue;
            return true;
        }
        return false;
    }

    public BackLinkElement getBackLinkElement(String version) {
        OSLCResourceDescription.ResourcePropertyDescription propertyDesc;
        if (this.fTargetResourceBackLinkProperty == null) {
            return null;
        }
        OSLCResourceDescription.ResourceVersion resourceVersion = this.getTargetResourceDescription().getResourceVersion(version);
        if (resourceVersion != null && (propertyDesc = resourceVersion.getResourcePropertyDescription(this.fTargetResourceBackLinkProperty)) != null) {
            return new BackLinkElement(propertyDesc.getProperty(), resourceVersion.getVersion());
        }
        return null;
    }

    public List<BackLinkElement> getBackLinkElements() {
        if (this.fTargetResourceBackLinkProperty == null) {
            return Collections.emptyList();
        }
        List<OSLCResourceDescription.ResourceVersion> resourceVersions = this.getTargetResourceDescription().getResourceVersions();
        ArrayList<BackLinkElement> res = new ArrayList<BackLinkElement>(resourceVersions.size());
        for (OSLCResourceDescription.ResourceVersion resourceVersion : resourceVersions) {
            OSLCResourceDescription.ResourcePropertyDescription propertyDesc = resourceVersion.getResourcePropertyDescription(this.fTargetResourceBackLinkProperty);
            if (propertyDesc == null) continue;
            res.add(new BackLinkElement(propertyDesc.getProperty(), resourceVersion.getVersion()));
        }
        return res;
    }

    public String getProjectLinkType() {
        return this.fProjectLinkType;
    }

    public String getTargetResourceId() {
        return this.fTargetResourceId;
    }

    public String getTargetResourceBackLinkProperty() {
        return this.fTargetResourceBackLinkProperty;
    }

    public boolean supportsLocalLinks() {
        return this.fSupportsLocalLinks;
    }

    public String getProtocolId() {
        return this.getTargetResourceDescription().getOSLCDomain();
    }

    public OSLCResourceDescription getTargetResourceDescription() {
        return OSLCResourceDescriptionRegistry.getInstance().getResourceDescription(this.getTargetResourceId());
    }

    public IItemType getSourceItemType() {
        return this.getItemLinkType().getSourceEndPointDescriptor().getReferencedItemType();
    }

    public boolean supportsPicker(PickerDescription pickerDescription) {
        List<String> pickerIds = this.getPickerIds(pickerDescription.getPickerType());
        if (pickerIds.isEmpty()) {
            return pickerDescription.isDefault();
        }
        if (pickerIds.contains("*")) {
            return true;
        }
        for (String identifier : pickerDescription.getIdentifiers()) {
            if (!pickerIds.contains(identifier)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPickerServiceDescriptionForTarget() {
        OSLCResourceDescription description = this.getTargetResourceDescription();
        return description != null && description.hasPickerServiceDescription();
    }

    public boolean hasPickerConfiguration(OSLCResourceDescription.PickerType pickerType) {
        return !this.getPickerIds(pickerType).isEmpty();
    }

    public List<String> getPickerIds(OSLCResourceDescription.PickerType pickerType) {
        switch (pickerType) {
            case CREATION: {
                return this.fCreationPickerIds;
            }
            case SELECTION: {
                return this.fSelectionPickerIds;
            }
        }
        throw new IllegalArgumentException();
    }

    public Collection<ServiceProvider> getServiceProviders(IProjectLinkingContext linkingContext) throws TeamRepositoryException {
        ILocalProjectLink localProjectLink;
        ArrayList<ServiceProvider> result = new ArrayList<ServiceProvider>();
        for (IProjectLink projectLink : linkingContext.getActiveProjectLinks()) {
            if (!projectLink.getLinkType().equals(this.getProjectLinkType())) continue;
            result.add(new ServiceProvider(this, projectLink));
        }
        if (this.supportsLocalLinks() && (localProjectLink = linkingContext.getLocalProjectLink(this.getProtocolId())) != null) {
            result.add(new ServiceProvider(this, localProjectLink));
        }
        return result;
    }

    public Collection<ServiceProvider> getServiceProviders(Collection<IProjectLink> activeProjectLinks) {
        ArrayList<ServiceProvider> result = new ArrayList<ServiceProvider>();
        for (IProjectLink projectLink : activeProjectLinks) {
            if (!projectLink.getLinkType().equals(this.getProjectLinkType())) continue;
            result.add(new ServiceProvider(this, projectLink));
        }
        return result;
    }

    public boolean hasServiceProviders(Collection<IProjectLink> activeProjectLinks) {
        if (this.supportsLocalLinks()) {
            return true;
        }
        for (IProjectLink projectLink : activeProjectLinks) {
            if (!projectLink.getLinkType().equals(this.getProjectLinkType())) continue;
            return true;
        }
        return false;
    }

    public static class BackLinkElement {
        private final Property fProperty;
        private final String fVersion;

        BackLinkElement(Property property, String version) {
            this.fProperty = property;
            this.fVersion = version;
        }

        public BackLinkElement(QName qualifiedName, String version) {
            this(new Property(qualifiedName.getNamespaceURI(), qualifiedName.getLocalPart()), version);
        }

        public QName getQualifiedName() {
            return new QName(this.fProperty.getNamespaceURI(), this.fProperty.getName());
        }

        public String getTypeId() {
            return this.fProperty.getName();
        }

        public String getNamespaceURI() {
            return this.fProperty.getNamespaceURI();
        }

        public String getVersion() {
            return this.fVersion;
        }
    }
}

