/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.CALMDocument;
import com.ibm.team.calm.foundation.common.HttpHeaders;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.SecureDocumentBuilderFactory;
import com.ibm.team.calm.foundation.common.ServiceProvider;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.linking.ConfigurationManagementUtil;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.FilterDescription;
import com.ibm.team.calm.foundation.common.linking.IProjectLinkingContext;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.repository.common.InternalRepositoryException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.UriUtil;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class CALMFilterOperation {
    private static final String EMPTY_GC = "";
    private final IHttpClient fHttpClient;
    private final IProjectLinkingContext fLinkingContext;

    public static final CALMFilterOperation create(IHttpClient client, IProjectLinkingContext linkingContext) {
        return new CALMFilterOperation(client, linkingContext);
    }

    private CALMFilterOperation(IHttpClient client, IProjectLinkingContext linkingContext) {
        this.fHttpClient = client;
        this.fLinkingContext = linkingContext;
    }

    public List<FilterDescription> getFilterDescriptions(CALMLinkTypeInformation linkType, String filterId, Collection<String> resource, MultiStatus status) throws TeamRepositoryException {
        Collection<ServiceProvider> serviceProviders = linkType.getServiceProviders(this.fLinkingContext);
        ArrayList<FilterDescription> result = new ArrayList<FilterDescription>(serviceProviders.size());
        for (ServiceProvider serviceProvider : serviceProviders) {
            String message;
            String serviceURL = serviceProvider.getProviderServiceUrl();
            try {
                OSLCResourceDescription resourceDescription = serviceProvider.getLinkTypeInfo().getTargetResourceDescription();
                OSLCResourceDescription.ServiceDocument serviceDocument = resourceDescription.loadServiceDocument(serviceURL, this.fHttpClient);
                List<FilterDescription> filterDescription = serviceDocument.getFilterDescription(filterId);
                if (!filterDescription.isEmpty()) {
                    result.add(filterDescription.get(0));
                    continue;
                }
                throw new InternalRepositoryException(MessageFormat.format(Messages.getString("CALMFilterOperation.error_no_filter"), filterId, serviceURL));
            }
            catch (CALMDocument.DocumentParseException e) {
                message = Messages.getString("CALMFilterOperation.error_reading_filter_url");
                status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", message, (Throwable)((Object)e)));
            }
            catch (NotLoggedInException e) {
                throw e;
            }
            catch (TeamRepositoryException e) {
                message = NLS.bind((String)Messages.getString("CALMFilterOperation.error_access_service_document"), (Object)serviceURL);
                status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", message, (Throwable)e));
            }
        }
        return result;
    }

    public Collection<String> performCalmFilter(CALMLinkTypeInformation linkType, String filterId, Collection<String> inputResourceURLs, MultiStatus status) throws TeamRepositoryException {
        List<FilterDescription> filterDescriptions = this.getFilterDescriptions(linkType, filterId, inputResourceURLs, status);
        StringBuilder params = this.getFilterParams(inputResourceURLs, EMPTY_GC);
        HashSet<String> result = new HashSet<String>();
        for (FilterDescription filterDescription : filterDescriptions) {
            result.addAll(this.performCalmFilter2(EMPTY_GC, params, filterDescription, status));
        }
        return result;
    }

    public StringBuilder getFilterParams(Collection<String> inputResourceURLs, String globalConfiguration) {
        StringBuilder params = new StringBuilder("oslc_cm.properties=x");
        if (globalConfiguration != null && !globalConfiguration.equals(EMPTY_GC)) {
            params.append("&oslc_config.context=" + UriUtil.encode((String)globalConfiguration));
        }
        for (String resourceURL : inputResourceURLs) {
            params.append("&item=").append(UriUtil.encode((String)resourceURL));
        }
        return params;
    }

    public Collection<String> performCalmFilter2(String globalConfiguration, StringBuilder params, FilterDescription filterDescription, MultiStatus status) throws NotLoggedInException {
        HashSet<String> result = new HashSet<String>();
        if (globalConfiguration != null && !globalConfiguration.equals(EMPTY_GC) && !filterDescription.isGcAware()) {
            return result;
        }
        try {
            Reader reader;
            HttpHeaders headers = new HttpHeaders();
            headers.addHeader("Accept", HttpUtil.MediaType.APP.toString());
            IHttpClient.IResponse response = this.fHttpClient.performGetWithExtraParameters(filterDescription.getFilterURL(), params.toString(), HttpUtil.MediaType.FORM_URLENCODED.toString(), headers);
            if (response != null && (reader = response.getResponseReader()) != null) {
                this.parseAtomFeed(reader, result);
            }
        }
        catch (NotLoggedInException e) {
            throw e;
        }
        catch (TeamRepositoryException e) {
            String message = NLS.bind((String)Messages.getString("CALMFilterOperation.error_accessing_filter"), (Object)filterDescription.getFilterURL());
            status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", message, (Throwable)e));
        }
        return result;
    }

    public Collection<String> performCalmFilter(CALMLinkTypeInformation linkType, String filterId, Collection<String> inputResourceURLs, boolean resourceURLsAreGlobalConfigurationAware, MultiStatus status) throws TeamRepositoryException {
        List<FilterDescription> filterDescriptions = this.getFilterDescriptions(linkType, filterId, inputResourceURLs, status);
        if (resourceURLsAreGlobalConfigurationAware) {
            Map<String, Collection<String>> gcToResourceUrlMap = ConfigurationManagementUtil.buildGlobalConfigurationToResourceUrlMap(inputResourceURLs);
            return this.performCalmFilterWithGlobalConfigurations(linkType, filterId, filterDescriptions, status, gcToResourceUrlMap);
        }
        return this.performCalmFilter(linkType, filterId, inputResourceURLs, status);
    }

    private void parseAtomFeed(Reader reader, final Collection<String> result) throws TeamRepositoryException {
        try {
            try {
                DefaultHandler handler = new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) {
                        if ("link".equals(localName) && "via".equals(attributes.getValue("rel"))) {
                            String value = attributes.getValue("href");
                            result.add(value);
                        }
                    }
                };
                SAXParserFactory factory = SecureDocumentBuilderFactory.getSecureSAXParserFactory();
                factory.setNamespaceAware(true);
                SAXParser saxParser = factory.newSAXParser();
                saxParser.getXMLReader().setContentHandler(handler);
                saxParser.getXMLReader().setErrorHandler(handler);
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.parse(new InputSource(reader));
            }
            catch (IOException e) {
                throw new InternalRepositoryException(Messages.getString("CALMFilterOperation.error_parsing_filter_result"), (Throwable)e);
            }
            catch (SAXException e) {
                throw new InternalRepositoryException(Messages.getString("CALMFilterOperation.error_parsing_filter_result"), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new InternalRepositoryException(Messages.getString("CALMFilterOperation.error_parsing_filter_result"), (Throwable)e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean hasServiceProvider(CALMLinkTypeInformation linkType) throws TeamRepositoryException {
        return !linkType.getServiceProviders(this.fLinkingContext).isEmpty();
    }

    private StringBuilder buildGcAgnosticQueryParams(Map<String, Collection<String>> globalConfigurationToResourceUrlMap) {
        HashSet<String> itemsToFilter = new HashSet<String>();
        for (String gcKey : globalConfigurationToResourceUrlMap.keySet()) {
            itemsToFilter.addAll(globalConfigurationToResourceUrlMap.get(gcKey));
        }
        return this.getFilterParams(itemsToFilter, EMPTY_GC);
    }

    private Collection<String> performCalmFilterWithGlobalConfigurations(CALMLinkTypeInformation linkType, String filterId, List<FilterDescription> filterDescriptions, MultiStatus status, Map<String, Collection<String>> globalConfigurationToResourceUrlMap) throws TeamRepositoryException {
        HashSet<String> result = new HashSet<String>();
        Set<String> gcKeys = globalConfigurationToResourceUrlMap.keySet();
        HashSet<String> nonPleAwareResults = new HashSet<String>();
        StringBuilder nonGcAwareQueryParams = null;
        for (FilterDescription filterDescription : filterDescriptions) {
            if (filterDescription.isGcAware()) continue;
            nonGcAwareQueryParams = this.buildGcAgnosticQueryParams(globalConfigurationToResourceUrlMap);
            break;
        }
        for (String key : gcKeys) {
            Collection<String> inputResourceURLs = globalConfigurationToResourceUrlMap.get(key);
            StringBuilder params = this.getFilterParams(inputResourceURLs, key);
            for (FilterDescription filterDescription : filterDescriptions) {
                if (filterDescription.isGcAware()) {
                    if (EMPTY_GC.equals(key) && inputResourceURLs.size() == 0) continue;
                    Collection<String> filterResults = this.performCalmFilter2(key, params, filterDescription, status);
                    for (String link : filterResults) {
                        result.add(ConfigurationManagementUtil.appendConfigurationURIParameter(link, key, false));
                    }
                    continue;
                }
                nonPleAwareResults.addAll(this.performCalmFilter2(key, nonGcAwareQueryParams, filterDescription, status));
            }
        }
        for (String link : nonPleAwareResults) {
            for (String key : gcKeys) {
                result.add(ConfigurationManagementUtil.appendConfigurationURIParameter(link, key, false));
            }
        }
        return result;
    }
}

