/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.IBackLinkUpdater;
import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.OSLCResourceLogger;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.HttpClientWrapper;
import com.ibm.team.calm.foundation.common.internal.linking.IHttpAccess;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CALMBackLinkUpdater {
    public static final int PROBLEM_MODIFYING_CALM_LINK = 327680;
    public static final int PROBLEM_LOADING_CALM_LINK_WITH_GC_FOR_MODIFY = 327681;
    public static final int PROBLEM_MODIFYING_CALM_LINK_MERGED_STATUS = 327682;
    private final String fLinkedResourceUrl;
    private final String fLinkedResourceComment;
    private List<IBackLinkUpdater> fSuccessfulWrites;

    public CALMBackLinkUpdater(String linkedResourceUrl, String linkedResourceComment) throws IllegalArgumentException {
        if (linkedResourceUrl == null || linkedResourceComment == null) {
            throw new IllegalArgumentException();
        }
        this.fLinkedResourceUrl = linkedResourceUrl;
        this.fLinkedResourceComment = linkedResourceComment;
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<IReference> addedReferences, Collection<IReference> removedReferences, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType, boolean configurationAware, Set<String> gcLinkTypes, boolean requireConfigContextForBacklinkResolution) throws TeamRepositoryException {
        ArrayList<BackLinkChange> changes = new ArrayList<BackLinkChange>();
        this.populateChanges(addedReferences, OperationType.ADD, changes);
        this.populateChanges(removedReferences, OperationType.REMOVE, changes);
        return this.updateBacklinks(httpClient, changes, ignoreProblems, configurationManagementsByLinkType, configurationAware, gcLinkTypes, requireConfigContextForBacklinkResolution);
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<IReference> addedReferences, Collection<IReference> removedReferences, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType) throws TeamRepositoryException {
        return this.updateBacklinks(httpClient, addedReferences, removedReferences, ignoreProblems, configurationManagementsByLinkType, false, null, false);
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<IReference> addedReferences, Collection<IReference> removedReferences, boolean ignoreProblems) throws TeamRepositoryException {
        return this.updateBacklinks(httpClient, addedReferences, removedReferences, ignoreProblems, null);
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<BackLinkChange> changes, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType, boolean configurationAware, Set<String> gcLinkTypes, boolean requireConfigContextForBacklinkResolution) throws TeamRepositoryException {
        return this.updateBacklinksNew(httpClient, changes, ignoreProblems, configurationManagementsByLinkType, configurationAware, gcLinkTypes, requireConfigContextForBacklinkResolution);
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<BackLinkChange> changes, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType) throws TeamRepositoryException {
        return this.updateBacklinksNew(httpClient, changes, ignoreProblems, configurationManagementsByLinkType, false, null, false);
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<BackLinkChange> changes, boolean ignoreProblems) throws TeamRepositoryException {
        return this.updateBacklinksNew(httpClient, changes, ignoreProblems);
    }

    public IStatus updateBacklinks(IHttpAccess httpAccess, Collection<IReference> addedReferences, Collection<IReference> removedReferences, boolean ignoreProblems) throws TeamRepositoryException {
        httpAccess.setModifyingResponse(!ignoreProblems);
        return this.updateBacklinks((IHttpClient)new HttpClientWrapper(httpAccess), addedReferences, removedReferences, ignoreProblems);
    }

    public IStatus updateBacklinks(IHttpAccess httpAccess, Collection<BackLinkChange> changes, boolean ignoreProblems) throws TeamRepositoryException {
        httpAccess.setModifyingResponse(!ignoreProblems);
        return this.updateBacklinksNew(new HttpClientWrapper(httpAccess), changes, ignoreProblems);
    }

    private IStatus updateBacklinksNew(IHttpClient httpAccess, Collection<BackLinkChange> changes, boolean ignoreProblems) throws TeamRepositoryException {
        return this.updateBacklinksNew(httpAccess, changes, ignoreProblems, null);
    }

    private IStatus updateBacklinksNew(IHttpClient httpAccess, Collection<BackLinkChange> changes, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType) throws TeamRepositoryException {
        return this.updateBacklinksNew(httpAccess, changes, ignoreProblems, configurationManagementsByLinkType, false, null, false);
    }

    private IStatus updateBacklinksNew(IHttpClient httpAccess, Collection<BackLinkChange> changes, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType, boolean configurationAware, Set<String> gcLinkTypes, boolean requireConfigContextForBacklinkResolution) throws TeamRepositoryException {
        if (httpAccess == null) {
            return Status.OK_STATUS;
        }
        MultiStatus status = new MultiStatus("com.ibm.team.calm.foundation.common", 327680, Messages.getString("CALMBackLinkUpdater.PROBLEM_ADD_OR_REMOVE_BACKLINKS"), null);
        Map<String, List<BackLinkChange>> groupByResourceUri = this.groupByResourceUri(changes);
        Collection<IBackLinkUpdater> successfulReads = this.readRemoteResources(httpAccess, groupByResourceUri, status, ignoreProblems, configurationManagementsByLinkType, configurationAware, gcLinkTypes, requireConfigContextForBacklinkResolution);
        if (!status.isOK() && !ignoreProblems) {
            return this.mergeMultiStatus(status);
        }
        return this.tryToWriteModifications(successfulReads, ignoreProblems);
    }

    public void revert() {
        if (this.fSuccessfulWrites != null) {
            this.tryToRevertModifications(this.fSuccessfulWrites);
            this.fSuccessfulWrites = null;
        }
    }

    private void populateChanges(Collection<IReference> references, OperationType operationType, Collection<BackLinkChange> modifiedReferences) {
        if (references != null) {
            for (IReference reference : references) {
                String linkTypeId = reference.getLink().getLinkType().getLinkTypeId();
                modifiedReferences.add(new BackLinkChange(reference.createURI().toString(), linkTypeId, operationType));
            }
        }
    }

    private Map<String, List<BackLinkChange>> groupByResourceUri(Collection<BackLinkChange> changes) throws TeamRepositoryException {
        HashMap<String, List<BackLinkChange>> modifiedResources = new HashMap<String, List<BackLinkChange>>();
        for (BackLinkChange change : changes) {
            String sourceUrl = change.getUri();
            if (sourceUrl.equals(this.fLinkedResourceUrl)) continue;
            ArrayList<BackLinkChange> refs = (ArrayList<BackLinkChange>)modifiedResources.get(sourceUrl);
            if (refs == null) {
                refs = new ArrayList<BackLinkChange>();
                modifiedResources.put(sourceUrl, refs);
            }
            refs.add(change);
        }
        return modifiedResources;
    }

    private Collection<IBackLinkUpdater> readRemoteResources(IHttpClient httpAccess, Map<String, List<BackLinkChange>> changes, MultiStatus status, boolean ignoreProblems, Map<ILinkType, String> configurationManagementsByLinkType, boolean configurationAware, Set<String> gcLinkTypes, boolean requireConfigContextForBacklinkResolution) throws TeamRepositoryException {
        ArrayList<IBackLinkUpdater> result = new ArrayList<IBackLinkUpdater>();
        for (Map.Entry<String, List<BackLinkChange>> entry : changes.entrySet()) {
            IBackLinkUpdater resource;
            String sourceURL = entry.getKey();
            List<BackLinkChange> refs = entry.getValue();
            if (refs.isEmpty() || (resource = this.readRemoteResource(httpAccess, sourceURL, refs, configurationManagementsByLinkType, status, ignoreProblems, configurationAware, gcLinkTypes, requireConfigContextForBacklinkResolution)) == null) continue;
            result.add(resource);
        }
        return result;
    }

    private IBackLinkUpdater readRemoteResource(IHttpClient httpAccess, String sourceURL, List<BackLinkChange> refs, Map<ILinkType, String> configurationManagementsByLinkType, MultiStatus status, boolean ignoreProblems, boolean configurationAware, Set<String> gcLinkTypes, boolean requireConfigContextForBacklinkResolution) throws TeamRepositoryException {
        HashSet<String> changedProperties = new HashSet<String>();
        OSLCResourceDescription targetResourceDescription = null;
        String configurationManagement = null;
        boolean hasGCLinkType = false;
        boolean isDelete = false;
        for (BackLinkChange ref : refs) {
            CALMLinkTypeInformation calmLinkType = ref.getCALMLinkType();
            String backLinkProp = calmLinkType.getTargetResourceBackLinkProperty();
            if (backLinkProp != null) {
                changedProperties.add(backLinkProp);
            }
            targetResourceDescription = calmLinkType.getTargetResourceDescription();
            if (configurationManagementsByLinkType != null) {
                configurationManagement = configurationManagementsByLinkType.get(calmLinkType.getItemLinkType());
            }
            hasGCLinkType = hasGCLinkType || gcLinkTypes != null && gcLinkTypes.contains(calmLinkType.getItemLinkTypeId());
            boolean bl = isDelete = isDelete || ref.getOperationType() == OperationType.REMOVE;
        }
        if (targetResourceDescription != null && !changedProperties.isEmpty()) {
            String[] requiredProperties = changedProperties.toArray(new String[changedProperties.size()]);
            IBackLinkUpdater updater = null;
            try {
                updater = this.getResourceUpdater(targetResourceDescription, sourceURL, requiredProperties, httpAccess, configurationManagement);
                if (configurationAware && hasGCLinkType && configurationManagement == null && requireConfigContextForBacklinkResolution && !updater.requiresBacklink(changedProperties)) {
                    if (!isDelete) {
                        status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327681, " ", (Throwable)new TeamRepositoryException(null)));
                    }
                    return null;
                }
            }
            catch (NotLoggedInException ex) {
                if (!ignoreProblems) {
                    throw ex;
                }
            }
            catch (TeamRepositoryException ex) {
                if (configurationAware && hasGCLinkType) {
                    if (!isDelete) {
                        status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327681, ex.getMessage(), (Throwable)ex));
                    }
                } else {
                    status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327680, ex.getMessage(), (Throwable)ex));
                }
                return null;
            }
            if (updater == null) {
                ex = new TeamRepositoryException(NLS.bind((String)Messages.getString("CALMBackLinkUpdater.ERROR_UNKNOWN_VERSION"), (Object)sourceURL));
                if (configurationAware && hasGCLinkType) {
                    status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327681, ex.getMessage(), (Throwable)ex));
                } else {
                    status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327680, ex.getMessage(), (Throwable)ex));
                }
                return null;
            }
            for (BackLinkChange ref : refs) {
                String propertyId = ref.getCALMLinkType().getTargetResourceBackLinkProperty();
                try {
                    if (ref.getOperationType() == OperationType.ADD) {
                        updater.addLink(propertyId, this.fLinkedResourceUrl, this.fLinkedResourceComment);
                        continue;
                    }
                    updater.removeLink(propertyId, this.fLinkedResourceUrl);
                }
                catch (NotLoggedInException ex) {
                    if (ignoreProblems) continue;
                    throw ex;
                }
                catch (TeamRepositoryException ex) {
                    status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327680, ex.getMessage(), (Throwable)ex));
                    return null;
                }
            }
            return updater;
        }
        return null;
    }

    protected IBackLinkUpdater getResourceUpdater(OSLCResourceDescription targetResourceDescription, String sourceURL, String[] requiredProperties, IHttpClient httpAccess) throws TeamRepositoryException {
        return this.getResourceUpdater(targetResourceDescription, sourceURL, requiredProperties, httpAccess, null);
    }

    protected IBackLinkUpdater getResourceUpdater(OSLCResourceDescription targetResourceDescription, String sourceURL, String[] requiredProperties, IHttpClient httpAccess, String configurationManagement) throws TeamRepositoryException {
        return targetResourceDescription.loadResourceWithUpdater(sourceURL, null, configurationManagement, httpAccess, requiredProperties);
    }

    private IStatus tryToWriteModifications(Collection<IBackLinkUpdater> updaters, boolean ignoreProblems) throws NotLoggedInException {
        ArrayList<IBackLinkUpdater> result = new ArrayList<IBackLinkUpdater>();
        for (IBackLinkUpdater cur : updaters) {
            try {
                if (OSLCResourceLogger.getLog().isDebugEnabled()) {
                    OSLCResourceLogger.getLog().debug((Object)("[CALMBackLinkUpadater.writeModifications]\nWriting Work Item Back Link to: " + cur.getResourceURL()));
                }
                cur.write();
                result.add(cur);
            }
            catch (NotLoggedInException ex) {
                if (ignoreProblems) continue;
                this.tryToRevertModifications(result);
                throw ex;
            }
            catch (TeamRepositoryException ex) {
                if (ignoreProblems) continue;
                this.tryToRevertModifications(result);
                return new Status(4, "com.ibm.team.calm.foundation.common", 327680, ex.getMessage(), (Throwable)ex);
            }
        }
        this.fSuccessfulWrites = result;
        return Status.OK_STATUS;
    }

    private void tryToRevertModifications(Collection<IBackLinkUpdater> updates) {
        for (IBackLinkUpdater curOp : updates) {
            try {
                curOp.revert();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
    }

    private IStatus mergeMultiStatus(MultiStatus status) {
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            return children[0];
        }
        StringBuilder builder = new StringBuilder();
        boolean foundBacklinkStatus = false;
        boolean foundGCLStatus = false;
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus curChild = iStatusArray[n2];
            builder.append(curChild.getMessage()).append('|');
            if (curChild.getCode() == 327681) {
                foundGCLStatus = true;
            } else if (curChild.getCode() == 327680) {
                foundBacklinkStatus = true;
            }
            ++n2;
        }
        int statusCodeToReturn = 327680;
        if (foundBacklinkStatus && foundGCLStatus) {
            statusCodeToReturn = 327682;
        } else if (foundGCLStatus) {
            statusCodeToReturn = 327681;
        }
        return new Status(status.getSeverity(), status.getPlugin(), statusCodeToReturn, builder.toString(), null);
    }

    public static class BackLinkChange {
        private final String fTargetResourceUri;
        private final CALMLinkTypeInformation fCALMLinkType;
        private final OperationType fOperation;
        private final String fConfigurationManagement;

        public BackLinkChange(String targetResourceUri, String linkTypeId, CALMBackLinkOperation.OperationType operationType) {
            this(targetResourceUri, linkTypeId, operationType.toNew());
        }

        public BackLinkChange(String targetResourceUri, String linkTypeId, OperationType operationType) {
            this(targetResourceUri, linkTypeId, operationType, null);
        }

        public BackLinkChange(String targetResourceUri, String linkTypeId, OperationType operationType, String configurationManagement) {
            if (targetResourceUri == null || linkTypeId == null || operationType == null) {
                throw new IllegalArgumentException();
            }
            this.fTargetResourceUri = targetResourceUri;
            this.fCALMLinkType = CALMLinkTypeInformationRegistry.getLinkTypeInformation(linkTypeId);
            this.fOperation = operationType;
            this.fConfigurationManagement = configurationManagement;
        }

        public String getUri() {
            return this.fTargetResourceUri;
        }

        public CALMLinkTypeInformation getCALMLinkType() {
            return this.fCALMLinkType;
        }

        public OperationType getOperationType() {
            return this.fOperation;
        }

        public String getConfigurationManagement() {
            return this.fConfigurationManagement;
        }
    }

    public static enum OperationType {
        ADD,
        REMOVE;

    }
}

