/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.UnsupportedVersionException;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLink;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.HttpClientWrapper;
import com.ibm.team.calm.foundation.common.internal.linking.IHttpAccess;
import com.ibm.team.calm.foundation.common.linking.CALMBackLinkUpdater;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CALMBackLinkUpdate {
    private final CALMBackLink fBackLink;
    private final CALMBackLinkUpdater.OperationType fType;
    private CALMBackLinkOperation fCurrentOp;
    private final IHttpClient fHttpAccess;

    public CALMBackLinkUpdate(CALMBackLink backLink, CALMBackLinkOperation.OperationType type, IHttpAccess httpAccess) {
        this(backLink, type.toNew(), new HttpClientWrapper(httpAccess));
    }

    public CALMBackLinkUpdate(CALMBackLink backLink, CALMBackLinkUpdater.OperationType type, IHttpClient httpAccess) {
        this.fBackLink = backLink;
        this.fType = type;
        this.fHttpAccess = httpAccess;
    }

    public CALMBackLinkUpdater.OperationType getType() {
        return this.fType;
    }

    public CALMBackLinkOperation getUpdateOperation() {
        return this.fCurrentOp;
    }

    public void loadExistingState() throws TeamRepositoryException {
        OSLCResourceDescription resourceDescription = this.fBackLink.getLinkType().getTargetResourceDescription();
        List<OSLCResourceDescription.ResourceVersion> resourceVersions = resourceDescription.getResourceVersions();
        StringBuilder errorMessage = new StringBuilder();
        Iterator<OSLCResourceDescription.ResourceVersion> it = resourceVersions.iterator();
        while (it.hasNext()) {
            OSLCResourceDescription.ResourceVersion curVersion = it.next();
            CALMBackLinkOperation curUpdateOp = curVersion.createCALMBackLinkOperation();
            if (curUpdateOp == null) continue;
            try {
                curUpdateOp.initialize(this.fBackLink, this.fType, this.fHttpAccess);
                curUpdateOp.loadExistingState();
                this.fCurrentOp = curUpdateOp;
                break;
            }
            catch (NotLoggedInException ex) {
                throw ex;
            }
            catch (UnsupportedVersionException ex) {
                errorMessage.append('\n').append(ex.getMessage());
                if (it.hasNext()) continue;
                String message = NLS.bind((String)Messages.getString("CALMBackLinkUpdate.ERROR_ACCESSING_RESOURCE"), (Object)this.fBackLink.getSourceURL(), (Object)errorMessage.toString());
                throw new TeamRepositoryException(message, (Throwable)((Object)ex));
            }
        }
    }

    public void writeModications() throws TeamRepositoryException {
        if (this.fCurrentOp != null) {
            this.fCurrentOp.writeModications();
        }
    }

    public void revertModications() throws TeamRepositoryException {
        if (this.fCurrentOp != null) {
            this.fCurrentOp.revertModications();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fBackLink == null ? 0 : this.fBackLink.hashCode());
        result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CALMBackLinkUpdate other = (CALMBackLinkUpdate)obj;
        if (this.fBackLink == null ? other.fBackLink != null : !this.fBackLink.equals(other.fBackLink)) {
            return false;
        }
        return this.fType == other.fType;
    }
}

