/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescriptionRegistry;
import com.ibm.team.calm.foundation.common.linking.RegistedOslcArtifactTypeInfo;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.linktypes.common.ICustomLinkType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class CALMArtifactTypeUtils {
    public static Collection<RegistedOslcArtifactTypeInfo> getAllCalmArtifactTypes() {
        ArrayList<RegistedOslcArtifactTypeInfo> calmArtifactTypes = new ArrayList<RegistedOslcArtifactTypeInfo>();
        for (OSLCResourceDescription resourceDesc : OSLCResourceDescriptionRegistry.getInstance().getAllResourceDescriptions()) {
            RegistedOslcArtifactTypeInfo registedArtifactTypeInfo = RegistedOslcArtifactTypeInfo.createCALMRegistedArtifactTypeInfo(resourceDesc);
            if (registedArtifactTypeInfo == null) continue;
            calmArtifactTypes.add(registedArtifactTypeInfo);
        }
        return calmArtifactTypes;
    }

    public static Collection<RegistedOslcArtifactTypeInfo> getTargetArtifactTypeForLinkType(ILinkType linkType) {
        OSLCResourceDescription targetResourceDesc = null;
        if (linkType instanceof ICustomLinkType) {
            ICustomLinkType customLinkType = (ICustomLinkType)linkType;
            ArrayList<RegistedOslcArtifactTypeInfo> result = new ArrayList<RegistedOslcArtifactTypeInfo>(customLinkType.getTargetOslcResourceURIs().size());
            for (URI targetResource : customLinkType.getTargetOslcResourceURIs()) {
                if (targetResource == null || (targetResourceDesc = CALMArtifactTypeUtils.findArtifactTypeFromOslcResourceTypeUri(targetResource)) == null) continue;
                result.add(RegistedOslcArtifactTypeInfo.createCALMRegistedArtifactTypeInfo(targetResourceDesc));
            }
            return result;
        }
        CALMLinkTypeInformation calmLinkType = CALMLinkTypeInformationRegistry.getLinkTypeInformation(linkType);
        if (calmLinkType != null) {
            targetResourceDesc = calmLinkType.getTargetResourceDescription();
            return Arrays.asList(RegistedOslcArtifactTypeInfo.createCALMRegistedArtifactTypeInfo(targetResourceDesc));
        }
        return null;
    }

    static OSLCResourceDescription findArtifactTypeFromOslcResourceTypeUri(URI oslcResourceTypeUri) {
        for (OSLCResourceDescription resourceDesc : OSLCResourceDescriptionRegistry.getInstance().getAllResourceDescriptions()) {
            for (OSLCResourceDescription.ResourceVersion resourceVersion : resourceDesc.getResourceVersions()) {
                if (!oslcResourceTypeUri.toString().equals(CALMArtifactTypeUtils.getOslcResourceUri(resourceVersion))) continue;
                return resourceDesc;
            }
        }
        return null;
    }

    static String getOslcResourceUri(OSLCResourceDescription.ResourceVersion resourceVersion) {
        return String.valueOf(resourceVersion.getElementName().getNamespaceURI()) + resourceVersion.getElementName().getLocalPart();
    }
}

