/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.preview;

import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.internal.rcp.dto.impl.DTO_ResolutionErrorImpl;
import com.ibm.team.calm.foundation.common.preview.IResolutionError;

public class ResolutionError
extends DTO_ResolutionErrorImpl
implements IResolutionError {
    public ResolutionError(int errorCode, String errorMessage, boolean isAuthenticationError) {
        this.setErrorCode(errorCode);
        this.setErrorMessage(errorMessage);
        this.setAuthenticationError(isAuthenticationError);
    }

    public ResolutionError(IHttpClient.IResponse response) {
        this.setErrorCode(response.getStatusCode());
        this.setErrorMessage(response.getException() != null ? response.getException().getLocalizedMessage() : null);
        this.setAuthenticationError(response.getResponseHeaders().contains("X-jazz-web-oauth-url"));
    }

    public ResolutionError(String message) {
        this(0, message, false);
    }

    public ResolutionError(boolean isAuthenticationError) {
        this(0, null, isAuthenticationError);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IResolutionError other = (IResolutionError)obj;
        if (this.getErrorCode() != other.getErrorCode()) {
            return false;
        }
        if (!this.getErrorMessage().equals(other.getErrorMessage())) {
            return false;
        }
        return this.isAuthenticationError() == other.isAuthenticationError();
    }
}

