/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.preview;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.Namespaces;
import com.ibm.team.calm.foundation.common.Property;
import com.ibm.team.calm.foundation.common.internal.RDFUtils;
import com.ibm.team.calm.foundation.common.internal.preview.CompactRenderingDocument;
import com.ibm.team.calm.foundation.common.oslc.DublinCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.InputStream;

public class OslcCompactRenderingDocument
extends CompactRenderingDocument {
    private final CustomNamespaceContext fNamespaceContext = Namespaces.createDefaultContext();

    public OslcCompactRenderingDocument(String uri, InputStream inputStream) {
        super(uri, inputStream);
    }

    @Override
    protected void readDocument() throws TeamRepositoryException {
        try {
            Resource largePreview;
            Model model = ModelFactory.createDefaultModel();
            model.read(this.fInputStream, this.fUri);
            Resource compactRenderingDocument = RDFUtils.findResource(model, this.fUri);
            this.fAbout = compactRenderingDocument.getURI();
            this.fTitle = this.getStringValue(model, compactRenderingDocument, DublinCoreIdentifiers.TITLE);
            this.fAbbreviation = this.getStringValue(model, compactRenderingDocument, OSLCCoreIdentifiers.SHORT_TITLE);
            this.fIconURI = this.getResourceValue(model, compactRenderingDocument, OSLCCoreIdentifiers.ICON);
            Resource smallPreview = this.getResource(model, compactRenderingDocument, OSLCCoreIdentifiers.PROPERTY_CR_SMALL_PREVIEW);
            if (smallPreview != null) {
                Resource preview = smallPreview;
                if (smallPreview.hasProperty(this.toJena(model, OSLCCoreIdentifiers.PREVIEW_RESOURCE))) {
                    preview = this.getResource(model, smallPreview, OSLCCoreIdentifiers.PREVIEW_RESOURCE);
                }
                if (preview != null) {
                    this.fSmallPreview = this.getResourceValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_DOCUMENT);
                    if (this.fSmallPreview != null) {
                        this.fSmallPreviewWidth = this.getPixelsValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_HINT_WIDTH);
                        this.fSmallPreviewHeight = this.getPixelsValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_HINT_HEIGHT);
                        this.fSmallPreviewInitialHeight = this.getPixelsValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_INITIAL_HEIGHT);
                    }
                }
            }
            if ((largePreview = this.getResource(model, compactRenderingDocument, OSLCCoreIdentifiers.PROPERTY_CR_LARGE_PREVIEW)) != null) {
                Resource preview = largePreview;
                if (largePreview.hasProperty(this.toJena(model, OSLCCoreIdentifiers.PREVIEW_RESOURCE))) {
                    preview = this.getResource(model, largePreview, OSLCCoreIdentifiers.PREVIEW_RESOURCE);
                }
                if (preview != null) {
                    this.fLargePreview = this.getResourceValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_DOCUMENT);
                    if (this.fLargePreview != null) {
                        this.fLargePreviewWidth = this.getPixelsValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_HINT_WIDTH);
                        this.fLargePreviewHeight = this.getPixelsValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_HINT_HEIGHT);
                        this.fLargePreviewInitialHeight = this.getPixelsValue(model, preview, OSLCCoreIdentifiers.PROPERTY_PREVIEW_INITIAL_HEIGHT);
                    }
                }
            }
        }
        catch (RDFUtils.RDFParseException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private Resource getResource(Model model, Resource parent, Property property) {
        Resource resource = null;
        Statement stmt = parent.getProperty(this.toJena(model, property));
        if (stmt != null && stmt.getObject().isResource()) {
            resource = stmt.getObject().asResource();
        }
        return resource;
    }

    private String getStringValue(Model model, Resource resource, Property property) {
        String xmlString = null;
        Statement stmt = resource.getProperty(this.toJena(model, property));
        if (stmt != null && stmt.getObject().isLiteral()) {
            xmlString = stmt.getObject().asLiteral().getString();
        }
        return xmlString;
    }

    private String getResourceValue(Model model, Resource resource, Property property) {
        String uri = null;
        Statement stmt = resource.getProperty(this.toJena(model, property));
        if (stmt != null && stmt.getObject().isResource()) {
            uri = stmt.getObject().asResource().getURI();
        }
        return uri;
    }

    private Long getPixelsValue(Model model, Resource resource, Property property) {
        Long pixels = null;
        Statement stmt = resource.getProperty(this.toJena(model, property));
        if (stmt != null && stmt.getObject().isLiteral()) {
            String size = stmt.getObject().asLiteral().getString();
            pixels = this.convertToPixels(size);
        }
        return pixels;
    }

    private com.hp.hpl.jena.rdf.model.Property toJena(Model model, Property property) {
        String nsUri = property.getNamespaceURI();
        if (this.fNamespaceContext.contains(nsUri)) {
            model.setNsPrefix(this.fNamespaceContext.getPrefix(nsUri), nsUri);
        }
        return model.createProperty(property.getNamespaceURI(), property.getName());
    }
}

